/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.SimilarityScore;

public class LongestCommonSubsequence
implements SimilarityScore<Integer> {
    private static int[] algorithmB(CharSequence left, CharSequence right) {
        int m3 = left.length();
        int n2 = right.length();
        int[][] dpRows = new int[2][1 + n2];
        for (int i2 = 1; i2 <= m3; ++i2) {
            int[] temp = dpRows[0];
            dpRows[0] = dpRows[1];
            dpRows[1] = temp;
            for (int j2 = 1; j2 <= n2; ++j2) {
                dpRows[1][j2] = left.charAt(i2 - 1) == right.charAt(j2 - 1) ? dpRows[0][j2 - 1] + 1 : Math.max(dpRows[1][j2 - 1], dpRows[0][j2]);
            }
        }
        return dpRows[1];
    }

    private static String algorithmC(CharSequence left, CharSequence right) {
        int m3 = left.length();
        int n2 = right.length();
        StringBuilder out = new StringBuilder();
        if (m3 == 1) {
            char leftCh = left.charAt(0);
            for (int j2 = 0; j2 < n2; ++j2) {
                if (leftCh != right.charAt(j2)) continue;
                out.append(leftCh);
                break;
            }
        } else if (n2 > 0 && m3 > 1) {
            int mid = m3 / 2;
            CharSequence leftFirstPart = left.subSequence(0, mid);
            CharSequence leftSecondPart = left.subSequence(mid, m3);
            int[] l1 = LongestCommonSubsequence.algorithmB(leftFirstPart, right);
            int[] l2 = LongestCommonSubsequence.algorithmB(LongestCommonSubsequence.reverse(leftSecondPart), LongestCommonSubsequence.reverse(right));
            int k2 = 0;
            int t2 = 0;
            for (int j3 = 0; j3 <= n2; ++j3) {
                int s2 = l1[j3] + l2[n2 - j3];
                if (t2 >= s2) continue;
                t2 = s2;
                k2 = j3;
            }
            out.append(LongestCommonSubsequence.algorithmC(leftFirstPart, right.subSequence(0, k2)));
            out.append(LongestCommonSubsequence.algorithmC(leftSecondPart, right.subSequence(k2, n2)));
        }
        return out.toString();
    }

    private static String reverse(CharSequence s2) {
        return new StringBuilder(s2).reverse().toString();
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        int leftSz = left.length();
        int rightSz = right.length();
        if (leftSz == 0 || rightSz == 0) {
            return 0;
        }
        if (leftSz < rightSz) {
            return LongestCommonSubsequence.algorithmB(right, left)[leftSz];
        }
        return LongestCommonSubsequence.algorithmB(left, right)[rightSz];
    }

    @Deprecated
    public CharSequence logestCommonSubsequence(CharSequence left, CharSequence right) {
        return this.longestCommonSubsequence(left, right);
    }

    public CharSequence longestCommonSubsequence(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        int leftSz = left.length();
        int rightSz = right.length();
        if (leftSz == 0 || rightSz == 0) {
            return "";
        }
        if (leftSz < rightSz) {
            return LongestCommonSubsequence.algorithmC(right, left);
        }
        return LongestCommonSubsequence.algorithmC(left, right);
    }

    @Deprecated
    public int[][] longestCommonSubstringLengthArray(CharSequence left, CharSequence right) {
        int[][] lcsLengthArray = new int[left.length() + 1][right.length() + 1];
        for (int i2 = 0; i2 < left.length(); ++i2) {
            for (int j2 = 0; j2 < right.length(); ++j2) {
                if (i2 == 0) {
                    lcsLengthArray[i2][j2] = 0;
                }
                if (j2 == 0) {
                    lcsLengthArray[i2][j2] = 0;
                }
                lcsLengthArray[i2 + 1][j2 + 1] = left.charAt(i2) == right.charAt(j2) ? lcsLengthArray[i2][j2] + 1 : Math.max(lcsLengthArray[i2 + 1][j2], lcsLengthArray[i2][j2 + 1]);
            }
        }
        return lcsLengthArray;
    }
}

