/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;

public class FilterCollectionWriter
extends Writer {
    protected final Collection<Writer> EMPTY_WRITERS = Collections.emptyList();
    protected final Collection<Writer> writers;

    protected FilterCollectionWriter(Collection<Writer> writers) {
        this.writers = writers == null ? this.EMPTY_WRITERS : writers;
    }

    protected FilterCollectionWriter(Writer ... writers) {
        this.writers = writers == null ? this.EMPTY_WRITERS : Arrays.asList(writers);
    }

    private List<Exception> add(List<Exception> causeList, int i2, IOException e2) {
        if (causeList == null) {
            causeList = new ArrayList<Exception>();
        }
        causeList.add(new IOIndexedException(i2, (Throwable)e2));
        return causeList;
    }

    @Override
    public Writer append(char c2) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.append(c2);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("append", causeList);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.append(csq);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("append", causeList);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.append(csq, start, end);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("append", causeList);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.close();
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("close", causeList);
        }
    }

    @Override
    public void flush() throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.flush();
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("flush", causeList);
        }
    }

    private boolean notEmpty(List<Exception> causeList) {
        return causeList != null && !causeList.isEmpty();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.write(cbuf);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("write", causeList);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.write(cbuf, off, len);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("write", causeList);
        }
    }

    @Override
    public void write(int c2) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.write(c2);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("write", causeList);
        }
    }

    @Override
    public void write(String str) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.write(str);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("write", causeList);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        List<Exception> causeList = null;
        int i2 = 0;
        for (Writer w2 : this.writers) {
            if (w2 != null) {
                try {
                    w2.write(str, off, len);
                }
                catch (IOException e2) {
                    causeList = this.add(causeList, i2, e2);
                }
            }
            ++i2;
        }
        if (this.notEmpty(causeList)) {
            throw new IOExceptionList("write", causeList);
        }
    }
}

