/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.xml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.TemporalType;
import net.time4j.ZonalDateTime;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.scale.LeapSeconds;
import net.time4j.tz.ZonalOffset;

public abstract class XMLAdapter<S, T>
extends TemporalType<S, T> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final BigDecimal MRD_D = BigDecimal.valueOf(1000000000L);
    private static final BigInteger MRD_I = BigInteger.valueOf(1000000000L);
    private static final XmlDateTimeRule XML_TIMESTAMP = new XmlDateTimeRule();
    public static final XMLAdapter<XMLGregorianCalendar, PlainDate> XML_DATE = new XmlDateRule();
    public static final XMLAdapter<XMLGregorianCalendar, PlainTime> XML_TIME = new XmlTimeRule();
    public static final XMLAdapter<XMLGregorianCalendar, PlainTimestamp> XML_DATE_TIME = XML_TIMESTAMP;
    public static final XMLAdapter<XMLGregorianCalendar, ZonalDateTime> XML_DATE_TIME_OFFSET = new XmlDateTimeOffsetRule();
    public static final XMLAdapter<javax.xml.datatype.Duration, Duration<IsoUnit>> XML_DURATION = new XmlDurationRule();

    private XMLAdapter() {
    }

    private static DatatypeFactory getXMLFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new ChronoException("XML-conversion not available.", datatypeConfigurationException);
        }
    }

    private static XMLGregorianCalendar toXML(ChronoDisplay chronoDisplay, int n2) {
        PlainDate plainDate = chronoDisplay.get(PlainDate.COMPONENT);
        int n3 = plainDate.getYear();
        int n4 = plainDate.getMonth();
        int n5 = plainDate.getDayOfMonth();
        PlainTime plainTime = chronoDisplay.get(PlainTime.COMPONENT);
        int n6 = plainTime.getHour();
        int n7 = plainTime.getMinute();
        int n8 = (Integer)chronoDisplay.get(PlainTime.SECOND_OF_MINUTE);
        int n9 = plainTime.getNanosecond();
        DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
        if (n9 % 1000000 == 0) {
            int n10 = n9 / 1000000;
            return datatypeFactory.newXMLGregorianCalendar(n3, n4, n5, n6, n7, n8, n10, n2);
        }
        BigInteger bigInteger = BigInteger.valueOf(n3);
        BigDecimal bigDecimal = BigDecimal.valueOf(n9).setScale(9, RoundingMode.UNNECESSARY).divide(MRD_D, RoundingMode.UNNECESSARY);
        return datatypeFactory.newXMLGregorianCalendar(bigInteger, n4, n5, n6, n7, n8, bigDecimal, n2);
    }

    private static class XmlDateTimeRule
    extends XMLAdapter<XMLGregorianCalendar, PlainTimestamp> {
        private XmlDateTimeRule() {
        }

        @Override
        public PlainTimestamp translate(XMLGregorianCalendar xMLGregorianCalendar) {
            return this.translate(xMLGregorianCalendar, false);
        }

        PlainTimestamp translate(XMLGregorianCalendar xMLGregorianCalendar, boolean bl2) {
            int n2;
            BigInteger bigInteger;
            BigInteger bigInteger2 = xMLGregorianCalendar.getEon();
            if (bigInteger2 != null && (bigInteger = bigInteger2.abs()).compareTo(MRD_I) >= 0) {
                throw new ArithmeticException("Year out of supported range: " + xMLGregorianCalendar);
            }
            int n3 = xMLGregorianCalendar.getYear();
            int n4 = xMLGregorianCalendar.getMonth();
            int n5 = xMLGregorianCalendar.getDay();
            if (n3 == Integer.MIN_VALUE || n4 == Integer.MIN_VALUE || n5 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing date component: " + xMLGregorianCalendar);
            }
            int n6 = xMLGregorianCalendar.getHour();
            if (n6 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing hour component: " + xMLGregorianCalendar);
            }
            int n7 = xMLGregorianCalendar.getMinute();
            if (n7 == Integer.MIN_VALUE) {
                n7 = 0;
            }
            if ((n2 = xMLGregorianCalendar.getSecond()) == Integer.MIN_VALUE) {
                n2 = 0;
            } else if (bl2 && n2 == 60) {
                n2 = 59;
            }
            int n8 = 0;
            BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
            if (bigDecimal != null) {
                n8 = bigDecimal.movePointRight(9).intValue();
            }
            PlainTimestamp plainTimestamp = PlainTimestamp.of(n3, n4, n5, n6, n7, n2);
            if (n8 != 0) {
                plainTimestamp = (PlainTimestamp)plainTimestamp.with((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, n8);
            }
            return plainTimestamp;
        }

        @Override
        public XMLGregorianCalendar from(PlainTimestamp plainTimestamp) {
            return XMLAdapter.toXML(plainTimestamp, Integer.MIN_VALUE);
        }

        @Override
        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlDateRule
    extends XMLAdapter<XMLGregorianCalendar, PlainDate> {
        private XmlDateRule() {
        }

        @Override
        public PlainDate translate(XMLGregorianCalendar xMLGregorianCalendar) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = xMLGregorianCalendar.getEon();
            if (bigInteger2 != null && (bigInteger = bigInteger2.abs()).compareTo(MRD_I) >= 0) {
                throw new ArithmeticException("Year out of supported range: " + xMLGregorianCalendar);
            }
            int n2 = xMLGregorianCalendar.getYear();
            int n3 = xMLGregorianCalendar.getMonth();
            int n4 = xMLGregorianCalendar.getDay();
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE || n4 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing date component: " + xMLGregorianCalendar);
            }
            return PlainDate.of(n2, n3, n4);
        }

        @Override
        public XMLGregorianCalendar from(PlainDate plainDate) {
            int n2 = plainDate.getYear();
            int n3 = plainDate.getMonth();
            int n4 = plainDate.getDayOfMonth();
            DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
            return datatypeFactory.newXMLGregorianCalendarDate(n2, n3, n4, Integer.MIN_VALUE);
        }

        @Override
        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlTimeRule
    extends XMLAdapter<XMLGregorianCalendar, PlainTime> {
        private XmlTimeRule() {
        }

        @Override
        public PlainTime translate(XMLGregorianCalendar xMLGregorianCalendar) {
            int n2;
            int n3 = xMLGregorianCalendar.getHour();
            if (n3 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing hour component: " + xMLGregorianCalendar);
            }
            int n4 = xMLGregorianCalendar.getMinute();
            if (n4 == Integer.MIN_VALUE) {
                n4 = 0;
            }
            if ((n2 = xMLGregorianCalendar.getSecond()) == Integer.MIN_VALUE) {
                n2 = 0;
            }
            int n5 = 0;
            BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
            if (bigDecimal != null) {
                n5 = bigDecimal.movePointRight(9).intValue();
            }
            return PlainTime.of(n3, n4, n2, n5);
        }

        @Override
        public XMLGregorianCalendar from(PlainTime plainTime) {
            int n2 = plainTime.getHour();
            int n3 = plainTime.getMinute();
            int n4 = plainTime.getSecond();
            int n5 = plainTime.getNanosecond();
            DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
            int n6 = Integer.MIN_VALUE;
            if (n5 % 1000000 == 0) {
                int n7 = n5 / 1000000;
                return datatypeFactory.newXMLGregorianCalendarTime(n2, n3, n4, n7, n6);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(n5).setScale(9, RoundingMode.UNNECESSARY).divide(MRD_D, RoundingMode.UNNECESSARY);
            return datatypeFactory.newXMLGregorianCalendarTime(n2, n3, n4, bigDecimal, n6);
        }

        @Override
        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlDateTimeOffsetRule
    extends XMLAdapter<XMLGregorianCalendar, ZonalDateTime> {
        private XmlDateTimeOffsetRule() {
        }

        @Override
        public ZonalDateTime translate(XMLGregorianCalendar xMLGregorianCalendar) {
            PlainTimestamp plainTimestamp = XML_TIMESTAMP.translate(xMLGregorianCalendar, true);
            int n2 = xMLGregorianCalendar.getTimezone();
            if (n2 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing timezone offset: " + xMLGregorianCalendar);
            }
            ZonalOffset zonalOffset = ZonalOffset.ofTotalSeconds(n2 * 60);
            Moment moment = plainTimestamp.at(zonalOffset);
            if (xMLGregorianCalendar.getSecond() == 60 && LeapSeconds.getInstance().isEnabled()) {
                Moment moment2 = moment.plus(1L, SI.SECONDS);
                if (moment2.isLeapSecond()) {
                    return moment2.inZonalView(zonalOffset);
                }
                throw new ChronoException("Leap second not registered: " + xMLGregorianCalendar);
            }
            return moment.inZonalView(zonalOffset);
        }

        @Override
        public XMLGregorianCalendar from(ZonalDateTime zonalDateTime) {
            ZonalOffset zonalOffset = zonalDateTime.getOffset();
            int n2 = zonalOffset.getIntegralAmount() / 60;
            try {
                return XMLAdapter.toXML(zonalDateTime, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (zonalDateTime.isLeapSecond()) {
                    ZonalDateTime zonalDateTime2 = zonalDateTime.toMoment().minus(1L, SI.SECONDS).inZonalView(zonalOffset);
                    return XMLAdapter.toXML(zonalDateTime2, n2);
                }
                throw illegalArgumentException;
            }
        }

        @Override
        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlDurationRule
    extends XMLAdapter<javax.xml.datatype.Duration, Duration<IsoUnit>> {
        private XmlDurationRule() {
        }

        @Override
        public Duration<IsoUnit> translate(javax.xml.datatype.Duration duration) {
            if (duration.getSign() == 0) {
                return Duration.ofZero();
            }
            try {
                return Duration.parsePeriod(duration.toString());
            }
            catch (ParseException parseException) {
                if (parseException.getCause() instanceof NumberFormatException) {
                    ArithmeticException arithmeticException = new ArithmeticException();
                    arithmeticException.initCause(parseException);
                    throw arithmeticException;
                }
                throw new ChronoException("Cannot translate: " + duration, parseException);
            }
        }

        @Override
        public javax.xml.datatype.Duration from(Duration<IsoUnit> duration) {
            DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
            return datatypeFactory.newDuration(duration.toStringXML());
        }

        @Override
        public Class<javax.xml.datatype.Duration> getSourceType() {
            return javax.xml.datatype.Duration.class;
        }
    }
}

