/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.threeten;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import net.time4j.CalendarUnit;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.GregorianMath;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.threeten.SPX;

final class NegativeDayOfMonthPattern
extends GregorianTimezoneRule {
    private static final long serialVersionUID = 8126036678681103120L;
    private final transient int domIndicator;
    private final transient byte dayOfWeek;

    NegativeDayOfMonthPattern(Month month, int n2, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n3) {
        super(month, plainTime.getInt(PlainTime.SECOND_OF_DAY), offsetIndicator, n3);
        if (n2 < -28 || n2 > -2) {
            throw new IllegalArgumentException("Day-of-month-indicator out of range: " + n2);
        }
        this.domIndicator = n2;
        this.dayOfWeek = (byte)weekday.getValue();
    }

    @Override
    protected PlainDate getDate0(int n2) {
        int n3 = this.getMonth().getValue();
        int n4 = GregorianMath.getLengthOfMonth(n2, n3) + 1 + this.domIndicator;
        int n5 = GregorianMath.getDayOfWeek(n2, n3, n4);
        PlainDate plainDate = PlainDate.of(n2, n3, n4);
        if (n5 == this.dayOfWeek) {
            return plainDate;
        }
        int n6 = this.dayOfWeek - n5;
        if (n6 > 0) {
            n6 -= 7;
        }
        return plainDate.plus((long)n6, CalendarUnit.DAYS);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NegativeDayOfMonthPattern) {
            NegativeDayOfMonthPattern negativeDayOfMonthPattern = (NegativeDayOfMonthPattern)object;
            return this.domIndicator == negativeDayOfMonthPattern.domIndicator && this.dayOfWeek == negativeDayOfMonthPattern.dayOfWeek && super.isEqual(negativeDayOfMonthPattern);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.domIndicator;
        return n2 += 17 * (this.dayOfWeek + 37 * this.getMonth().getValue());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("NegativeDayOfMonthPattern:[month=");
        stringBuilder.append(this.getMonth());
        stringBuilder.append(",dom-indicator=");
        stringBuilder.append(this.domIndicator);
        stringBuilder.append(",dayOfWeek=");
        stringBuilder.append(Weekday.valueOf(this.dayOfWeek));
        stringBuilder.append(",time-of-day=");
        stringBuilder.append(this.getTimeOfDay());
        stringBuilder.append(",offset-indicator=");
        stringBuilder.append((Object)this.getIndicator());
        stringBuilder.append(",dst-offset=");
        stringBuilder.append(this.getSavings());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    byte getDayOfWeek() {
        return this.dayOfWeek;
    }

    int getDomIndicator() {
        return this.domIndicator;
    }

    private Object writeReplace() {
        return new SPX(this, 123);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

