/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.Month;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.ArrayTransitionModel;
import net.time4j.tz.model.CompositeTransitionModel;
import net.time4j.tz.model.DayOfWeekInMonthPattern;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.FixedDayPattern;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.LastWeekdayPattern;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.RuleComparator;
import net.time4j.tz.model.TransitionModel;

final class SPX
implements Externalizable {
    static final int FIXED_DAY_PATTERN_TYPE = 120;
    static final int DAY_OF_WEEK_IN_MONTH_PATTERN_TYPE = 121;
    static final int LAST_WEEKDAY_PATTERN_TYPE = 122;
    static final int RULE_BASED_TRANSITION_MODEL_TYPE = 125;
    static final int ARRAY_TRANSITION_MODEL_TYPE = 126;
    static final int COMPOSITE_TRANSITION_MODEL_TYPE = 127;
    private static final long POSIX_TIME_1825 = -4575744000L;
    private static final long DAYS_IN_18_BITS = 22642848000L;
    private static final long QUARTERS_IN_24_BITS = 15040511099L;
    private static final int NO_COMPRESSION = 0;
    private static final long serialVersionUID = 6526945678752534989L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n2) {
        this.obj = object;
        this.type = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 120: {
                SPX.writeFixedDayPattern(this.obj, objectOutput);
                break;
            }
            case 121: {
                SPX.writeDayOfWeekInMonthPattern(this.obj, objectOutput);
                break;
            }
            case 122: {
                SPX.writeLastDayOfWeekPattern(this.obj, objectOutput);
                break;
            }
            case 125: {
                SPX.writeRuleBasedTransitionModel(this.obj, objectOutput);
                break;
            }
            case 126: {
                SPX.writeArrayTransitionModel(this.obj, objectOutput);
                break;
            }
            case 127: {
                SPX.writeCompositeTransitionModel(this.obj, objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by2 = objectInput.readByte();
        switch (by2) {
            case 120: {
                this.obj = SPX.readFixedDayPattern(objectInput);
                break;
            }
            case 121: {
                this.obj = SPX.readDayOfWeekInMonthPattern(objectInput);
                break;
            }
            case 122: {
                this.obj = SPX.readLastDayOfWeekPattern(objectInput);
                break;
            }
            case 125: {
                this.obj = SPX.readRuleBasedTransitionModel(objectInput);
                break;
            }
            case 126: {
                this.obj = SPX.readArrayTransitionModel(objectInput);
                break;
            }
            case 127: {
                this.obj = SPX.readCompositeTransitionModel(objectInput);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    static void writeTransitions(ZonalTransition[] zonalTransitionArray, int n2, DataOutput dataOutput) throws IOException {
        int n3 = Math.min(n2, zonalTransitionArray.length);
        dataOutput.writeInt(n3);
        if (n3 > 0) {
            int n4 = zonalTransitionArray[0].getPreviousOffset();
            SPX.writeOffset(dataOutput, n4);
            for (int i2 = 0; i2 < n3; ++i2) {
                n4 = SPX.writeTransition(zonalTransitionArray[i2], n4, dataOutput);
            }
        }
    }

    private static List<ZonalTransition> readTransitions(ObjectInput objectInput) throws IOException {
        int n2;
        int n3 = objectInput.readInt();
        if (n3 == 0) {
            return Collections.emptyList();
        }
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>(n3);
        int n4 = n2 = SPX.readOffset(objectInput);
        long l2 = Long.MIN_VALUE;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            long l3;
            byte by2 = objectInput.readByte();
            boolean bl2 = by2 < 0;
            int n6 = by2 >>> 5 & 3;
            int n7 = by2 >>> 2 & 7;
            int n8 = SPX.toTimeOfDayT(n7);
            if (n8 == -1) {
                l3 = objectInput.readLong();
            } else {
                n5 = (by2 & 3) << 16;
                n5 |= (objectInput.readByte() & 0xFF) << 8;
                l3 = (long)(n5 |= objectInput.readByte() & 0xFF) * 86400L + -4575744000L + (long)n8 - 7200L;
                l3 -= (long)n4;
            }
            if (l3 <= l2) {
                throw new StreamCorruptedException("Wrong order of transitions.");
            }
            l2 = l3;
            switch (n6) {
                case 1: {
                    n5 = 0;
                    break;
                }
                case 2: {
                    n5 = 3600;
                    break;
                }
                case 3: {
                    n5 = 7200;
                    break;
                }
                default: {
                    n5 = SPX.readOffset(objectInput);
                }
            }
            if (bl2) {
                n4 = SPX.readOffset(objectInput);
            }
            int n9 = n4 + (n5 == Integer.MAX_VALUE ? 0 : n5);
            ZonalTransition zonalTransition = new ZonalTransition(l3, n2, n9, n5);
            n2 = n9;
            arrayList.add(zonalTransition);
        }
        return arrayList;
    }

    private static void writeRules(List<DaylightSavingRule> list, ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(list.size());
        block5: for (DaylightSavingRule daylightSavingRule : list) {
            objectOutput.writeByte(daylightSavingRule.getType());
            switch (daylightSavingRule.getType()) {
                case 120: {
                    SPX.writeFixedDayPattern(daylightSavingRule, objectOutput);
                    continue block5;
                }
                case 121: {
                    SPX.writeDayOfWeekInMonthPattern(daylightSavingRule, objectOutput);
                    continue block5;
                }
                case 122: {
                    SPX.writeLastDayOfWeekPattern(daylightSavingRule, objectOutput);
                    continue block5;
                }
            }
            objectOutput.writeObject(daylightSavingRule);
        }
    }

    private static List<DaylightSavingRule> readRules(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2 = objectInput.readByte();
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<DaylightSavingRule> arrayList = new ArrayList<DaylightSavingRule>(n2);
        DaylightSavingRule daylightSavingRule = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            DaylightSavingRule daylightSavingRule2;
            byte by2 = objectInput.readByte();
            switch (by2) {
                case 120: {
                    daylightSavingRule2 = SPX.readFixedDayPattern(objectInput);
                    break;
                }
                case 121: {
                    daylightSavingRule2 = SPX.readDayOfWeekInMonthPattern(objectInput);
                    break;
                }
                case 122: {
                    daylightSavingRule2 = SPX.readLastDayOfWeekPattern(objectInput);
                    break;
                }
                default: {
                    daylightSavingRule2 = (DaylightSavingRule)objectInput.readObject();
                }
            }
            if (daylightSavingRule != null && RuleComparator.INSTANCE.compare(daylightSavingRule, daylightSavingRule2) >= 0) {
                throw new InvalidObjectException("Order of daylight saving rules is not ascending.");
            }
            daylightSavingRule = daylightSavingRule2;
            arrayList.add(daylightSavingRule2);
        }
        return arrayList;
    }

    private static void writeOffset(DataOutput dataOutput, int n2) throws IOException {
        if (n2 % 900 == 0) {
            dataOutput.writeByte(n2 / 900);
        } else {
            dataOutput.writeByte(127);
            dataOutput.writeInt(n2);
        }
    }

    private static int readOffset(DataInput dataInput) throws IOException {
        byte by2 = dataInput.readByte();
        if (by2 == 127) {
            return dataInput.readInt();
        }
        return by2 * 900;
    }

    private static int readSavings(int n2) {
        switch (n2 / 3) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1800;
            }
            case 2: {
                return 3600;
            }
            case 3: {
                return 7200;
            }
        }
        return -1;
    }

    private static int toTimeOfDay(GregorianTimezoneRule gregorianTimezoneRule) {
        return gregorianTimezoneRule.getTimeOfDay().getInt(PlainTime.SECOND_OF_DAY) + MathUtils.safeCast(gregorianTimezoneRule.getDayOverflow() * 86400L);
    }

    private static void writeFixedDayPattern(Object object, DataOutput dataOutput) throws IOException {
        FixedDayPattern fixedDayPattern = (FixedDayPattern)object;
        boolean bl2 = SPX.writeMonthIndicatorOffset(fixedDayPattern, dataOutput);
        int n2 = fixedDayPattern.getDayOfMonth() << 3;
        int n3 = SPX.toTimeOfDay(fixedDayPattern);
        int n4 = SPX.toTimeIndexR(n3);
        dataOutput.writeByte((n2 |= n4) & 0xFF);
        if (!bl2) {
            SPX.writeOffset(dataOutput, fixedDayPattern.getSavings());
        }
        if (n4 == 0) {
            dataOutput.writeInt(n3);
        }
    }

    private static DaylightSavingRule readFixedDayPattern(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        int n3 = n2 >>> 4;
        int n4 = n2 & 0xF;
        OffsetIndicator offsetIndicator = OffsetIndicator.VALUES[n4 % 3];
        int n5 = SPX.readSavings(n4);
        int n6 = dataInput.readByte() & 0xFF;
        int n7 = n6 >>> 3;
        int n8 = SPX.toTimeOfDayR(n6 & 7);
        if (n5 == -1) {
            n5 = SPX.readOffset(dataInput);
        }
        if (n8 == -1) {
            n8 = dataInput.readInt();
        }
        return new FixedDayPattern(Month.valueOf(n3), n7, n8, offsetIndicator, n5);
    }

    private static void writeDayOfWeekInMonthPattern(Object object, DataOutput dataOutput) throws IOException {
        DayOfWeekInMonthPattern dayOfWeekInMonthPattern = (DayOfWeekInMonthPattern)object;
        boolean bl2 = SPX.writeMonthIndicatorOffset(dayOfWeekInMonthPattern, dataOutput);
        int n2 = dayOfWeekInMonthPattern.getDayOfMonth() << 3;
        dataOutput.writeByte((n2 |= dayOfWeekInMonthPattern.getDayOfWeek()) & 0xFF);
        int n3 = dayOfWeekInMonthPattern.isAfter() ? 128 : 0;
        int n4 = SPX.toTimeOfDay(dayOfWeekInMonthPattern);
        boolean bl3 = false;
        if (n4 % 1800 == 0) {
            n3 |= n4 / 1800;
            bl3 = true;
        } else {
            n3 |= 0x3F;
        }
        dataOutput.writeByte(n3 & 0xFF);
        if (!bl2) {
            SPX.writeOffset(dataOutput, dayOfWeekInMonthPattern.getSavings());
        }
        if (!bl3) {
            dataOutput.writeInt(n4);
        }
    }

    private static DaylightSavingRule readDayOfWeekInMonthPattern(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        Month month = Month.valueOf(n2 >>> 4);
        int n3 = n2 & 0xF;
        OffsetIndicator offsetIndicator = OffsetIndicator.VALUES[n3 % 3];
        int n4 = SPX.readSavings(n3);
        int n5 = dataInput.readByte() & 0xFF;
        int n6 = n5 >>> 3;
        Weekday weekday = Weekday.valueOf(n5 & 7);
        int n7 = dataInput.readByte() & 0xFF;
        boolean bl2 = n7 >>> 7 == 1;
        int n8 = n7 & 0x3F;
        if (n4 == -1) {
            n4 = SPX.readOffset(dataInput);
        }
        n8 = n8 == 63 ? dataInput.readInt() : (n8 *= 1800);
        return new DayOfWeekInMonthPattern(month, n6, weekday, n8, offsetIndicator, n4, bl2);
    }

    private static void writeLastDayOfWeekPattern(Object object, DataOutput dataOutput) throws IOException {
        LastWeekdayPattern lastWeekdayPattern = (LastWeekdayPattern)object;
        boolean bl2 = SPX.writeMonthIndicatorOffset(lastWeekdayPattern, dataOutput);
        int n2 = lastWeekdayPattern.getDayOfWeek() << 5;
        int n3 = SPX.toTimeOfDay(lastWeekdayPattern);
        boolean bl3 = false;
        if (n3 % 3600 == 0) {
            n2 |= n3 / 3600;
            bl3 = true;
        } else {
            n2 |= 0x1F;
        }
        dataOutput.writeByte(n2 & 0xFF);
        if (!bl2) {
            SPX.writeOffset(dataOutput, lastWeekdayPattern.getSavings());
        }
        if (!bl3) {
            dataOutput.writeInt(n3);
        }
    }

    private static DaylightSavingRule readLastDayOfWeekPattern(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        Month month = Month.valueOf(n2 >>> 4);
        int n3 = n2 & 0xF;
        OffsetIndicator offsetIndicator = OffsetIndicator.VALUES[n3 % 3];
        int n4 = SPX.readSavings(n3);
        int n5 = dataInput.readByte() & 0xFF;
        Weekday weekday = Weekday.valueOf(n5 >>> 5);
        int n6 = n5 & 0x1F;
        if (n4 == -1) {
            n4 = SPX.readOffset(dataInput);
        }
        n6 = n6 == 31 ? dataInput.readInt() : (n6 *= 3600);
        return new LastWeekdayPattern(month, weekday, n6, offsetIndicator, n4);
    }

    private static void writeRuleBasedTransitionModel(Object object, ObjectOutput objectOutput) throws IOException {
        int n2;
        RuleBasedTransitionModel ruleBasedTransitionModel = (RuleBasedTransitionModel)object;
        ZonalTransition zonalTransition = ruleBasedTransitionModel.getInitialTransition();
        long l2 = zonalTransition.getPosixTime();
        if (l2 >= -4575744000L && l2 < 10464767099L && l2 % 900L == 0L) {
            n2 = (int)((l2 - -4575744000L) / 900L);
            objectOutput.writeByte(n2 >>> 16 & 0xFF);
            objectOutput.writeByte(n2 >>> 8 & 0xFF);
            objectOutput.writeByte(n2 & 0xFF);
        } else {
            objectOutput.writeByte(255);
            objectOutput.writeLong(zonalTransition.getPosixTime());
        }
        SPX.writeOffset(objectOutput, zonalTransition.getPreviousOffset());
        SPX.writeOffset(objectOutput, zonalTransition.getTotalOffset());
        n2 = zonalTransition.getExtraOffset();
        SPX.writeOffset(objectOutput, n2);
        SPX.writeRules(ruleBasedTransitionModel.getRules(), objectOutput);
    }

    private static Object readRuleBasedTransitionModel(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        int n3;
        long l2;
        int n4 = objectInput.readByte() & 0xFF;
        if (n4 == 255) {
            l2 = objectInput.readLong();
        } else {
            n3 = objectInput.readByte() & 0xFF;
            n2 = objectInput.readByte() & 0xFF;
            l2 = (long)((n4 << 16) + (n3 << 8) + n2) * 900L;
            l2 += -4575744000L;
        }
        n3 = SPX.readOffset(objectInput);
        n2 = SPX.readOffset(objectInput);
        int n5 = SPX.readOffset(objectInput);
        ZonalTransition zonalTransition = new ZonalTransition(l2, n3, n2, n5);
        List<DaylightSavingRule> list = SPX.readRules(objectInput);
        return new RuleBasedTransitionModel(zonalTransition, list, false);
    }

    private static void writeArrayTransitionModel(Object object, ObjectOutput objectOutput) throws IOException {
        ArrayTransitionModel arrayTransitionModel = (ArrayTransitionModel)object;
        arrayTransitionModel.writeTransitions(objectOutput);
    }

    private static Object readArrayTransitionModel(ObjectInput objectInput) throws IOException {
        return new ArrayTransitionModel(SPX.readTransitions(objectInput), false, false);
    }

    private static void writeCompositeTransitionModel(Object object, ObjectOutput objectOutput) throws IOException {
        CompositeTransitionModel compositeTransitionModel = (CompositeTransitionModel)object;
        compositeTransitionModel.writeTransitions(objectOutput);
        SPX.writeRules(compositeTransitionModel.getRules(), objectOutput);
    }

    private static Object readCompositeTransitionModel(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        List<ZonalTransition> list = SPX.readTransitions(objectInput);
        return TransitionModel.of(ZonalOffset.ofTotalSeconds(list.get(0).getPreviousOffset()), list, SPX.readRules(objectInput), false, false);
    }

    private static int writeTransition(ZonalTransition zonalTransition, int n2, DataOutput dataOutput) throws IOException {
        int n3;
        int n4 = zonalTransition.getRawOffset();
        boolean bl2 = n4 != n2;
        int n5 = 0;
        if (bl2) {
            n5 = (byte)(n5 | 0x80);
        }
        int n6 = zonalTransition.getExtraOffset();
        switch (n6) {
            case 0: {
                n3 = 1;
                break;
            }
            case 3600: {
                n3 = 2;
                break;
            }
            case 7200: {
                n3 = 3;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        n5 = (byte)(n5 | n3 << 5);
        long l2 = zonalTransition.getPosixTime() + (long)n2 + 7200L;
        int n7 = 0;
        if (l2 >= -4575744000L && l2 < 18067104000L) {
            n7 = SPX.toTimeIndexT(MathUtils.floorModulo(l2, 86400));
        }
        n5 = (byte)(n5 | n7 << 2);
        if (n7 == 0) {
            dataOutput.writeByte(n5);
            dataOutput.writeLong(zonalTransition.getPosixTime());
        } else {
            int n8 = (int)((l2 - -4575744000L) / 86400L);
            byte by2 = (byte)(n8 >>> 16 & 3);
            n5 = (byte)(n5 | by2);
            dataOutput.writeByte(n5);
            dataOutput.writeByte(n8 >>> 8 & 0xFF);
            dataOutput.writeByte(n8 & 0xFF);
        }
        if (n3 == 0) {
            SPX.writeOffset(dataOutput, n6);
        }
        if (bl2) {
            SPX.writeOffset(dataOutput, n4);
        }
        return n4;
    }

    private static int toTimeIndexT(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 60: {
                return 2;
            }
            case 3600: {
                return 3;
            }
            case 7200: {
                return 4;
            }
            case 10800: {
                return 5;
            }
            case 14400: {
                return 6;
            }
            case 18000: {
                return 7;
            }
        }
        return 0;
    }

    private static int toTimeOfDayT(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 3600;
            }
            case 4: {
                return 7200;
            }
            case 5: {
                return 10800;
            }
            case 6: {
                return 14400;
            }
            case 7: {
                return 18000;
            }
        }
        return -1;
    }

    private static boolean writeMonthIndicatorOffset(GregorianTimezoneRule gregorianTimezoneRule, DataOutput dataOutput) throws IOException {
        int n2 = gregorianTimezoneRule.getMonthValue() << 4;
        int n3 = gregorianTimezoneRule.getIndicator().ordinal();
        int n4 = gregorianTimezoneRule.getSavings();
        boolean bl2 = true;
        switch (n4) {
            case 0: {
                n2 |= n3;
                break;
            }
            case 1800: {
                n2 |= 3 + n3;
                break;
            }
            case 3600: {
                n2 |= 6 + n3;
                break;
            }
            case 7200: {
                n2 |= 9 + n3;
                break;
            }
            default: {
                bl2 = false;
                n2 |= 12 + n3;
            }
        }
        dataOutput.writeByte(n2 & 0xFF);
        return bl2;
    }

    private static int toTimeIndexR(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 3600: {
                return 2;
            }
            case 7200: {
                return 3;
            }
            case 10800: {
                return 4;
            }
            case 79200: {
                return 5;
            }
            case 82800: {
                return 6;
            }
            case 86400: {
                return 7;
            }
        }
        return 0;
    }

    private static int toTimeOfDayR(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 2: {
                return 3600;
            }
            case 3: {
                return 7200;
            }
            case 4: {
                return 10800;
            }
            case 5: {
                return 79200;
            }
            case 6: {
                return 82800;
            }
            case 7: {
                return 86400;
            }
        }
        return -1;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

