/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Weekday;
import net.time4j.base.GregorianMath;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.SPX;

final class LastWeekdayPattern
extends GregorianTimezoneRule {
    private static final long serialVersionUID = -946839310332554772L;
    private final transient byte dayOfWeek;

    LastWeekdayPattern(Month month, Weekday weekday, int n2, OffsetIndicator offsetIndicator, int n3) {
        super(month, n2, offsetIndicator, n3);
        this.dayOfWeek = (byte)weekday.getValue();
    }

    @Override
    protected PlainDate getDate0(int n2) {
        int n3;
        byte by2 = this.getMonthValue();
        int n4 = GregorianMath.getDayOfWeek(n2, by2, n3 = GregorianMath.getLengthOfMonth(n2, by2));
        int n5 = n4 - this.dayOfWeek;
        if (n5 < 0) {
            n5 += 7;
        }
        return PlainDate.of(n2, (int)by2, n3 - n5);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LastWeekdayPattern) {
            LastWeekdayPattern lastWeekdayPattern = (LastWeekdayPattern)object;
            return this.dayOfWeek == lastWeekdayPattern.dayOfWeek && super.isEqual(lastWeekdayPattern);
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.dayOfWeek + 37 * this.getMonthValue();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("LastDayOfWeekPattern:[month=");
        stringBuilder.append(this.getMonthValue());
        stringBuilder.append(",day-of-week=");
        stringBuilder.append(Weekday.valueOf(this.dayOfWeek));
        stringBuilder.append(",day-overflow=");
        stringBuilder.append(this.getDayOverflow());
        stringBuilder.append(",time-of-day=");
        stringBuilder.append(this.getTimeOfDay());
        stringBuilder.append(",offset-indicator=");
        stringBuilder.append((Object)this.getIndicator());
        stringBuilder.append(",dst-offset=");
        stringBuilder.append(this.getSavings());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    byte getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    int getType() {
        return 122;
    }

    private Object writeReplace() {
        return new SPX(this, this.getType());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

