/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.SimpleUT;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;

public interface TransitionHistory {
    public ZonalOffset getInitialOffset();

    public ZonalTransition getStartTransition(UnixTime var1);

    public ZonalTransition getConflictTransition(GregorianDate var1, WallTime var2);

    public List<ZonalOffset> getValidOffsets(GregorianDate var1, WallTime var2);

    public List<ZonalTransition> getStdTransitions();

    public List<ZonalTransition> getTransitions(UnixTime var1, UnixTime var2);

    public boolean isEmpty();

    public void dump(Appendable var1) throws IOException;

    default public Optional<ZonalTransition> findStartTransition(UnixTime unixTime) {
        ZonalTransition zonalTransition = this.getStartTransition(unixTime);
        return zonalTransition == null ? Optional.empty() : Optional.of(zonalTransition);
    }

    default public Optional<ZonalTransition> findConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        ZonalTransition zonalTransition = this.getConflictTransition(gregorianDate, wallTime);
        return zonalTransition == null ? Optional.empty() : Optional.of(zonalTransition);
    }

    public Optional<ZonalTransition> findNextTransition(UnixTime var1);

    default public Optional<ZonalTransition> findPreviousTransition(UnixTime unixTime) {
        return this.findStartTransition(SimpleUT.previousTime(unixTime));
    }
}

