/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.UnixTime;
import net.time4j.scale.DefaultLeapSecondProviderSPI;
import net.time4j.scale.ExtendedLSE;
import net.time4j.scale.LeapSecondEvent;
import net.time4j.scale.LeapSecondProvider;

public final class LeapSeconds
implements Iterable<LeapSecondEvent>,
Comparator<LeapSecondEvent> {
    public static final boolean SUPPRESS_UTC_LEAPSECONDS = Boolean.getBoolean("net.time4j.scale.leapseconds.suppressed");
    public static final boolean FINAL_UTC_LEAPSECONDS = Boolean.getBoolean("net.time4j.scale.leapseconds.final");
    public static final String PATH_TO_LEAPSECONDS = System.getProperty("net.time4j.scale.leapseconds.path", "data/leapseconds.data");
    private static final ExtendedLSE[] EMPTY_ARRAY = new ExtendedLSE[0];
    private static final LeapSeconds INSTANCE = new LeapSeconds();
    private static final long UNIX_OFFSET = 63072000L;
    private static final long MJD_OFFSET = 40587L;
    private final LeapSecondProvider provider;
    private final List<ExtendedLSE> list;
    private final ExtendedLSE[] reverseFinal;
    private volatile ExtendedLSE[] reverseVolatile;
    private final boolean supportsNegativeLS;

    /*
     * WARNING - void declaration
     */
    private LeapSeconds() {
        LeapSecondProvider object = null;
        int n2 = 0;
        if (!SUPPRESS_UTC_LEAPSECONDS) {
            for (LeapSecondProvider object2 : ResourceLoader.getInstance().services(LeapSecondProvider.class)) {
                int bl3 = object2.getLeapSecondTable().size();
                if (bl3 <= n2) continue;
                object = object2;
                n2 = bl3;
            }
            if (object == null) {
                object = new DefaultLeapSecondProviderSPI();
                n2 = object.getLeapSecondTable().size();
            }
        }
        if (object == null || n2 == 0) {
            this.provider = null;
            this.list = Collections.emptyList();
            this.reverseFinal = EMPTY_ARRAY;
            this.reverseVolatile = EMPTY_ARRAY;
            this.supportsNegativeLS = false;
        } else {
            TreeSet<LeapSecondEvent> treeSet = new TreeSet<LeapSecondEvent>(this);
            for (Map.Entry<GregorianDate, Integer> entry : object.getLeapSecondTable().entrySet()) {
                GregorianDate gregorianDate = entry.getKey();
                long l2 = LeapSeconds.toPosix(gregorianDate);
                treeSet.add(new SimpleLeapSecondEvent(gregorianDate, Long.MIN_VALUE, l2 + -62985600L - 1L, entry.getValue()));
            }
            LeapSeconds.extend((SortedSet<ExtendedLSE>)treeSet);
            this.list = FINAL_UTC_LEAPSECONDS ? Collections.unmodifiableList(new ArrayList(treeSet)) : new CopyOnWriteArrayList<ExtendedLSE>(treeSet);
            this.reverseFinal = this.initReverse();
            this.reverseVolatile = this.reverseFinal;
            this.provider = object;
            if (FINAL_UTC_LEAPSECONDS) {
                void var4_7;
                boolean bl2 = object.supportsNegativeLS();
                if (bl2) {
                    boolean bl3;
                    boolean bl4 = false;
                    for (ExtendedLSE extendedLSE : this.list) {
                        if (extendedLSE.getShift() >= 0) continue;
                        bl3 = true;
                        break;
                    }
                    var4_7 = bl3;
                }
                this.supportsNegativeLS = var4_7;
            } else {
                this.supportsNegativeLS = true;
            }
        }
    }

    public static LeapSeconds getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return !this.list.isEmpty();
    }

    public boolean isExtensible() {
        return !FINAL_UTC_LEAPSECONDS && this.isEnabled();
    }

    public int getCount() {
        return this.getEventsInDescendingOrder().length;
    }

    public int getCount(UnixTime unixTime) {
        long l2 = unixTime.getPosixTime();
        return MathUtils.safeCast(this.enhance(l2) + 63072000L - l2);
    }

    public void registerPositiveLS(int n2, int n3, int n4) {
        this.register(n2, n3, n4, false);
    }

    public void registerNegativeLS(int n2, int n3, int n4) {
        this.register(n2, n3, n4, true);
    }

    public boolean supportsNegativeLS() {
        return this.supportsNegativeLS;
    }

    @Override
    public Iterator<LeapSecondEvent> iterator() {
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        return Collections.unmodifiableList(Arrays.asList(extendedLSEArray)).iterator();
    }

    public Stream<LeapSecondEvent> stream() {
        return Arrays.stream(this.getEventsInDescendingOrder());
    }

    public int getShift(GregorianDate gregorianDate) {
        int n2 = gregorianDate.getYear();
        if (n2 >= 1972) {
            ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
            for (int i2 = 0; i2 < extendedLSEArray.length; ++i2) {
                ExtendedLSE extendedLSE = extendedLSEArray[i2];
                GregorianDate gregorianDate2 = extendedLSE.getDate();
                if (n2 != gregorianDate2.getYear() || gregorianDate.getMonth() != gregorianDate2.getMonth() || gregorianDate.getDayOfMonth() != gregorianDate2.getDayOfMonth()) continue;
                return extendedLSE.getShift();
            }
        }
        return 0;
    }

    public int getShift(long l2) {
        if (l2 <= 0L) {
            return 0;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i2 = 0; i2 < extendedLSEArray.length; ++i2) {
            ExtendedLSE extendedLSE = extendedLSEArray[i2];
            if (l2 > extendedLSE.utc()) {
                return 0;
            }
            long l3 = extendedLSE.utc() - (long)extendedLSE.getShift();
            if (l2 <= l3) continue;
            return (int)(l2 - l3);
        }
        return 0;
    }

    public LeapSecondEvent getNextEvent(long l2) {
        ExtendedLSE extendedLSE;
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        ExtendedLSE extendedLSE2 = null;
        for (int i2 = 0; i2 < extendedLSEArray.length && l2 < (extendedLSE = extendedLSEArray[i2]).utc(); ++i2) {
            extendedLSE2 = extendedLSE;
        }
        return extendedLSE2;
    }

    public long enhance(long l2) {
        long l3 = l2 - 63072000L;
        if (l3 < 0L) {
            return l3;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i2 = 0; i2 < extendedLSEArray.length; ++i2) {
            ExtendedLSE extendedLSE = extendedLSEArray[i2];
            if (extendedLSE.raw() >= l3) continue;
            return Math.addExact(l3, extendedLSE.utc() - extendedLSE.raw());
        }
        return l3;
    }

    public long strip(long l2) {
        if (l2 <= 0L) {
            return l2 + 63072000L;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        boolean bl2 = this.supportsNegativeLS;
        for (int i2 = 0; i2 < extendedLSEArray.length; ++i2) {
            ExtendedLSE extendedLSE = extendedLSEArray[i2];
            if (extendedLSE.utc() - (long)extendedLSE.getShift() >= l2 && (!bl2 || extendedLSE.getShift() >= 0 || extendedLSE.utc() >= l2)) continue;
            l2 = Math.addExact(l2, extendedLSE.raw() - extendedLSE.utc());
            break;
        }
        return l2 + 63072000L;
    }

    public boolean isPositiveLS(long l2) {
        if (l2 <= 0L) {
            return false;
        }
        ExtendedLSE[] extendedLSEArray = this.getEventsInDescendingOrder();
        for (int i2 = 0; i2 < extendedLSEArray.length; ++i2) {
            long l3 = extendedLSEArray[i2].utc();
            if (l3 == l2) {
                return extendedLSEArray[i2].getShift() == 1;
            }
            if (l3 < l2) break;
        }
        return false;
    }

    public GregorianDate getDateOfExpiration() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Leap seconds not activated.");
        }
        return this.provider.getDateOfExpiration();
    }

    @Override
    public int compare(LeapSecondEvent leapSecondEvent, LeapSecondEvent leapSecondEvent2) {
        int n2;
        int n3;
        int n4;
        GregorianDate gregorianDate = leapSecondEvent.getDate();
        GregorianDate gregorianDate2 = leapSecondEvent2.getDate();
        int n5 = gregorianDate.getYear();
        if (n5 < (n4 = gregorianDate2.getYear())) {
            return -1;
        }
        if (n5 > n4) {
            return 1;
        }
        int n6 = gregorianDate.getMonth();
        if (n6 < (n3 = gregorianDate2.getMonth())) {
            return -1;
        }
        if (n6 > n3) {
            return 1;
        }
        int n7 = gregorianDate.getDayOfMonth();
        return n7 < (n2 = gregorianDate2.getDayOfMonth()) ? -1 : (n7 == n2 ? 0 : 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("[PROVIDER=");
        stringBuilder.append(this.provider);
        if (this.provider != null) {
            stringBuilder.append(",EXPIRES=");
            stringBuilder.append(LeapSeconds.format(this.getDateOfExpiration()));
        }
        stringBuilder.append(",EVENTS=[");
        if (this.isEnabled()) {
            boolean bl2 = true;
            for (ExtendedLSE extendedLSE : this.list) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(extendedLSE);
            }
        } else {
            stringBuilder.append("NOT SUPPORTED");
        }
        return stringBuilder.append("]]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(int n2, int n3, int n4, boolean bl2) {
        if (FINAL_UTC_LEAPSECONDS) {
            throw new IllegalStateException("Leap seconds are final, change requires edit of system property \"time4j.utc.leapseconds.final\" and reboot of JVM.");
        }
        if (SUPPRESS_UTC_LEAPSECONDS) {
            throw new IllegalStateException("Leap seconds are not supported, change requires edit of system property \"time4j.utc.leapseconds.suppressed\" and reboot of JVM.");
        }
        LeapSeconds leapSeconds = this;
        synchronized (leapSeconds) {
            GregorianMath.checkDate(n2, n3, n4);
            if (!this.isEnabled()) {
                throw new IllegalStateException("Leap seconds not activated.");
            }
            ExtendedLSE extendedLSE = this.reverseVolatile[0];
            GregorianDate gregorianDate = extendedLSE.getDate();
            boolean bl3 = false;
            if (n2 > gregorianDate.getYear()) {
                bl3 = true;
            } else if (n2 == gregorianDate.getYear()) {
                if (n3 > gregorianDate.getMonth()) {
                    bl3 = true;
                } else if (n3 == gregorianDate.getMonth() && n4 > gregorianDate.getDayOfMonth()) {
                    bl3 = true;
                }
            }
            if (!bl3) {
                throw new IllegalArgumentException("New leap second must be after last leap second.");
            }
            int n5 = bl2 ? -1 : 1;
            GregorianDate gregorianDate2 = this.provider.getDateOfEvent(n2, n3, n4);
            this.list.add(LeapSeconds.createLSE(gregorianDate2, n5, extendedLSE));
            this.reverseVolatile = this.initReverse();
        }
    }

    private ExtendedLSE[] getEventsInDescendingOrder() {
        if (SUPPRESS_UTC_LEAPSECONDS || FINAL_UTC_LEAPSECONDS) {
            return this.reverseFinal;
        }
        return this.reverseVolatile;
    }

    private static void extend(SortedSet<ExtendedLSE> sortedSet) {
        ArrayList<ExtendedLSE> arrayList = new ArrayList<ExtendedLSE>(sortedSet.size());
        int n2 = 0;
        for (ExtendedLSE extendedLSE : sortedSet) {
            if (extendedLSE.utc() == Long.MIN_VALUE) {
                arrayList.add(new SimpleLeapSecondEvent(extendedLSE, n2 += extendedLSE.getShift()));
                continue;
            }
            arrayList.add(extendedLSE);
        }
        sortedSet.clear();
        sortedSet.addAll(arrayList);
    }

    private static ExtendedLSE createLSE(GregorianDate gregorianDate, int n2, ExtendedLSE extendedLSE) {
        long l2 = LeapSeconds.toPosix(gregorianDate) + -62985600L - 1L;
        int n3 = (int)(extendedLSE.utc() - extendedLSE.raw() + (long)n2);
        return new SimpleLeapSecondEvent(gregorianDate, l2 + (long)n3, l2, n2);
    }

    private static long toPosix(GregorianDate gregorianDate) {
        return Math.multiplyExact(Math.subtractExact(GregorianMath.toMJD(gregorianDate), 40587L), 86400L);
    }

    private ExtendedLSE[] initReverse() {
        ArrayList<ExtendedLSE> arrayList = new ArrayList<ExtendedLSE>(this.list.size());
        arrayList.addAll(this.list);
        Collections.reverse(arrayList);
        return arrayList.toArray(new ExtendedLSE[arrayList.size()]);
    }

    private static String format(GregorianDate gregorianDate) {
        return String.format("%1$04d-%2$02d-%3$02d", gregorianDate.getYear(), gregorianDate.getMonth(), gregorianDate.getDayOfMonth());
    }

    private static class SimpleLeapSecondEvent
    implements ExtendedLSE,
    Serializable {
        private static final long serialVersionUID = 5986185471610524587L;
        private final GregorianDate date;
        private final int shift;
        private final long _utc;
        private final long _raw;

        SimpleLeapSecondEvent(GregorianDate gregorianDate, long l2, long l3, int n2) {
            this.date = gregorianDate;
            this.shift = n2;
            this._utc = l2;
            this._raw = l3;
        }

        SimpleLeapSecondEvent(ExtendedLSE extendedLSE, int n2) {
            this.date = extendedLSE.getDate();
            this.shift = extendedLSE.getShift();
            this._utc = extendedLSE.raw() + (long)n2;
            this._raw = extendedLSE.raw();
        }

        @Override
        public GregorianDate getDate() {
            return this.date;
        }

        @Override
        public int getShift() {
            return this.shift;
        }

        @Override
        public long utc() {
            return this._utc;
        }

        @Override
        public long raw() {
            return this._raw;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(LeapSecondEvent.class.getName());
            stringBuilder.append('[');
            stringBuilder.append(LeapSeconds.format(this.date));
            stringBuilder.append(": utc=");
            stringBuilder.append(this._utc);
            stringBuilder.append(", raw=");
            stringBuilder.append(this._raw);
            stringBuilder.append(" (shift=");
            stringBuilder.append(this.shift);
            stringBuilder.append(")]");
            return stringBuilder.toString();
        }
    }
}

