/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.Weekcycle;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.CalendarWeek;
import net.time4j.range.CalendarYear;
import net.time4j.range.SingleUnitTimeSpan;

public final class Years<U extends IsoDateUnit>
extends SingleUnitTimeSpan<U, Years<U>> {
    public static final Years<CalendarUnit> ZERO = new Years<CalendarUnit>(0, CalendarUnit.YEARS);
    public static final Years<CalendarUnit> ONE = new Years<CalendarUnit>(1, CalendarUnit.YEARS);
    private static final long serialVersionUID = 6288717039772347252L;

    private Years(int n2, U u2) {
        super(n2, u2);
    }

    public static Years<CalendarUnit> ofGregorian(int n2) {
        return n2 == 0 ? ZERO : (n2 == 1 ? ONE : new Years<CalendarUnit>(n2, CalendarUnit.YEARS));
    }

    public static Years<Weekcycle> ofWeekBased(int n2) {
        return new Years<Weekcycle>(n2, Weekcycle.YEARS);
    }

    public static <T extends TimePoint<? super CalendarUnit, T>> Years<CalendarUnit> between(T t2, T t3) {
        long l2 = CalendarUnit.YEARS.between(t2, t3);
        return Years.ofGregorian(MathUtils.safeCast(l2));
    }

    public static Years<CalendarUnit> between(CalendarYear calendarYear, CalendarYear calendarYear2) {
        return Years.ofGregorian(calendarYear2.getValue() - calendarYear.getValue());
    }

    public static Years<CalendarUnit> between(CalendarQuarter calendarQuarter, CalendarQuarter calendarQuarter2) {
        int n2 = calendarQuarter2.getYear() - calendarQuarter.getYear();
        if (n2 > 0) {
            if (calendarQuarter2.getQuarter().compareTo(calendarQuarter.getQuarter()) < 0) {
                --n2;
            }
        } else if (n2 < 0 && calendarQuarter2.getQuarter().compareTo(calendarQuarter.getQuarter()) > 0) {
            ++n2;
        }
        return Years.ofGregorian(n2);
    }

    public static Years<CalendarUnit> between(CalendarMonth calendarMonth, CalendarMonth calendarMonth2) {
        int n2 = calendarMonth.getYear() - calendarMonth2.getYear();
        if (n2 > 0) {
            if (calendarMonth2.getMonth().compareTo(calendarMonth.getMonth()) < 0) {
                --n2;
            }
        } else if (n2 < 0 && calendarMonth2.getMonth().compareTo(calendarMonth.getMonth()) > 0) {
            ++n2;
        }
        return Years.ofGregorian(n2);
    }

    public static Years<Weekcycle> between(CalendarWeek calendarWeek, CalendarWeek calendarWeek2) {
        int n2 = calendarWeek2.getYear() - calendarWeek.getYear();
        if (n2 > 0) {
            if (calendarWeek2.getWeek() < calendarWeek.getWeek()) {
                --n2;
            }
        } else if (n2 < 0 && calendarWeek2.getWeek() > calendarWeek.getWeek()) {
            ++n2;
        }
        return Years.ofWeekBased(n2);
    }

    public static Years<CalendarUnit> parseGregorian(String string) throws ParseException {
        int n2 = SingleUnitTimeSpan.parsePeriod(string, 'Y');
        return Years.ofGregorian(n2);
    }

    public static Years<Weekcycle> parseWeekBased(String string) throws ParseException {
        int n2 = SingleUnitTimeSpan.parsePeriod(string, 'Y');
        return Years.ofWeekBased(n2);
    }

    @Override
    Years<U> with(int n2) {
        return new Years(n2, this.getUnit());
    }

    @Override
    Years<U> self() {
        return this;
    }

    @Override
    void checkConsistency(U u2) {
        if (!u2.equals(CalendarUnit.YEARS) && !u2.equals(Weekcycle.YEARS)) {
            throw new IllegalArgumentException("Invalid year unit: " + u2);
        }
    }
}

