/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;

enum FixedNumParser implements ChronoParser<Integer>
{
    BASIC_WEEK_OF_YEAR,
    EXTENDED_WEEK_OF_YEAR,
    CALENDAR_MONTH;


    @Override
    public Integer parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        char c2;
        char c3;
        int n2;
        int n3 = charSequence.length();
        int n4 = n2 = parseLog.getPosition();
        int n5 = attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n5 > 0) {
            n3 -= n5;
        }
        if (n4 >= n3) {
            parseLog.setError(n4, "Missing component: " + this.name());
            parseLog.setWarning();
            return null;
        }
        if (this == BASIC_WEEK_OF_YEAR || this == EXTENDED_WEEK_OF_YEAR) {
            if (charSequence.charAt(n4) == 'W') {
                ++n2;
                if (++n4 >= n3) {
                    parseLog.setError(n4, "Missing digits for: " + this.name());
                    return null;
                }
            } else {
                parseLog.setError(n4, "Literal 'W' expected.");
                return null;
            }
        }
        if ((c3 = charSequence.charAt(n4)) == '-' || c3 == '+') {
            parseLog.setError(n4, "Sign not allowed due to sign policy.");
            return null;
        }
        int n6 = n4 + 2;
        int n7 = Math.min(n3, n4 + 2);
        int n8 = 0;
        boolean bl2 = true;
        while (n4 < n7) {
            c2 = charSequence.charAt(n4) - 48;
            if (c2 >= '\u0000' && c2 <= '\t') {
                n8 = n8 * 10 + c2;
                ++n4;
                bl2 = false;
                continue;
            }
            if (!bl2) break;
            parseLog.setError(n2, "Digit expected.");
            return null;
        }
        if (n4 < n6) {
            parseLog.setError(n2, "Not enough digits found for: " + this.name());
            return null;
        }
        if (this != BASIC_WEEK_OF_YEAR) {
            if (n4 >= n3) {
                parseLog.setError(n4, "Missing literal '-' after: " + this.name());
                return null;
            }
            c2 = charSequence.charAt(n4);
            if (c2 != '-') {
                parseLog.setError(n4, "Found " + c2 + ", but expected literal '-' after: " + this.name());
                return null;
            }
            ++n4;
        }
        parseLog.setPosition(n4);
        return n8;
    }
}

