/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.time.Year;
import java.time.format.FormatStyle;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Quarter;
import net.time4j.SystemClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.TimeLine;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.range.Boundary;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.FixedCalendarTimeLine;
import net.time4j.range.SPX;
import net.time4j.range.Years;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class CalendarYear
extends FixedCalendarInterval<CalendarYear>
implements ThreetenAdapter,
LocalizedPatternSupport {
    @FormattableElement(format="u")
    public static final ChronoElement<Integer> YEAR = PlainDate.YEAR;
    private static final Chronology<CalendarYear> ENGINE = Chronology.Builder.setUp(CalendarYear.class, new Merger()).appendElement(YEAR, new YearRule()).build();
    private static final Chronology<Year> THREETEN;
    private static final long serialVersionUID = 2151327270599436439L;
    private final transient int year;
    private final transient Boundary<PlainDate> start;
    private final transient Boundary<PlainDate> end;

    private CalendarYear(int n2) {
        if (n2 < -999999999 || n2 > 999999999) {
            throw new IllegalArgumentException("Year out of bounds: " + n2);
        }
        this.year = n2;
        this.start = Boundary.ofClosed(PlainDate.of(this.year, 1, 1));
        this.end = Boundary.ofClosed(PlainDate.of(this.year, 12, 31));
    }

    public static CalendarYear of(int n2) {
        return new CalendarYear(n2);
    }

    public static CalendarYear nowInSystemTime() {
        return SystemClock.inLocalView().now(CalendarYear.chronology());
    }

    public CalendarQuarter at(Quarter quarter) {
        return CalendarQuarter.of(this.year, quarter);
    }

    public CalendarMonth at(Month month) {
        return CalendarMonth.of(this.year, month);
    }

    public CalendarMonth atMonth(int n2) {
        return CalendarMonth.of(this.year, n2);
    }

    public PlainDate atDayOfYear(int n2) {
        return n2 == 1 ? this.start.getTemporal() : PlainDate.of(this.year, n2);
    }

    public int getValue() {
        return this.year;
    }

    @Override
    public Boundary<PlainDate> getStart() {
        return this.start;
    }

    @Override
    public Boundary<PlainDate> getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(PlainDate plainDate) {
        return plainDate.getYear() == this.year;
    }

    @Override
    public boolean isAfter(PlainDate plainDate) {
        return plainDate.getYear() < this.year;
    }

    @Override
    public boolean isBefore(PlainDate plainDate) {
        return plainDate.getYear() > this.year;
    }

    public boolean isLeap() {
        return GregorianMath.isLeapYear(this.year);
    }

    public int length() {
        return this.isLeap() ? 366 : 365;
    }

    public static CalendarYear from(GregorianDate gregorianDate) {
        PlainDate plainDate = PlainDate.from(gregorianDate);
        return CalendarYear.of(plainDate.getYear());
    }

    public static CalendarYear from(Year year) {
        return CalendarYear.of(year.getValue());
    }

    public CalendarYear plus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarYear.of(MathUtils.safeAdd(this.year, years.getAmount()));
    }

    public CalendarYear minus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarYear.of(MathUtils.safeSubtract(this.year, years.getAmount()));
    }

    @Override
    public int compareTo(CalendarYear calendarYear) {
        return this.year - calendarYear.year;
    }

    @Override
    public Iterator<PlainDate> iterator() {
        return new Iter();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarYear) {
            CalendarYear calendarYear = (CalendarYear)object;
            return this.year == calendarYear.year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarYear.formatYear(stringBuilder, this.year);
        return stringBuilder.toString();
    }

    @Override
    public Year toTemporalAccessor() {
        return Year.of(this.year);
    }

    public static Chronology<CalendarYear> chronology() {
        return ENGINE;
    }

    public static Chronology<Year> threeten() {
        return THREETEN;
    }

    public static TimeLine<CalendarYear> timeline() {
        return FixedCalendarTimeLine.forYears();
    }

    @Override
    protected Chronology<CalendarYear> getChronology() {
        return ENGINE;
    }

    @Override
    protected CalendarYear getContext() {
        return this;
    }

    @Override
    long toProlepticNumber() {
        return this.year;
    }

    static CalendarYear from(long l2) {
        int n2 = MathUtils.safeCast(l2);
        return CalendarYear.of(n2);
    }

    private Object writeReplace() {
        return new SPX(this, 36);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Converter<Year, CalendarYear> converter = new Converter<Year, CalendarYear>(){

            @Override
            public CalendarYear translate(Year year) {
                return CalendarYear.of(year.getValue());
            }

            @Override
            public Year from(CalendarYear calendarYear) {
                return Year.of(calendarYear.year);
            }

            @Override
            public Class<Year> getSourceType() {
                return Year.class;
            }
        };
        THREETEN = new BridgeChronology<Year, CalendarYear>(converter, ENGINE);
    }

    private class Iter
    implements Iterator<PlainDate> {
        private PlainDate current;

        private Iter() {
            this.current = (PlainDate)CalendarYear.this.start.getTemporal();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public PlainDate next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            PlainDate plainDate = this.current;
            PlainDate plainDate2 = plainDate.plus(1L, CalendarUnit.DAYS);
            this.current = plainDate2.getYear() == CalendarYear.this.year ? plainDate2 : null;
            return plainDate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Merger
    implements ChronoMerger<CalendarYear> {
        private Merger() {
        }

        @Override
        public CalendarYear createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            int n2 = Moment.from(timeSource.currentTime()).toZonalTimestamp(timezone.getID()).getYear();
            return CalendarYear.of(n2);
        }

        @Override
        public CalendarYear createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            int n2 = chronoEntity.getInt(YEAR);
            if (n2 >= -999999999 && n2 <= 999999999) {
                return CalendarYear.of(n2);
            }
            if (n2 > Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Year out of bounds: " + n2);
            }
            return null;
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            Map<String, String> map = CalendarText.getIsoInstance(locale).getTextForms();
            String string = "F_y";
            return map.getOrDefault(string, "uuuu");
        }
    }

    private static class YearRule
    implements IntElementRule<CalendarYear> {
        private YearRule() {
        }

        @Override
        public Integer getValue(CalendarYear calendarYear) {
            return calendarYear.year;
        }

        @Override
        public Integer getMinimum(CalendarYear calendarYear) {
            return -999999999;
        }

        @Override
        public Integer getMaximum(CalendarYear calendarYear) {
            return 999999999;
        }

        @Override
        public boolean isValid(CalendarYear calendarYear, Integer n2) {
            if (n2 == null) {
                return false;
            }
            int n3 = n2;
            return n3 >= -999999999 && n3 <= 999999999;
        }

        @Override
        public CalendarYear withValue(CalendarYear calendarYear, Integer n2, boolean bl2) {
            if (this.isValid(calendarYear, n2)) {
                return CalendarYear.of(n2);
            }
            throw new IllegalArgumentException("Not valid: " + n2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CalendarYear calendarYear) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CalendarYear calendarYear) {
            return null;
        }

        @Override
        public int getInt(CalendarYear calendarYear) {
            return calendarYear.year;
        }

        @Override
        public boolean isValid(CalendarYear calendarYear, int n2) {
            return n2 >= -999999999 && n2 <= 999999999;
        }

        @Override
        public CalendarYear withValue(CalendarYear calendarYear, int n2, boolean bl2) {
            if (this.isValid(calendarYear, n2)) {
                return CalendarYear.of(n2);
            }
            throw new IllegalArgumentException("Not valid: " + n2);
        }
    }
}

