/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.history.Computus;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearStrategy;

public enum NewYearRule {
    BEGIN_OF_JANUARY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return HistoricDate.of(historicEra, n2, 1, 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            return historicDate.getYearOfEra();
        }
    }
    ,
    BEGIN_OF_MARCH{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return HistoricDate.of(historicEra, n2, 3, 1);
        }
    }
    ,
    BEGIN_OF_SEPTEMBER{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return HistoricDate.of(historicEra, n2 - 1, 9, 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            HistoricEra historicEra = historicDate.getEra();
            int n2 = historicDate.getYearOfEra();
            HistoricDate historicDate2 = newYearStrategy.newYear(historicEra, n2 + 1);
            int n3 = n2;
            if (historicDate.compareTo(historicDate2) >= 0) {
                ++n3;
            }
            return n3;
        }
    }
    ,
    CHRISTMAS_STYLE{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return HistoricDate.of(historicEra, n2 - 1, 12, 25);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            int n2 = historicDate.getYearOfEra();
            HistoricDate historicDate2 = newYearStrategy.newYear(historicDate.getEra(), n2 + 1);
            int n3 = n2;
            if (historicDate.compareTo(historicDate2) >= 0) {
                ++n3;
            }
            return n3;
        }
    }
    ,
    EASTER_STYLE{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            int n3 = historicEra.annoDomini(n2);
            int n4 = Computus.EASTERN.marchDay(n3) - 1;
            int n5 = 3;
            if (n4 > 31) {
                ++n5;
                n4 -= 31;
            }
            return HistoricDate.of(historicEra, n2, n5, n4);
        }
    }
    ,
    GOOD_FRIDAY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            int n3 = historicEra.annoDomini(n2);
            int n4 = Computus.EASTERN.marchDay(n3) - 2;
            int n5 = 3;
            if (n4 > 31) {
                ++n5;
                n4 -= 31;
            }
            return HistoricDate.of(historicEra, n2, n5, n4);
        }
    }
    ,
    MARIA_ANUNCIATA{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return HistoricDate.of(historicEra, n2, 3, 25);
        }
    }
    ,
    CALCULUS_PISANUS{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return MARIA_ANUNCIATA.newYear(historicEra, n2 + 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            int n2 = historicDate.getYearOfEra() - 1;
            HistoricDate historicDate2 = this.newYear(historicDate.getEra(), n2);
            int n3 = n2;
            if (historicDate.compareTo(historicDate2) < 0) {
                --n3;
            }
            return n3;
        }

        @Override
        int standardYear(boolean bl2, NewYearStrategy newYearStrategy, HistoricEra historicEra, int n2, int n3, int n4) {
            return MARIA_ANUNCIATA.standardYear(bl2, newYearStrategy, historicEra, n2 + 1, n3, n4);
        }
    }
    ,
    EPIPHANY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n2) {
            return HistoricDate.of(historicEra, n2, 1, 6);
        }
    };

    private static final int COUNCIL_OF_TOURS = 567;

    public NewYearStrategy until(int n2) {
        if (n2 <= 567) {
            throw new IllegalArgumentException("Defining New-Year-strategy is not supported before Council of Tours in AD 567.");
        }
        NewYearStrategy newYearStrategy = new NewYearStrategy(this, n2);
        if (this != BEGIN_OF_JANUARY) {
            NewYearStrategy newYearStrategy2 = new NewYearStrategy(BEGIN_OF_JANUARY, 567);
            newYearStrategy = newYearStrategy2.and(newYearStrategy);
        }
        return newYearStrategy;
    }

    abstract HistoricDate newYear(HistoricEra var1, int var2);

    int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
        int n2 = historicDate.getYearOfEra();
        HistoricDate historicDate2 = this.newYear(historicDate.getEra(), n2);
        int n3 = n2;
        if (historicDate.compareTo(historicDate2) < 0) {
            --n3;
        }
        return n3;
    }

    int standardYear(boolean bl2, NewYearStrategy newYearStrategy, HistoricEra historicEra, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 >= 5 && n3 <= 8) {
            return n2;
        }
        HistoricDate historicDate = this.newYear(historicEra, n2);
        HistoricDate historicDate2 = newYearStrategy.newYear(historicEra, n2 + 1);
        HistoricDate historicDate3 = HistoricDate.of(historicEra, n2, n3, n4);
        if (n3 <= 4) {
            HistoricDate historicDate4 = HistoricDate.of(historicEra, n2 + 1, n3, n4);
            n6 = historicDate3.compareTo(historicDate) >= 0 ? n2 : n2 + 1;
            n5 = historicDate4.compareTo(historicDate2) >= 0 ? n2 : n2 + 1;
        } else {
            HistoricDate historicDate5 = HistoricDate.of(historicEra, n2 - 1, n3, n4);
            n6 = historicDate5.compareTo(historicDate) >= 0 ? n2 - 1 : n2;
            int n7 = n5 = historicDate3.compareTo(historicDate2) >= 0 ? n2 - 1 : n2;
        }
        if (n6 > n5) {
            throw new IllegalArgumentException("Invalid date due to changing new year rule (year too short to cover month and day-of-month): " + historicDate3);
        }
        return bl2 ? n6 : n5;
    }
}

