/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.base.MathUtils;

class JulianMath {
    public static final int MIN_YEAR = -999999999;
    public static final int MAX_YEAR = 999999999;
    private static final int OFFSET = 678883;

    private JulianMath() {
    }

    public static boolean isLeapYear(int n2) {
        return MathUtils.floorModulo(n2, 4) == 0;
    }

    public static int getLengthOfMonth(int n2, int n3) {
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return JulianMath.isLeapYear(n2) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid month: " + n3);
    }

    public static boolean isValid(int n2, int n3, int n4) {
        return n2 >= -999999999 && n2 <= 999999999 && n3 >= 1 && n3 <= 12 && n4 >= 1 && n4 <= JulianMath.getLengthOfMonth(n2, n3);
    }

    public static int readYear(long l2) {
        return (int)(l2 >> 32);
    }

    public static int readMonth(long l2) {
        return (int)(l2 >> 16 & 0xFFL);
    }

    public static int readDayOfMonth(long l2) {
        return (int)(l2 & 0xFFL);
    }

    public static long toPackedDate(long l2) {
        int n2;
        int n3;
        long l3;
        long l4 = MathUtils.safeAdd(l2, 678883L);
        long l5 = MathUtils.floorDivide(l4, 1461);
        int n4 = MathUtils.floorModulo(l4, 1461);
        if (n4 == 1460) {
            l3 = (l5 + 1L) * 4L;
            n3 = 2;
            n2 = 29;
        } else {
            int n5 = n4 / 365;
            int n6 = n4 % 365;
            l3 = l5 * 4L + (long)n5;
            n3 = (n6 + 31) * 5 / 153 + 2;
            n2 = n6 - (n3 + 1) * 153 / 5 + 123;
            if (n3 > 12) {
                ++l3;
                n3 -= 12;
            }
        }
        if (l3 < -999999999L || l3 > 999999999L) {
            throw new IllegalArgumentException("Year out of range: " + l3);
        }
        long l6 = l3 << 32;
        l6 |= (long)(n3 << 16);
        return l6 |= (long)n2;
    }

    public static long toMJD(int n2, int n3, int n4) {
        JulianMath.checkDate(n2, n3, n4);
        long l2 = n2;
        int n5 = n3;
        if (n5 < 3) {
            --l2;
            n5 += 12;
        }
        long l3 = l2 * 365L + MathUtils.floorDivide(l2, 4) + (long)((n5 + 1) * 153 / 5) - 123L + (long)n4;
        return l3 - 678883L;
    }

    private static void checkDate(int n2, int n3, int n4) {
        if (n2 < -999999999 || n2 > 999999999) {
            throw new IllegalArgumentException("YEAR out of range: " + n2);
        }
        if (n3 < 1 || n3 > 12) {
            throw new IllegalArgumentException("MONTH out of range: " + n3);
        }
        if (n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException("DAY_OF_MONTH out of range: " + n4);
        }
        if (n4 > JulianMath.getLengthOfMonth(n2, n3)) {
            throw new IllegalArgumentException("DAY_OF_MONTH exceeds month length in given year: " + JulianMath.toString(n2, n3, n4));
        }
    }

    private static String toString(int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append('-');
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        return stringBuilder.toString();
    }
}

