/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.base.GregorianMath;
import net.time4j.history.Calculus;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.JulianMath;

enum CalendarAlgorithm implements Calculus
{
    GREGORIAN{

        @Override
        public long toMJD(HistoricDate historicDate) {
            return GregorianMath.toMJD(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public HistoricDate fromMJD(long l2) {
            long l3 = GregorianMath.toPackedDate(l2);
            int n2 = GregorianMath.readYear(l3);
            int n3 = GregorianMath.readMonth(l3);
            int n4 = GregorianMath.readDayOfMonth(l3);
            return new HistoricDate(n2 <= 0 ? HistoricEra.BC : HistoricEra.AD, n2 <= 0 ? 1 - n2 : n2, n3, n4);
        }

        @Override
        public boolean isValid(HistoricDate historicDate) {
            return GregorianMath.isValid(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public int getMaximumDayOfMonth(HistoricDate historicDate) {
            return GregorianMath.getLengthOfMonth(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth());
        }
    }
    ,
    JULIAN{

        @Override
        public long toMJD(HistoricDate historicDate) {
            return JulianMath.toMJD(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public HistoricDate fromMJD(long l2) {
            long l3 = JulianMath.toPackedDate(l2);
            int n2 = JulianMath.readYear(l3);
            int n3 = JulianMath.readMonth(l3);
            int n4 = JulianMath.readDayOfMonth(l3);
            return new HistoricDate(n2 <= 0 ? HistoricEra.BC : HistoricEra.AD, n2 <= 0 ? 1 - n2 : n2, n3, n4);
        }

        @Override
        public boolean isValid(HistoricDate historicDate) {
            int n2 = CalendarAlgorithm.getProlepticYear(historicDate);
            int n3 = historicDate.getMonth();
            int n4 = historicDate.getDayOfMonth();
            return JulianMath.isValid(n2, n3, n4);
        }

        @Override
        public int getMaximumDayOfMonth(HistoricDate historicDate) {
            return JulianMath.getLengthOfMonth(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth());
        }
    }
    ,
    SWEDISH{

        @Override
        public long toMJD(HistoricDate historicDate) {
            int n2 = CalendarAlgorithm.getProlepticYear(historicDate);
            if (historicDate.getDayOfMonth() == 30 && historicDate.getMonth() == 2 && n2 == 1712) {
                return -53576L;
            }
            return JulianMath.toMJD(n2, historicDate.getMonth(), historicDate.getDayOfMonth()) - 1L;
        }

        @Override
        public HistoricDate fromMJD(long l2) {
            if (l2 == -53576L) {
                return new HistoricDate(HistoricEra.AD, 1712, 2, 30);
            }
            return JULIAN.fromMJD(l2 + 1L);
        }

        @Override
        public boolean isValid(HistoricDate historicDate) {
            int n2 = CalendarAlgorithm.getProlepticYear(historicDate);
            if (historicDate.getDayOfMonth() == 30 && historicDate.getMonth() == 2 && n2 == 1712) {
                return true;
            }
            return JulianMath.isValid(n2, historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public int getMaximumDayOfMonth(HistoricDate historicDate) {
            int n2 = CalendarAlgorithm.getProlepticYear(historicDate);
            if (historicDate.getMonth() == 2 && n2 == 1712) {
                return 30;
            }
            return JulianMath.getLengthOfMonth(n2, historicDate.getMonth());
        }
    };


    private static int getProlepticYear(HistoricDate historicDate) {
        return historicDate.getEra().annoDomini(historicDate.getYearOfEra());
    }
}

