/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.internal;

import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.FormatUtils;
import net.time4j.format.internal.HourCycle;
import net.time4j.format.internal.LanguageMatch;
import net.time4j.format.internal.PropertyBundle;

public class IsoTextProviderSPI
implements TextProvider,
FormatPatternProvider {
    public static final IsoTextProviderSPI SINGLETON;
    private static final Set<String> LANGUAGES;
    private static final Set<Locale> LOCALES;
    private static final String ISO_PATH = "names/iso8601/iso8601";

    private IsoTextProviderSPI() {
    }

    @Override
    public boolean supportsCalendarType(String string) {
        return "iso8601".equals(string);
    }

    @Override
    public boolean supportsLanguage(Locale locale) {
        return LANGUAGES.contains(LanguageMatch.getAlias(locale));
    }

    @Override
    public String[] getSupportedCalendarTypes() {
        return new String[]{"iso8601"};
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[LOCALES.size()]);
    }

    @Override
    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl2) {
        return IsoTextProviderSPI.months(locale, textWidth, outputContext);
    }

    @Override
    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.quarters(locale, textWidth, outputContext);
    }

    @Override
    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.weekdays(locale, textWidth, outputContext);
    }

    @Override
    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        return IsoTextProviderSPI.eras(locale, textWidth);
    }

    @Override
    public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.meridiems(locale, textWidth, outputContext);
    }

    @Override
    public String getDatePattern(FormatStyle formatStyle, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("F(");
        stringBuilder.append(IsoTextProviderSPI.toChar(formatStyle));
        stringBuilder.append(")_d");
        String string = stringBuilder.toString();
        return IsoTextProviderSPI.getBundle(locale).getString(string);
    }

    @Override
    public String getTimePattern(FormatStyle formatStyle, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        if (locale.getUnicodeLocaleType("hc") == null) {
            stringBuilder.append("F(");
            stringBuilder.append(IsoTextProviderSPI.toChar(formatStyle));
            stringBuilder.append(")_t");
            String string = stringBuilder.toString();
            return IsoTextProviderSPI.getBundle(locale).getString(string);
        }
        HourCycle hourCycle = HourCycle.of(locale);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("F_");
        if (hourCycle.isHalfdayCycle()) {
            if (hourCycle.isUsingFlexibleDayperiods()) {
                stringBuilder2.append('B');
            }
            stringBuilder2.append('h');
        } else {
            stringBuilder2.append("H");
        }
        stringBuilder2.append('m');
        if (formatStyle != FormatStyle.SHORT) {
            stringBuilder2.append('s');
        }
        String string = IsoTextProviderSPI.getBundle(locale).getString(stringBuilder2.toString());
        if (hourCycle.isHalfdayCycle()) {
            if (hourCycle.isZeroBased()) {
                string = FormatUtils.replaceSymbol(string, 'h', 'K');
            }
        } else if (!hourCycle.isZeroBased()) {
            string = FormatUtils.replaceSymbol(string, 'H', 'k');
        }
        switch (formatStyle) {
            case FULL: {
                return string + " zzzz";
            }
            case LONG: {
                return string + " z";
            }
        }
        return string;
    }

    @Override
    public String getDateTimePattern(FormatStyle formatStyle, FormatStyle formatStyle2, Locale locale) {
        FormatStyle formatStyle3 = formatStyle;
        if (formatStyle.compareTo(formatStyle2) < 0) {
            formatStyle3 = formatStyle2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("F(");
        stringBuilder.append(IsoTextProviderSPI.toChar(formatStyle3));
        stringBuilder.append(")_dt");
        String string = stringBuilder.toString();
        return IsoTextProviderSPI.getBundle(locale).getString(string);
    }

    @Override
    public String getIntervalPattern(Locale locale) {
        return IsoTextProviderSPI.getBundle(locale).getString("I");
    }

    public String toString() {
        return "IsoTextProviderSPI";
    }

    public static Set<String> getPrimaryLanguages() {
        return LANGUAGES;
    }

    private static String[] months(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        String[] stringArray = null;
        PropertyBundle propertyBundle = IsoTextProviderSPI.getBundle(locale);
        if (propertyBundle != null) {
            String string;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = IsoTextProviderSPI.lookupBundle(propertyBundle, 12, string = IsoTextProviderSPI.getKey(propertyBundle, "MONTH_OF_YEAR"), textWidth, null, outputContext, 1)) == null) {
                if (outputContext == OutputContext.STANDALONE) {
                    if (textWidth != TextWidth.NARROW) {
                        stringArray = IsoTextProviderSPI.months(locale, textWidth, OutputContext.FORMAT);
                    }
                } else if (textWidth == TextWidth.ABBREVIATED) {
                    stringArray = IsoTextProviderSPI.months(locale, TextWidth.WIDE, OutputContext.FORMAT);
                } else if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.months(locale, textWidth, OutputContext.STANDALONE);
                }
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-month for locale: " + locale, IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] quarters(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        String[] stringArray = null;
        PropertyBundle propertyBundle = IsoTextProviderSPI.getBundle(locale);
        if (propertyBundle != null) {
            String string;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = IsoTextProviderSPI.lookupBundle(propertyBundle, 4, string = IsoTextProviderSPI.getKey(propertyBundle, "QUARTER_OF_YEAR"), textWidth, null, outputContext, 1)) == null) {
                if (outputContext == OutputContext.STANDALONE) {
                    if (textWidth != TextWidth.NARROW) {
                        stringArray = IsoTextProviderSPI.quarters(locale, textWidth, OutputContext.FORMAT);
                    }
                } else if (textWidth == TextWidth.ABBREVIATED) {
                    stringArray = IsoTextProviderSPI.quarters(locale, TextWidth.WIDE, OutputContext.FORMAT);
                } else if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.quarters(locale, textWidth, OutputContext.STANDALONE);
                }
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-quarter-of-year for locale: " + locale, IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] weekdays(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        String string;
        String[] stringArray = null;
        PropertyBundle propertyBundle = IsoTextProviderSPI.getBundle(locale);
        if (propertyBundle != null && (stringArray = IsoTextProviderSPI.lookupBundle(propertyBundle, 7, string = IsoTextProviderSPI.getKey(propertyBundle, "DAY_OF_WEEK"), textWidth, null, outputContext, 1)) == null) {
            if (outputContext == OutputContext.STANDALONE) {
                if (textWidth != TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.weekdays(locale, textWidth, OutputContext.FORMAT);
                }
            } else if (textWidth == TextWidth.ABBREVIATED) {
                stringArray = IsoTextProviderSPI.weekdays(locale, TextWidth.WIDE, OutputContext.FORMAT);
            } else if (textWidth == TextWidth.SHORT) {
                stringArray = IsoTextProviderSPI.weekdays(locale, TextWidth.ABBREVIATED, OutputContext.FORMAT);
            } else if (textWidth == TextWidth.NARROW) {
                stringArray = IsoTextProviderSPI.weekdays(locale, textWidth, OutputContext.STANDALONE);
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-day-of-week for locale: " + locale, IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] eras(Locale locale, TextWidth textWidth) throws MissingResourceException {
        String[] stringArray = null;
        PropertyBundle propertyBundle = IsoTextProviderSPI.getBundle(locale);
        if (propertyBundle != null) {
            TextWidth textWidth2;
            String string;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = IsoTextProviderSPI.lookupBundle(propertyBundle, 5, string = IsoTextProviderSPI.getKey(propertyBundle, "ERA"), textWidth, textWidth2 = textWidth == TextWidth.NARROW ? TextWidth.ABBREVIATED : null, OutputContext.FORMAT, 0)) == null && textWidth != TextWidth.ABBREVIATED) {
                stringArray = IsoTextProviderSPI.eras(locale, TextWidth.ABBREVIATED);
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-resource for era and locale: " + locale, IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] meridiems(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        PropertyBundle propertyBundle = IsoTextProviderSPI.getBundle(locale);
        if (propertyBundle != null) {
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            String string = IsoTextProviderSPI.meridiemKey("am", textWidth, outputContext);
            String string2 = IsoTextProviderSPI.meridiemKey("pm", textWidth, outputContext);
            if (propertyBundle.containsKey(string) && propertyBundle.containsKey(string2)) {
                String[] stringArray = new String[]{propertyBundle.getString(string), propertyBundle.getString(string2)};
                return stringArray;
            }
            if (outputContext == OutputContext.STANDALONE) {
                if (textWidth == TextWidth.ABBREVIATED) {
                    return IsoTextProviderSPI.meridiems(locale, textWidth, OutputContext.FORMAT);
                }
                return IsoTextProviderSPI.meridiems(locale, TextWidth.ABBREVIATED, outputContext);
            }
            if (textWidth != TextWidth.ABBREVIATED) {
                return IsoTextProviderSPI.meridiems(locale, TextWidth.ABBREVIATED, outputContext);
            }
        }
        throw new MissingResourceException("Cannot find ISO-8601-resource for am/pm and locale: " + locale, IsoTextProviderSPI.class.getName(), locale.toString());
    }

    private static PropertyBundle getBundle(Locale locale) throws MissingResourceException {
        return PropertyBundle.load(ISO_PATH, locale);
    }

    private static char toChar(FormatStyle formatStyle) {
        return Character.toLowerCase(formatStyle.name().charAt(0));
    }

    private static String[] lookupBundle(PropertyBundle propertyBundle, int n2, String string, TextWidth textWidth, TextWidth textWidth2, OutputContext outputContext, int n3) {
        String[] stringArray = new String[n2];
        boolean bl2 = string.length() == 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('(');
            if (bl2) {
                char c2 = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c2 = Character.toLowerCase(c2);
                }
                stringBuilder.append(c2);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i2 + n3);
            String string2 = stringBuilder.toString();
            if (propertyBundle.containsKey(string2)) {
                stringArray[i2] = propertyBundle.getString(string2);
                continue;
            }
            if (textWidth2 != null) {
                String[] stringArray2 = IsoTextProviderSPI.lookupBundle(propertyBundle, n2, string, textWidth2, null, outputContext, n3);
                if (stringArray2 != null) {
                    stringArray[i2] = stringArray2[i2];
                    continue;
                }
                return null;
            }
            return null;
        }
        return stringArray;
    }

    private static String getKey(PropertyBundle propertyBundle, String string) {
        if (propertyBundle.containsKey("useShortKeys") && "true".equals(propertyBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static String meridiemKey(String string, TextWidth textWidth, OutputContext outputContext) {
        char c2 = textWidth.name().charAt(0);
        if (outputContext == OutputContext.FORMAT) {
            c2 = Character.toLowerCase(c2);
        }
        return "P(" + String.valueOf(c2) + ")_" + string;
    }

    static {
        PropertyBundle propertyBundle = PropertyBundle.load(ISO_PATH, Locale.ROOT);
        String[] stringArray = propertyBundle.getString("languages").split(" ");
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        LANGUAGES = Collections.unmodifiableSet(hashSet);
        HashSet<Locale> hashSet2 = new HashSet<Locale>();
        for (String string : LANGUAGES) {
            hashSet2.add(new Locale(string));
        }
        for (LanguageMatch languageMatch : LanguageMatch.values()) {
            hashSet2.add(new Locale(languageMatch.name()));
        }
        LOCALES = Collections.unmodifiableSet(hashSet2);
        SINGLETON = new IsoTextProviderSPI();
    }
}

