/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.format.internal.GregorianTextElement;

final class TextProcessor<V>
implements FormatProcessor<V> {
    private final TextElement<V> element;
    private final boolean protectedMode;
    private final GregorianTextElement<V> gte;
    private final Locale language;
    private final TextWidth tw;
    private final OutputContext oc;
    private final Leniency lenientMode;
    private final int protectedLength;

    private TextProcessor(TextElement<V> textElement, boolean bl2, Locale locale, TextWidth textWidth, OutputContext outputContext, Leniency leniency, int n2) {
        if (textElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = textElement;
        this.protectedMode = bl2;
        this.gte = textElement instanceof GregorianTextElement ? (GregorianTextElement)textElement : null;
        this.language = locale;
        this.tw = textWidth;
        this.oc = outputContext;
        this.lenientMode = leniency;
        this.protectedLength = n2;
    }

    static <V> TextProcessor<V> create(TextElement<V> textElement) {
        return new TextProcessor<V>(textElement, false, Locale.ROOT, TextWidth.WIDE, OutputContext.FORMAT, Leniency.SMART, 0);
    }

    static <V> TextProcessor<V> createProtected(TextElement<V> textElement) {
        return new TextProcessor<V>(textElement, true, Locale.ROOT, TextWidth.WIDE, OutputContext.FORMAT, Leniency.SMART, 0);
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            int n2 = charSequence.length();
            if (this.print(chronoDisplay, appendable, attributeQuery, bl2)) {
                if (set != null) {
                    set.add(new ElementPosition(this.element, n2, charSequence.length()));
                }
                return charSequence.length() - n2;
            }
        } else if (this.print(chronoDisplay, appendable, attributeQuery, bl2)) {
            return Integer.MAX_VALUE;
        }
        return -1;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2;
        int n3 = parseLog.getPosition();
        int n4 = charSequence.length();
        int n5 = n2 = bl2 ? this.protectedLength : attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n2 > 0) {
            n4 -= n2;
        }
        if (n3 >= n4) {
            parseLog.setError(n3, "Missing chars for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        Object object = bl2 && this.gte != null && this.lenientMode != null ? this.gte.parse(charSequence, parseLog.getPP(), this.language, this.tw, this.oc, this.lenientMode) : (this.element instanceof DualFormatElement ? ((DualFormatElement)this.element).parse(charSequence, parseLog.getPP(), attributeQuery, parsedEntity) : this.element.parse(charSequence, parseLog.getPP(), attributeQuery));
        if (parseLog.isError()) {
            Class clazz = this.element.getType();
            if (clazz.isEnum()) {
                parseLog.setError(parseLog.getErrorIndex(), "No suitable enum found: " + clazz.getName());
            } else {
                parseLog.setError(parseLog.getErrorIndex(), "Unparseable element: " + this.element.name());
            }
        } else if (object == null) {
            parseLog.setError(n3, "No interpretable value.");
        } else if (this.element == PlainDate.MONTH_OF_YEAR) {
            parsedEntity.put((ChronoElement<?>)PlainDate.MONTH_AS_NUMBER, ((Month)Month.class.cast(object)).getValue());
        } else {
            parsedEntity.put(this.element, object);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TextProcessor) {
            TextProcessor textProcessor = (TextProcessor)object;
            return this.element.equals(textProcessor.element) && this.protectedMode == textProcessor.protectedMode;
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(",protected-mode=");
        stringBuilder.append(this.protectedMode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        if (chronoElement instanceof TextElement) {
            return TextProcessor.create((TextElement)chronoElement);
        }
        throw new IllegalArgumentException("Text element required: " + chronoElement.getClass().getName());
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<V> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        Leniency leniency = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        boolean bl2 = attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE);
        boolean bl3 = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        boolean bl4 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
        if (leniency == Leniency.STRICT && (bl2 || bl3 || bl4)) {
            leniency = null;
        } else if (!(leniency != Leniency.SMART || bl2 && bl3 && !bl4)) {
            leniency = null;
        } else if (!(bl2 && bl3 && bl4)) {
            leniency = null;
        }
        return new TextProcessor<V>(this.element, this.protectedMode, attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT), attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE), attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT), leniency, attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0));
    }

    private boolean print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, boolean bl2) throws IOException {
        if (this.gte != null && bl2) {
            this.gte.print(chronoDisplay, appendable, this.language, this.tw, this.oc);
            return true;
        }
        if (chronoDisplay.contains(this.element)) {
            this.element.print(chronoDisplay, appendable, attributeQuery);
            return true;
        }
        return false;
    }
}

