/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Set;
import java.util.function.IntPredicate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class SkipProcessor
implements FormatProcessor<Void> {
    private final int count;
    private final IntPredicate condition;

    SkipProcessor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Must not be negative: " + n2);
        }
        this.condition = null;
        this.count = n2;
    }

    SkipProcessor(IntPredicate intPredicate, int n2) {
        if (intPredicate == null) {
            throw new NullPointerException("Missing condition for unparseable chars.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Must be positive: " + n2);
        }
        this.condition = intPredicate;
        this.count = n2;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        return 0;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        int n2;
        int n3 = parseLog.getPosition();
        int n4 = charSequence.length();
        if (this.condition == null) {
            n2 = n4 - this.count;
        } else {
            n2 = n3;
            for (int i2 = 0; i2 < this.count && i2 + n3 < n4 && this.condition.test(charSequence.charAt(i2 + n3)); ++i2) {
                ++n2;
            }
        }
        n2 = Math.min(Math.max(n2, 0), n4);
        if (n2 > n3) {
            parseLog.setPosition(n2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SkipProcessor) {
            SkipProcessor skipProcessor = (SkipProcessor)object;
            return this.count == skipProcessor.count && (this.condition == null ? skipProcessor.condition == null : this.condition.equals(skipProcessor.condition));
        }
        return false;
    }

    public int hashCode() {
        return this.condition == null ? this.count : ~this.count ^ this.condition.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        if (this.condition == null) {
            stringBuilder.append("[keepRemainingChars=");
            stringBuilder.append(this.count);
        } else {
            stringBuilder.append("[condition=");
            stringBuilder.append(this.condition);
            stringBuilder.append(", maxIterations=");
            stringBuilder.append(this.count);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Void> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<Void> withElement(ChronoElement<Void> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<Void> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return this;
    }
}

