/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.format.expert.AmbivalentValueException;
import net.time4j.format.expert.ParsedEntity;

class ParsedValues
extends ParsedEntity<ParsedValues> {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INT_PHI = -1640531527;
    private static final Set<ChronoElement<?>> INDEXED_ELEMENTS;
    private Object[] keys;
    private Object[] values;
    private Map<ChronoElement<?>, Object> map;
    private int[] ints;
    private int len;
    private int mask;
    private int threshold;
    private int count;
    private boolean duplicateKeysAllowed = false;
    private int position = -1;

    ParsedValues(int n2, boolean bl2) {
        if (bl2) {
            this.len = Integer.MIN_VALUE;
            this.mask = Integer.MIN_VALUE;
            this.threshold = Integer.MIN_VALUE;
            this.count = Integer.MIN_VALUE;
            this.keys = null;
            this.values = null;
            this.ints = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                this.ints[i2] = Integer.MIN_VALUE;
            }
        } else {
            this.len = ParsedValues.arraySize(n2);
            this.mask = this.len - 1;
            this.threshold = ParsedValues.maxFill(this.len);
            this.keys = new Object[this.len];
            this.values = null;
            this.ints = new int[this.len];
            this.count = 0;
        }
        this.map = null;
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (chronoElement == PlainDate.YEAR) {
                return this.ints[0] != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainDate.MONTH_AS_NUMBER) {
                return this.ints[1] != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainDate.DAY_OF_MONTH) {
                return this.ints[2] != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.DIGITAL_HOUR_OF_DAY) {
                return this.len != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.MINUTE_OF_HOUR) {
                return this.mask != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.SECOND_OF_MINUTE) {
                return this.threshold != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.NANO_OF_SECOND) {
                return this.count != Integer.MIN_VALUE;
            }
            Map<ChronoElement<?>, Object> map = this.map;
            return map != null && map.containsKey(chronoElement);
        }
        int n2 = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n2];
        if (object == null) {
            return false;
        }
        if (chronoElement.equals(object)) {
            return true;
        }
        do {
            if ((object = objectArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!chronoElement.equals(object));
        return true;
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        int n2;
        Object object;
        Class<V> clazz = chronoElement.getType();
        if (clazz == Integer.class) {
            int n3 = this.getInt0(chronoElement);
            if (n3 == Integer.MIN_VALUE) {
                throw new ChronoException("No value found for: " + chronoElement.name());
            }
            return clazz.cast(n3);
        }
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            Map<ChronoElement<?>, Object> map = this.map;
            if (map != null && map.containsKey(chronoElement)) {
                return chronoElement.getType().cast(map.get(chronoElement));
            }
            throw new ChronoException("No value found for: " + chronoElement.name());
        }
        if (this.values == null || (object = objectArray[n2 = ParsedValues.mix(chronoElement.hashCode()) & this.mask]) == null) {
            throw new ChronoException("No value found for: " + chronoElement.name());
        }
        if (chronoElement.equals(object)) {
            return clazz.cast(this.values[n2]);
        }
        do {
            if ((object = objectArray[n2 = n2 + 1 & this.mask]) != null) continue;
            throw new ChronoException("No value found for: " + chronoElement.name());
        } while (!chronoElement.equals(object));
        return clazz.cast(this.values[n2]);
    }

    @Override
    public int getInt(ChronoElement<Integer> chronoElement) {
        return this.getInt0(chronoElement);
    }

    @Override
    public Set<ChronoElement<?>> getRegisteredElements() {
        if (this.keys == null) {
            HashSet<ChronoElement<Object>> hashSet = new HashSet<ChronoElement<Object>>();
            if (this.ints[0] != Integer.MIN_VALUE) {
                hashSet.add(PlainDate.YEAR);
            }
            if (this.ints[1] != Integer.MIN_VALUE) {
                hashSet.add(PlainDate.MONTH_AS_NUMBER);
            }
            if (this.ints[2] != Integer.MIN_VALUE) {
                hashSet.add(PlainDate.DAY_OF_MONTH);
            }
            if (this.len != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.DIGITAL_HOUR_OF_DAY);
            }
            if (this.mask != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.MINUTE_OF_HOUR);
            }
            if (this.threshold != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.SECOND_OF_MINUTE);
            }
            if (this.count != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.NANO_OF_SECOND);
            }
            if (this.map != null) {
                hashSet.addAll(this.map.keySet());
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return new KeySet();
    }

    void setPosition(int n2) {
        this.position = n2;
    }

    int getPosition() {
        return this.position;
    }

    void setNoAmbivalentCheck() {
        this.duplicateKeysAllowed = true;
    }

    static boolean isIndexed(ChronoElement<?> chronoElement) {
        return INDEXED_ELEMENTS.contains(chronoElement);
    }

    void putAll(ParsedValues parsedValues) {
        if (this.keys == null) {
            int n2 = parsedValues.len;
            if (n2 != Integer.MIN_VALUE) {
                if (this.len == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.len == n2) {
                    this.len = n2;
                } else {
                    throw new AmbivalentValueException(PlainTime.DIGITAL_HOUR_OF_DAY);
                }
            }
            if ((n2 = parsedValues.mask) != Integer.MIN_VALUE) {
                if (this.mask == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.mask == n2) {
                    this.mask = n2;
                } else {
                    throw new AmbivalentValueException(PlainTime.MINUTE_OF_HOUR);
                }
            }
            if ((n2 = parsedValues.threshold) != Integer.MIN_VALUE) {
                if (this.threshold == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.threshold == n2) {
                    this.threshold = n2;
                } else {
                    throw new AmbivalentValueException(PlainTime.SECOND_OF_MINUTE);
                }
            }
            if ((n2 = parsedValues.count) != Integer.MIN_VALUE) {
                if (this.count == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.count == n2) {
                    this.count = n2;
                } else {
                    throw new AmbivalentValueException(PlainTime.NANO_OF_SECOND);
                }
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                n2 = parsedValues.ints[i2];
                if (n2 == Integer.MIN_VALUE) continue;
                if (this.ints[i2] == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.ints[i2] == n2) {
                    this.ints[i2] = n2;
                    continue;
                }
                throw new AmbivalentValueException(ParsedValues.getIndexedElement(i2));
            }
            Map<ChronoElement<?>, Object> map = parsedValues.map;
            if (map != null) {
                for (ChronoElement<?> chronoElement : map.keySet()) {
                    this.put(chronoElement, map.get(chronoElement));
                }
            }
            return;
        }
        Object[] objectArray = parsedValues.keys;
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            Object object = objectArray[i3];
            if (object == null) continue;
            ChronoElement chronoElement = (ChronoElement)ChronoElement.class.cast(object);
            if (chronoElement.getType() == Integer.class) {
                this.put(chronoElement, parsedValues.ints[i3]);
                continue;
            }
            this.put(chronoElement, parsedValues.values[i3]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void put(ChronoElement<?> chronoElement, int n2) {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (chronoElement == PlainDate.YEAR) {
                if (!this.duplicateKeysAllowed && this.ints[0] != Integer.MIN_VALUE && this.ints[0] != n2) throw new AmbivalentValueException(chronoElement);
                this.ints[0] = n2;
                return;
            } else if (chronoElement == PlainDate.MONTH_AS_NUMBER) {
                if (!this.duplicateKeysAllowed && this.ints[1] != Integer.MIN_VALUE && this.ints[1] != n2) throw new AmbivalentValueException(chronoElement);
                this.ints[1] = n2;
                return;
            } else if (chronoElement == PlainDate.DAY_OF_MONTH) {
                if (!this.duplicateKeysAllowed && this.ints[2] != Integer.MIN_VALUE && this.ints[2] != n2) throw new AmbivalentValueException(chronoElement);
                this.ints[2] = n2;
                return;
            } else if (chronoElement == PlainTime.DIGITAL_HOUR_OF_DAY) {
                if (!this.duplicateKeysAllowed && this.len != Integer.MIN_VALUE && this.len != n2) throw new AmbivalentValueException(chronoElement);
                this.len = n2;
                return;
            } else if (chronoElement == PlainTime.MINUTE_OF_HOUR) {
                if (!this.duplicateKeysAllowed && this.mask != Integer.MIN_VALUE && this.mask != n2) throw new AmbivalentValueException(chronoElement);
                this.mask = n2;
                return;
            } else if (chronoElement == PlainTime.SECOND_OF_MINUTE) {
                if (!this.duplicateKeysAllowed && this.threshold != Integer.MIN_VALUE && this.threshold != n2) throw new AmbivalentValueException(chronoElement);
                this.threshold = n2;
                return;
            } else if (chronoElement == PlainTime.NANO_OF_SECOND) {
                if (!this.duplicateKeysAllowed && this.count != Integer.MIN_VALUE && this.count != n2) throw new AmbivalentValueException(chronoElement);
                this.count = n2;
                return;
            } else {
                Map<ChronoElement<?>, Object> map = this.map;
                if (map == null) {
                    map = new HashMap();
                    this.map = map;
                }
                Integer n3 = n2;
                if (!this.duplicateKeysAllowed && map.containsKey(chronoElement) && !((Object)n3).equals(map.get(chronoElement))) throw new AmbivalentValueException(chronoElement);
                map.put(chronoElement, n3);
                return;
            }
        }
        int n4 = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n4];
        if (object != null) {
            if (object.equals(chronoElement)) {
                if (!this.duplicateKeysAllowed && this.ints[n4] != n2) throw new AmbivalentValueException(chronoElement);
                this.ints[n4] = n2;
                return;
            }
            while ((object = objectArray[n4 = n4 + 1 & this.mask]) != null) {
                if (!object.equals(chronoElement)) continue;
                if (!this.duplicateKeysAllowed && this.ints[n4] != n2) throw new AmbivalentValueException(chronoElement);
                this.ints[n4] = n2;
                return;
            }
        }
        objectArray[n4] = chronoElement;
        this.ints[n4] = n2;
        if (this.count++ < this.threshold) return;
        this.rehash(ParsedValues.arraySize(this.count));
    }

    @Override
    void put(ChronoElement<?> chronoElement, Object object) {
        int n2;
        Object object2;
        if (object == null) {
            this.remove(chronoElement);
            return;
        }
        if (chronoElement.getType() == Integer.class) {
            this.put(chronoElement, (Integer)Integer.class.cast(object));
            return;
        }
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            Map<ChronoElement<?>, Object> map = this.map;
            if (map == null) {
                map = new HashMap();
                this.map = map;
            }
            if (this.duplicateKeysAllowed || !map.containsKey(chronoElement) || object.equals(map.get(chronoElement))) {
                map.put(chronoElement, object);
                return;
            }
            throw new AmbivalentValueException(chronoElement);
        }
        if (this.values == null) {
            this.values = new Object[this.len];
        }
        if ((object2 = objectArray[n2 = ParsedValues.mix(chronoElement.hashCode()) & this.mask]) != null) {
            if (object2.equals(chronoElement)) {
                if (this.duplicateKeysAllowed || object.equals(this.values[n2])) {
                    this.values[n2] = object;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
            while ((object2 = objectArray[n2 = n2 + 1 & this.mask]) != null) {
                if (!object2.equals(chronoElement)) continue;
                if (this.duplicateKeysAllowed || object.equals(this.values[n2])) {
                    this.values[n2] = object;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
        }
        objectArray[n2] = chronoElement;
        this.values[n2] = object;
        if (this.count++ >= this.threshold) {
            this.rehash(ParsedValues.arraySize(this.count));
        }
    }

    @Override
    void setResult(Object object) {
    }

    @Override
    <E> E getResult() {
        return null;
    }

    void reset() {
        if (this.keys == null) {
            this.len = Integer.MIN_VALUE;
            this.mask = Integer.MIN_VALUE;
            this.threshold = Integer.MIN_VALUE;
            this.count = Integer.MIN_VALUE;
            for (int i2 = 0; i2 < 3; ++i2) {
                this.ints[i2] = Integer.MIN_VALUE;
            }
            this.map = null;
        } else {
            this.keys = new Object[this.keys.length];
        }
        this.count = 0;
    }

    private int getInt0(ChronoElement<?> chronoElement) {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (chronoElement == PlainDate.YEAR) {
                return this.ints[0];
            }
            if (chronoElement == PlainDate.MONTH_AS_NUMBER) {
                return this.ints[1];
            }
            if (chronoElement == PlainDate.DAY_OF_MONTH) {
                return this.ints[2];
            }
            if (chronoElement == PlainTime.DIGITAL_HOUR_OF_DAY) {
                return this.len;
            }
            if (chronoElement == PlainTime.MINUTE_OF_HOUR) {
                return this.mask;
            }
            if (chronoElement == PlainTime.SECOND_OF_MINUTE) {
                return this.threshold;
            }
            if (chronoElement == PlainTime.NANO_OF_SECOND) {
                return this.count;
            }
            Map<ChronoElement<?>, Object> map = this.map;
            if (map != null && map.containsKey(chronoElement)) {
                return (Integer)Integer.class.cast(map.get(chronoElement));
            }
            return Integer.MIN_VALUE;
        }
        int n2 = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n2];
        if (object == null) {
            return Integer.MIN_VALUE;
        }
        if (chronoElement.equals(object)) {
            return this.ints[n2];
        }
        do {
            if ((object = objectArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return Integer.MIN_VALUE;
        } while (!chronoElement.equals(object));
        return this.ints[n2];
    }

    private void remove(Object object) {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (object == PlainDate.YEAR) {
                this.ints[0] = Integer.MIN_VALUE;
            } else if (object == PlainDate.MONTH_AS_NUMBER) {
                this.ints[1] = Integer.MIN_VALUE;
            } else if (object == PlainDate.DAY_OF_MONTH) {
                this.ints[2] = Integer.MIN_VALUE;
            } else if (object == PlainTime.DIGITAL_HOUR_OF_DAY) {
                this.len = Integer.MIN_VALUE;
            } else if (object == PlainTime.MINUTE_OF_HOUR) {
                this.mask = Integer.MIN_VALUE;
            } else if (object == PlainTime.SECOND_OF_MINUTE) {
                this.threshold = Integer.MIN_VALUE;
            } else if (object == PlainTime.NANO_OF_SECOND) {
                this.count = Integer.MIN_VALUE;
            } else {
                Map<ChronoElement<?>, Object> map = this.map;
                if (map != null) {
                    map.remove(object);
                }
            }
            return;
        }
        int n2 = ParsedValues.mix(object.hashCode()) & this.mask;
        Object object2 = objectArray[n2];
        if (object2 == null) {
            return;
        }
        if (object.equals(object2)) {
            this.removeEntry(n2);
            return;
        }
        do {
            if ((object2 = objectArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return;
        } while (!object.equals(object2));
        this.removeEntry(n2);
    }

    private void removeEntry(int n2) {
        --this.count;
        Object[] objectArray = this.keys;
        while (true) {
            Object object;
            int n3 = n2;
            n2 = n3 + 1 & this.mask;
            while (true) {
                if ((object = objectArray[n2]) == null) {
                    objectArray[n3] = null;
                    return;
                }
                int n4 = ParsedValues.mix(object.hashCode()) & this.mask;
                if (n3 <= n2 ? n3 >= n4 || n4 > n2 : n3 >= n4 && n4 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            objectArray[n3] = object;
            if (this.values != null) {
                this.values[n3] = this.values[n2];
            }
            this.ints[n3] = this.ints[n2];
        }
    }

    private static int arraySize(int n2) {
        return Math.max(2, ParsedValues.nextPowerOfTwo((int)Math.ceil((float)n2 / 0.75f)));
    }

    private static int nextPowerOfTwo(int n2) {
        if (n2 == 0) {
            return 1;
        }
        --n2;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        return (n2 | n2 >> 16) + 1;
    }

    private static int maxFill(int n2) {
        return Math.min((int)Math.ceil((float)n2 * 0.75f), n2 - 1);
    }

    private static int mix(int n2) {
        int n3 = n2 * -1640531527;
        return n3 ^ n3 >>> 16;
    }

    private void rehash(int n2) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int[] nArray = this.ints;
        int n3 = n2 - 1;
        Object[] objectArray3 = new Object[n2];
        Object[] objectArray4 = objectArray2 == null ? null : new Object[n2];
        int[] nArray2 = new int[n2];
        int n4 = this.len;
        int n5 = this.count;
        for (int i2 = 0; i2 < n5; ++i2) {
            while (objectArray[--n4] == null) {
            }
            int n6 = ParsedValues.mix(objectArray[n4].hashCode()) & n3;
            if (objectArray3[n6] != null) {
                while (objectArray3[n6 = n6 + 1 & n3] != null) {
                }
            }
            objectArray3[n6] = objectArray[n4];
            if (objectArray2 != null) {
                objectArray4[n6] = objectArray2[n4];
            }
            nArray2[n6] = nArray[n4];
        }
        this.len = n2;
        this.mask = n3;
        this.threshold = ParsedValues.maxFill(n2);
        this.keys = objectArray3;
        this.values = objectArray4;
        this.ints = nArray2;
    }

    private static ChronoElement<Integer> getIndexedElement(int n2) {
        switch (n2) {
            case 0: {
                return PlainDate.YEAR;
            }
            case 1: {
                return PlainDate.MONTH_AS_NUMBER;
            }
            case 2: {
                return PlainDate.DAY_OF_MONTH;
            }
            case 3: {
                return PlainTime.DIGITAL_HOUR_OF_DAY;
            }
            case 4: {
                return PlainTime.MINUTE_OF_HOUR;
            }
            case 5: {
                return PlainTime.SECOND_OF_MINUTE;
            }
            case 6: {
                return PlainTime.NANO_OF_SECOND;
            }
        }
        throw new IllegalStateException("No element index: " + n2);
    }

    static {
        HashSet hashSet = new HashSet();
        hashSet.add(PlainDate.YEAR);
        hashSet.add(PlainDate.MONTH_AS_NUMBER);
        hashSet.add(PlainDate.DAY_OF_MONTH);
        hashSet.add(PlainTime.DIGITAL_HOUR_OF_DAY);
        hashSet.add(PlainTime.MINUTE_OF_HOUR);
        hashSet.add(PlainTime.SECOND_OF_MINUTE);
        hashSet.add(PlainTime.NANO_OF_SECOND);
        INDEXED_ELEMENTS = Collections.unmodifiableSet(hashSet);
    }

    private class KeySet
    extends AbstractSet<ChronoElement<?>> {
        private KeySet() {
        }

        @Override
        public Iterator<ChronoElement<?>> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ParsedValues.this.count;
        }
    }

    private class KeyIterator
    implements Iterator<ChronoElement<?>> {
        int pos;
        int c;

        private KeyIterator() {
            this.pos = ParsedValues.this.len;
            this.c = ParsedValues.this.count;
        }

        @Override
        public boolean hasNext() {
            return this.c > 0;
        }

        @Override
        public ChronoElement<?> next() {
            if (this.c > 0) {
                Object[] objectArray = ParsedValues.this.keys;
                while (--this.pos >= 0) {
                    if (objectArray[this.pos] == null) continue;
                    --this.c;
                    return (ChronoElement)ChronoElement.class.cast(objectArray[this.pos]);
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

