/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import net.time4j.engine.ChronoElement;

public final class ElementPosition {
    private final ChronoElement<?> element;
    private final int startIndex;
    private final int endIndex;

    public ElementPosition(ChronoElement<?> chronoElement, int n2, int n3) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative start index: " + n2 + " (" + chronoElement.name() + ")");
        }
        if (n3 <= n2) {
            throw new IllegalArgumentException("End index " + n3 + " must be greater than start index " + n2 + " (" + chronoElement.name() + ")");
        }
        this.element = chronoElement;
        this.startIndex = n2;
        this.endIndex = n3;
    }

    public ChronoElement<?> getElement() {
        return this.element;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ElementPosition) {
            ElementPosition elementPosition = (ElementPosition)object;
            return this.element.equals(elementPosition.element) && this.startIndex == elementPosition.startIndex && this.endIndex == elementPosition.endIndex;
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode() + 37 * (this.startIndex | this.endIndex << 16);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(",start-index=");
        stringBuilder.append(this.startIndex);
        stringBuilder.append(",end-index=");
        stringBuilder.append(this.endIndex);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

