/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.time.chrono.ChronoLocalDate;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.Chronology;
import net.time4j.engine.DateTools;
import net.time4j.engine.EpochDays;
import net.time4j.engine.Temporal;
import net.time4j.engine.VariantSource;

public interface CalendarDate
extends Temporal<CalendarDate> {
    public long getDaysSinceEpochUTC();

    default public <T extends Calendrical<?, T>> T transform(Chronology<T> chronology) {
        long l2 = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem();
        return (T)((Calendrical)DateTools.convert(l2, calendarSystem, chronology));
    }

    default public <T extends CalendarVariant<T>> T transform(CalendarFamily<T> calendarFamily, String string) {
        long l2 = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = calendarFamily.getCalendarSystem(string);
        return (T)((CalendarVariant)DateTools.convert(l2, calendarSystem, calendarFamily));
    }

    default public <T extends CalendarVariant<T>> T transform(CalendarFamily<T> calendarFamily, VariantSource variantSource) {
        return this.transform(calendarFamily, variantSource.getVariant());
    }

    default public <T extends Calendrical<?, T>> T transform(Class<T> clazz) {
        String string = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string);
        }
        long l2 = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem();
        return (T)((Calendrical)DateTools.convert(l2, calendarSystem, chronology));
    }

    default public <T extends CalendarVariant<T>> T transform(Class<T> clazz, String string) {
        String string2 = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string2);
        }
        long l2 = this.getDaysSinceEpochUTC();
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem(string);
        return (T)((CalendarVariant)DateTools.convert(l2, calendarSystem, chronology));
    }

    default public <T extends CalendarVariant<T>> T transform(Class<T> clazz, VariantSource variantSource) {
        return this.transform(clazz, variantSource.getVariant());
    }

    public static <T extends CalendarVariant<T>> T from(ChronoLocalDate chronoLocalDate, CalendarFamily<T> calendarFamily, VariantSource variantSource) {
        return CalendarDate.from(chronoLocalDate, calendarFamily, variantSource.getVariant());
    }

    public static <T extends CalendarVariant<T>> T from(ChronoLocalDate chronoLocalDate, CalendarFamily<T> calendarFamily, String string) {
        long l2 = EpochDays.UTC.transform(chronoLocalDate.toEpochDay(), EpochDays.UNIX);
        CalendarSystem<T> calendarSystem = calendarFamily.getCalendarSystem(string);
        return (T)((CalendarVariant)DateTools.convert(l2, calendarSystem, calendarFamily));
    }

    public static <T extends Calendrical<?, T>> T from(ChronoLocalDate chronoLocalDate, Chronology<T> chronology) {
        long l2 = EpochDays.UTC.transform(chronoLocalDate.toEpochDay(), EpochDays.UNIX);
        CalendarSystem<T> calendarSystem = chronology.getCalendarSystem();
        return (T)((Calendrical)DateTools.convert(l2, calendarSystem, chronology));
    }
}

