/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.io.IOException;
import java.text.ParsePosition;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;

public abstract class DualYearOfEraElement<T extends ChronoEntity<T>>
extends StdIntegerDateElement<T>
implements DualFormatElement {
    protected DualYearOfEraElement(Class<T> clazz, int n2, int n3, char c2) {
        super("YEAR_OF_ERA", clazz, n2, n3, c2);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        int n2;
        NumberSystem numberSystem = this.getNumberSystem(attributeQuery);
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.NARROW);
        switch (textWidth) {
            case NARROW: {
                n2 = 1;
                break;
            }
            case SHORT: {
                n2 = 2;
                break;
            }
            case ABBREVIATED: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        char c2 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        this.print(chronoDisplay, appendable, attributeQuery, numberSystem, c2, n2, 10);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c2, int n2, int n3) throws IOException, ChronoException {
        int n4 = chronoDisplay.getInt(this);
        String string = numberSystem.toNumeral(n4);
        if (numberSystem.isDecimal()) {
            int n5 = string.length();
            int n6 = n2 - n5;
            for (int i2 = 0; i2 < n6; ++i2) {
                appendable.append(c2);
            }
        }
        appendable.append(string);
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        int n2;
        NumberSystem numberSystem = this.getNumberSystem(attributeQuery);
        int n3 = n2 = parsePosition.getIndex();
        int n4 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (int)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (int)numberSystem.getDigits().charAt(0) : 48);
        long l2 = 0L;
        if (numberSystem.hasDecimalCodepoints()) {
            int n5;
            int n6 = Math.min(n3 + 9, charSequence.length());
            for (int i2 = n3; i2 < n6 && (n5 = charSequence.charAt(i2) - n4) >= 0 && n5 <= 9; ++i2) {
                l2 = l2 * 10L + (long)n5;
                ++n3;
            }
        } else {
            int n7 = 0;
            int n8 = charSequence.length();
            for (int i3 = n3; i3 < n8 && numberSystem.contains(charSequence.charAt(i3)); ++i3) {
                ++n7;
            }
            if (n7 > 0) {
                l2 = numberSystem.toInteger(charSequence.subSequence(n3, n3 + n7).toString(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
                n3 += n7;
            }
        }
        if (n3 == n2 || l2 > Integer.MAX_VALUE) {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        parsePosition.setIndex(n3);
        return (int)l2;
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
        return this.parse(charSequence, parsePosition, attributeQuery);
    }

    protected abstract NumberSystem getNumberSystem(AttributeQuery var1);
}

