/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.function.LongFunction;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.MoonPhase;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.hindu.AryaSiddhanta;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduRule;
import net.time4j.calendar.hindu.SPX;
import net.time4j.engine.EpochDays;
import net.time4j.engine.VariantSource;
import net.time4j.scale.TimeScale;

public final class HinduVariant
implements VariantSource,
Serializable {
    static final GeoLocation UJJAIN = GeoLocation.of(23.15, 75.76833333333333);
    private static final double U_OFFSET = 18184.4;
    private static final HinduRule[] RULES = HinduRule.values();
    private static final int TYPE_OLD_SOLAR = -1;
    private static final int TYPE_OLD_LUNAR = -2;
    static final HinduVariant VAR_OLD_SOLAR = new HinduVariant(AryaSiddhanta.SOLAR);
    static final HinduVariant VAR_OLD_LUNAR = new HinduVariant(AryaSiddhanta.LUNAR);
    private final transient int type;
    private final transient HinduEra defaultEra;
    private final transient boolean elapsedMode;
    private final transient double depressionAngle;
    private final transient GeoLocation location;

    HinduVariant(HinduRule hinduRule, HinduEra hinduEra) {
        this(hinduRule.ordinal(), hinduEra, HinduVariant.useStandardElapsedMode(hinduEra, hinduRule), Double.NaN, UJJAIN);
    }

    private HinduVariant(AryaSiddhanta aryaSiddhanta) {
        this(aryaSiddhanta == AryaSiddhanta.SOLAR ? -1 : -2, HinduEra.KALI_YUGA, true, Double.NaN, UJJAIN);
    }

    private HinduVariant(int n2, HinduEra hinduEra, boolean bl2, double d2, GeoLocation geoLocation) {
        if (n2 < -2 || n2 >= HinduRule.values().length) {
            throw new IllegalArgumentException("Undefined Hindu rule.");
        }
        if (hinduEra == null) {
            throw new NullPointerException("Missing default Hindu era.");
        }
        if (geoLocation == null) {
            throw new NullPointerException("Missing geographical location.");
        }
        if (Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Infinite depression angle.");
        }
        if (!Double.isNaN(d2) && Math.abs(d2) > 10.0) {
            throw new IllegalArgumentException("Depression angle is too big: " + d2);
        }
        this.type = n2;
        this.defaultEra = hinduEra;
        this.elapsedMode = bl2;
        this.depressionAngle = d2;
        this.location = geoLocation;
    }

    public static HinduVariant from(String string) {
        if (string.startsWith("AryaSiddhanta@")) {
            try {
                AryaSiddhanta aryaSiddhanta = AryaSiddhanta.valueOf(string.substring("AryaSiddhanta@".length()));
                return aryaSiddhanta == AryaSiddhanta.SOLAR ? VAR_OLD_SOLAR : VAR_OLD_LUNAR;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Invalid variant: " + string, indexOutOfBoundsException);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        HinduEra hinduEra = null;
        boolean bl2 = true;
        double d2 = Double.NaN;
        double d3 = UJJAIN.getLatitude();
        double d4 = UJJAIN.getLongitude();
        int n4 = UJJAIN.getAltitude();
        boolean bl3 = true;
        block13: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (++n2) {
                case 1: {
                    n3 = Integer.valueOf(string2);
                    continue block13;
                }
                case 2: {
                    hinduEra = HinduEra.valueOf(string2);
                    continue block13;
                }
                case 3: {
                    bl2 = string2.equals("elapsed");
                    continue block13;
                }
                case 4: {
                    if (string2.equals("oldstyle") || string2.equals("alt") || string2.equals("std")) continue block13;
                    d2 = Double.valueOf(string2);
                    continue block13;
                }
                case 5: {
                    d3 = Double.valueOf(string2);
                    bl3 = d3 == UJJAIN.getLatitude();
                    continue block13;
                }
                case 6: {
                    d4 = Double.valueOf(string2);
                    bl3 = bl3 && d4 == UJJAIN.getLongitude();
                    continue block13;
                }
                case 7: {
                    n4 = Integer.valueOf(string2);
                    bl3 = bl3 && n4 == 0;
                    continue block13;
                }
            }
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
        try {
            return new HinduVariant(n3, hinduEra, bl2, d2, bl3 ? UJJAIN : GeoLocation.of(d3, d4, n4));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid variant: " + string);
        }
    }

    public HinduEra getDefaultEra() {
        return this.defaultEra;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public boolean isSolar() {
        return !this.isLunisolar();
    }

    public boolean isLunisolar() {
        return this.isAmanta() || this.isPurnimanta();
    }

    public boolean isAmanta() {
        if (this.type == -2) {
            return true;
        }
        return this.type >= HinduRule.AMANTA.ordinal() && this.type < HinduRule.PURNIMANTA.ordinal();
    }

    public boolean isPurnimanta() {
        return this.type == HinduRule.PURNIMANTA.ordinal();
    }

    public boolean isOld() {
        return this.type < 0;
    }

    public boolean isUsingElapsedYears() {
        return this.elapsedMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduVariant) {
            HinduVariant hinduVariant = (HinduVariant)object;
            return this.type == hinduVariant.type && this.defaultEra == hinduVariant.defaultEra && this.elapsedMode == hinduVariant.elapsedMode && HinduVariant.equals(this.depressionAngle, hinduVariant.depressionAngle) && this.location.getLatitude() == hinduVariant.location.getLatitude() && this.location.getLongitude() == hinduVariant.location.getLongitude() && this.location.getAltitude() == hinduVariant.location.getAltitude();
        }
        return false;
    }

    public int hashCode() {
        return this.type + 17 * this.defaultEra.hashCode() + (this.elapsedMode ? 1 : 0) + (Double.isNaN(this.depressionAngle) ? 100 : (int)this.depressionAngle * 100);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hindu-variant=[");
        switch (this.type) {
            case -1: {
                stringBuilder.append("OLD-SOLAR");
                break;
            }
            case -2: {
                stringBuilder.append("OLD-LUNAR");
                break;
            }
            default: {
                stringBuilder.append(this.getRule().name());
            }
        }
        if (!this.isOld()) {
            stringBuilder.append("|default-era=");
            stringBuilder.append(this.defaultEra.name());
            stringBuilder.append('|');
            stringBuilder.append(this.elapsedMode ? "elapsed-year-mode" : "current-year-mode");
            if (!Double.isNaN(this.depressionAngle)) {
                stringBuilder.append("|depression-angle=");
                stringBuilder.append(this.depressionAngle);
            }
            if (this.location != UJJAIN) {
                stringBuilder.append("|lat=");
                stringBuilder.append(this.location.getLatitude());
                stringBuilder.append(",lng=");
                stringBuilder.append(this.location.getLongitude());
                int n2 = this.location.getAltitude();
                if (n2 != 0) {
                    stringBuilder.append(",alt=");
                    stringBuilder.append(n2);
                }
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getVariant() {
        if (this.isOld()) {
            AryaSiddhanta aryaSiddhanta = this.type == -1 ? AryaSiddhanta.SOLAR : AryaSiddhanta.LUNAR;
            return "AryaSiddhanta@" + aryaSiddhanta.name();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type);
        stringBuilder.append('|');
        stringBuilder.append(this.defaultEra.name());
        stringBuilder.append('|');
        stringBuilder.append(this.elapsedMode ? "elapsed" : "current");
        stringBuilder.append('|');
        stringBuilder.append(Double.isNaN(this.depressionAngle) ? "oldstyle" : Double.valueOf(this.depressionAngle));
        if (this.location != UJJAIN) {
            stringBuilder.append('|');
            stringBuilder.append(this.location.getLatitude());
            stringBuilder.append('|');
            stringBuilder.append(this.location.getLongitude());
            int n2 = this.location.getAltitude();
            if (n2 != 0) {
                stringBuilder.append('|');
                stringBuilder.append(n2);
            }
        }
        return stringBuilder.toString();
    }

    public HinduVariant with(HinduEra hinduEra) {
        if (this.isOld() || this.defaultEra.equals(hinduEra)) {
            return this;
        }
        return new HinduVariant(this.type, hinduEra, this.elapsedMode, this.depressionAngle, this.location);
    }

    public HinduVariant withElapsedYears() {
        if (this.isOld() || this.elapsedMode) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, true, this.depressionAngle, this.location);
    }

    public HinduVariant withCurrentYears() {
        if (this.isOld() || !this.elapsedMode) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, false, this.depressionAngle, this.location);
    }

    @Deprecated
    public HinduVariant withAlternativeHinduSunrise() {
        return this;
    }

    public HinduVariant withModernAstronomy(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Depression angle must be a finite number.");
        }
        if (this.isOld()) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, this.elapsedMode, d2, this.location);
    }

    public HinduVariant withAlternativeLocation(GeoLocation geoLocation) {
        if (Math.abs(geoLocation.getLatitude()) > 60.0) {
            throw new IllegalArgumentException("Latitudes beyond +/-60\u00b0 degrees not supported.");
        }
        if (this.isOld()) {
            return this;
        }
        if (geoLocation.getLatitude() == this.location.getLatitude() && geoLocation.getLongitude() == this.location.getLongitude() && geoLocation.getAltitude() == this.location.getAltitude()) {
            return this;
        }
        return new HinduVariant(this.type, this.defaultEra, this.elapsedMode, this.depressionAngle, geoLocation);
    }

    boolean prefersRasiNames() {
        return this.type == HinduRule.MADRAS.ordinal() || this.type == HinduRule.MALAYALI.ordinal();
    }

    HinduCS getCalendarSystem() {
        switch (this.type) {
            case -1: {
                return AryaSiddhanta.SOLAR.getCalendarSystem();
            }
            case -2: {
                return AryaSiddhanta.LUNAR.getCalendarSystem();
            }
        }
        return new ModernHinduCS(this);
    }

    int getFirstMonthOfYear() {
        IndianMonth indianMonth;
        if (this.isOld()) {
            return 1;
        }
        switch (this.getRule()) {
            case AMANTA_ASHADHA: {
                indianMonth = IndianMonth.ASHADHA;
                break;
            }
            case AMANTA_KARTIKA: {
                indianMonth = IndianMonth.KARTIKA;
                break;
            }
            default: {
                indianMonth = IndianMonth.CHAITRA;
            }
        }
        return indianMonth.getValue();
    }

    HinduCS toAmanta() {
        return new HinduVariant(HinduRule.AMANTA.ordinal(), this.defaultEra, this.elapsedMode, this.depressionAngle, this.location).getCalendarSystem();
    }

    private boolean useModernAstronomy() {
        return !Double.isNaN(this.depressionAngle);
    }

    private static boolean useStandardElapsedMode(HinduEra hinduEra, HinduRule hinduRule) {
        switch (hinduEra) {
            case SAKA: {
                switch (hinduRule) {
                    case MADRAS: 
                    case MALAYALI: 
                    case TAMIL: {
                        return false;
                    }
                }
                return true;
            }
            case KOLLAM: {
                return false;
            }
        }
        return true;
    }

    private static boolean equals(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return Double.isNaN(d3);
        }
        if (Double.isNaN(d3)) {
            return false;
        }
        return d2 == d3;
    }

    private HinduRule getRule() {
        return RULES[this.type];
    }

    private Object writeReplace() {
        return new SPX(this, 21);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static class ModernHinduCS
    extends HinduCS {
        private static final int MIN_YEAR = 1200;
        private static final int MAX_YEAR = 5999;
        private static final boolean CC = false;
        static final double SIDEREAL_YEAR = 365.2587564814815;
        static final double SIDEREAL_START = 336.1360765905204;
        private static final double SIDEREAL_MONTH = 27.321674162683866;
        private static final double SYNODIC_MONTH = 29.53058794607172;
        private static final double EPSILON = Math.pow(2.0, -1000.0);
        private static final double CREATION = -7.14403429586E11;
        private static final double ANOMALISTIC_YEAR = 365.25878920258134;
        private static final double ANOMALISTIC_MONTH = 27.554597974680476;
        private static final double MEAN_SIDEREAL_YEAR = 365.25636;
        private static final double MEAN_SYNODIC_MONTH = 29.530588861;
        private static final double[] RISING_SIGN_FACTORS;
        private volatile long min = Long.MIN_VALUE;
        private volatile long max = Long.MAX_VALUE;

        ModernHinduCS(HinduVariant hinduVariant) {
            super(hinduVariant);
        }

        @Override
        HinduCalendar create(long l2) {
            HinduVariant hinduVariant = this.variant;
            switch (this.getRule()) {
                case MADRAS: 
                case MALAYALI: 
                case TAMIL: 
                case ORISSA: {
                    return ModernHinduCS.hSolarFromFixed(l2, hinduVariant);
                }
                case AMANTA: {
                    return ModernHinduCS.hLunarFromFixed(l2, hinduVariant);
                }
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    HinduCalendar hinduCalendar = hinduVariant.toAmanta().create(l2);
                    int n2 = hinduCalendar.getExpiredYearOfKaliYuga();
                    if (hinduCalendar.getMonth().getValue().getValue() < hinduVariant.getFirstMonthOfYear()) {
                        --n2;
                    }
                    return new HinduCalendar(hinduVariant, n2, hinduCalendar.getMonth(), hinduCalendar.getDayOfMonth(), l2);
                }
                case PURNIMANTA: {
                    HinduCS hinduCS = hinduVariant.toAmanta();
                    HinduCalendar hinduCalendar = hinduCS.create(l2);
                    HinduMonth hinduMonth = HinduMonth.ofLunisolar(hinduCalendar.getDayOfMonth().getValue() >= 16 ? hinduCS.create(l2 + 20L).getMonth().getValue().getValue() : hinduCalendar.getMonth().getValue().getValue());
                    if (hinduCalendar.getMonth().isLeap()) {
                        hinduMonth = hinduMonth.withLeap();
                    }
                    return new HinduCalendar(hinduVariant, hinduCalendar.getExpiredYearOfKaliYuga(), hinduMonth, hinduCalendar.getDayOfMonth(), l2);
                }
            }
            throw new UnsupportedOperationException(this.getRule().name());
        }

        @Override
        HinduCalendar create(int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
            long l2;
            HinduVariant hinduVariant = this.variant;
            switch (this.getRule()) {
                case MADRAS: 
                case MALAYALI: 
                case TAMIL: 
                case ORISSA: {
                    l2 = ModernHinduCS.hFixedFromSolar(n2, hinduMonth, hinduDay, hinduVariant);
                    break;
                }
                case AMANTA: {
                    l2 = ModernHinduCS.hFixedFromLunar(n2, hinduMonth, hinduDay, hinduVariant);
                    break;
                }
                case AMANTA_ASHADHA: 
                case AMANTA_KARTIKA: {
                    int n3 = n2;
                    if (hinduMonth.getValue().getValue() < hinduVariant.getFirstMonthOfYear()) {
                        ++n3;
                    }
                    HinduCalendar hinduCalendar = hinduVariant.toAmanta().create(n3, hinduMonth, hinduDay);
                    return new HinduCalendar(hinduVariant, n2, hinduMonth, hinduDay, hinduCalendar.getDaysSinceEpochUTC());
                }
                case PURNIMANTA: {
                    HinduMonth hinduMonth2 = hinduMonth.isLeap() || hinduDay.getValue() <= 15 ? hinduMonth : (this.variant.toAmanta().isExpunged(n2, ModernHinduCS.prevMonth(hinduMonth, 1)) ? ModernHinduCS.prevMonth(hinduMonth, 2) : ModernHinduCS.prevMonth(hinduMonth, 1));
                    l2 = ModernHinduCS.hFixedFromLunar(n2, hinduMonth2, hinduDay, hinduVariant);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.getRule().name());
                }
            }
            return new HinduCalendar(hinduVariant, n2, hinduMonth, hinduDay, l2);
        }

        @Override
        boolean isValid(int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
            if (n2 < 1200 || n2 > 5999 || hinduMonth == null || hinduDay == null) {
                return false;
            }
            if (this.variant.isSolar() && (hinduMonth.isLeap() || hinduDay.isLeap())) {
                return false;
            }
            if (this.variant.isLunisolar() && hinduDay.getValue() > 30) {
                return false;
            }
            HinduCS hinduCS = this;
            HinduRule hinduRule = this.getRule();
            if (hinduRule == HinduRule.AMANTA_ASHADHA || hinduRule == HinduRule.AMANTA_KARTIKA) {
                if (hinduMonth.getValue().getValue() < this.variant.getFirstMonthOfYear()) {
                    ++n2;
                }
                hinduCS = this.variant.toAmanta();
            }
            return !hinduCS.isExpunged(n2, hinduMonth, hinduDay);
        }

        @Override
        public long getMinimumSinceUTC() {
            if (this.min == Long.MIN_VALUE) {
                HinduCalendar hinduCalendar = this.variant.isPurnimanta() ? this.createNewYear(1201).withFirstDayOfMonth() : this.createNewYear(1200);
                this.min = hinduCalendar.getDaysSinceEpochUTC();
            }
            return this.min;
        }

        @Override
        public long getMaximumSinceUTC() {
            if (this.max == Long.MAX_VALUE) {
                HinduCalendar hinduCalendar = this.createNewYear(6000);
                if (this.variant.isPurnimanta()) {
                    hinduCalendar = hinduCalendar.withFirstDayOfMonth();
                }
                this.max = hinduCalendar.getDaysSinceEpochUTC() - 1L;
            }
            return this.max;
        }

        private HinduCalendar createNewYear(int n2) {
            return this.create(n2, HinduMonth.of(IndianMonth.AGRAHAYANA), HinduDay.valueOf(1)).withNewYear();
        }

        private HinduRule getRule() {
            return this.variant.getRule();
        }

        private static HinduMonth prevMonth(HinduMonth hinduMonth, int n2) {
            int n3 = hinduMonth.getValue().getValue() - n2;
            if (n3 <= 0) {
                n3 += 12;
            }
            return HinduMonth.ofLunisolar(n3);
        }

        private static double hSineTable(double d2) {
            double d3 = 3438.0 * Math.sin(Math.toRadians(d2 * 3.75));
            double d4 = 0.215 * Math.signum(d3) * Math.signum(Math.abs(d3) - 1716.0);
            return Math.floor(d3 + d4 + 0.5) / 3438.0;
        }

        private static double hSine(double d2) {
            double d3 = d2 / 3.75;
            double d4 = ModernHinduCS.modulo(d3, 1.0);
            return d4 * ModernHinduCS.hSineTable(Math.ceil(d3)) + (1.0 - d4) * ModernHinduCS.hSineTable(Math.floor(d3));
        }

        private static double hArcSin(double d2) {
            if (d2 < 0.0) {
                return -ModernHinduCS.hArcSin(-d2);
            }
            int n2 = 0;
            while (d2 > ModernHinduCS.hSineTable(n2)) {
                ++n2;
            }
            double d3 = ModernHinduCS.hSineTable(n2 - 1);
            return 3.75 * ((double)(n2 - 1) + (d2 - d3) / (ModernHinduCS.hSineTable(n2) - d3));
        }

        private static double hMeanPosition(double d2, double d3) {
            return 360.0 * ModernHinduCS.modulo((d2 - -7.14403429586E11) / d3, 1.0);
        }

        private static double hTruePosition(double d2, double d3, double d4, double d5, double d6) {
            double d7 = ModernHinduCS.hMeanPosition(d2, d3);
            double d8 = ModernHinduCS.hSine(ModernHinduCS.hMeanPosition(d2, d5));
            double d9 = Math.abs(d8) * d6 * d4;
            double d10 = ModernHinduCS.hArcSin(d8 * (d4 - d9));
            return ModernHinduCS.modulo(d7 - d10, 360.0);
        }

        private static double hSiderealSolarLongitude(double d2) {
            return ModernHinduCS.modulo(StdSolarCalculator.CC.getFeature(ModernHinduCS.toJDE(d2).getValue(), "solar-longitude") - ModernHinduCS.hPrecession(d2) + 336.1360765905204, 360.0);
        }

        static double hSolarLongitude(double d2) {
            return ModernHinduCS.hTruePosition(d2, 365.2587564814815, 0.03888888888888889, 365.25878920258134, 0.023809523809523808);
        }

        static double hPrecession(double d2) {
            double d3 = ModernHinduCS.toJDE(d2).getCenturyJ2000();
            int n2 = -1;
            double d4 = ModernHinduCS.modulo((0.01305636111111111 + (-9.172222222222223E-6 + 1.6666666666666667E-8 * d3) * d3) * d3, 360.0);
            double d5 = ModernHinduCS.modulo(174.876384 + (-0.24161358333333333 + 9.822222222222223E-6 * d3) * d3, 360.0);
            double d6 = ModernHinduCS.modulo((1.3969712777777776 + (3.0864722222222223E-4 + (double)n2 * 6.0E-6 / 3600.0 * d3) * d3) * d3, 360.0);
            double d7 = Math.cos(Math.toRadians(d4)) * Math.sin(Math.toRadians(d5));
            double d8 = Math.cos(Math.toRadians(d5));
            double d9 = Math.toDegrees(Math.atan2(d7, d8));
            return ModernHinduCS.modulo(d6 + d5 - d9, 360.0);
        }

        private static JulianDay toJDE(double d2) {
            long l2 = Math.round((d2 + 1721424.0 - 2440587.0) * 86400.0);
            return JulianDay.ofEphemerisTime(Moment.of(l2, TimeScale.POSIX));
        }

        private static double toRataDie(Moment moment) {
            return (double)moment.getPosixTime() / 86400.0 + 2440587.0 - 1721424.0;
        }

        private static int hZodiac(double d2) {
            return (int)(Math.floor(ModernHinduCS.hSolarLongitude(d2) / 30.0) + 1.0);
        }

        private static int hSiderealZodiac(double d2) {
            return (int)(Math.floor(ModernHinduCS.hSiderealSolarLongitude(d2) / 30.0) + 1.0);
        }

        private static double hLunarLongitude(double d2) {
            return ModernHinduCS.hTruePosition(d2, 27.321674162683866, 0.08888888888888889, 27.554597974680476, 0.010416666666666666);
        }

        private static double hLunarPhase(double d2) {
            return ModernHinduCS.modulo(ModernHinduCS.hLunarLongitude(d2) - ModernHinduCS.hSolarLongitude(d2), 360.0);
        }

        private static int hLunarDayFromMoment(double d2, HinduVariant hinduVariant) {
            double d3;
            if (hinduVariant.useModernAstronomy()) {
                int n2;
                double d4;
                double d5 = ModernHinduCS.toJDE(d2).getValue();
                double d6 = StdSolarCalculator.CC.getFeature(d5, "solar-longitude");
                double d7 = StdSolarCalculator.CC.getFeature(d5, "lunar-longitude");
                double d8 = ModernHinduCS.modulo(d7 - d6, 360.0);
                d3 = Math.abs(d8 - (d4 = 360.0 * ModernHinduCS.modulo((d2 - ModernHinduCS.nthNewMoon(n2 = (int)Math.round((d2 - ModernHinduCS.nthNewMoon(0)) / 29.530588861))) / 29.530588861, 1.0))) > 180.0 ? d4 : d8;
            } else {
                d3 = ModernHinduCS.hLunarPhase(d2);
            }
            return (int)(Math.floor(d3 / 12.0) + 1.0);
        }

        private static double nthNewMoon(int n2) {
            return ModernHinduCS.toRataDie(MoonPhase.NEW_MOON.atLunation(n2 - 24724));
        }

        private static double hNewMoonBefore(double d2) {
            double d3 = d2 - ModernHinduCS.hLunarPhase(d2) * 29.53058794607172 / 360.0;
            return ModernHinduCS.binarySearchLunarPhase(d3 - 1.0, Math.min(d2, d3 + 1.0));
        }

        private static double binarySearchLunarPhase(double d2, double d3) {
            double d4 = (d2 + d3) / 2.0;
            if (ModernHinduCS.hZodiac(d2) == ModernHinduCS.hZodiac(d3) || d3 - d2 < EPSILON) {
                return d4;
            }
            if (ModernHinduCS.hLunarPhase((d2 + d3) / 2.0) < 180.0) {
                return ModernHinduCS.binarySearchLunarPhase(d2, d4);
            }
            return ModernHinduCS.binarySearchLunarPhase(d4, d3);
        }

        private static int hCalendarYear(double d2, HinduVariant hinduVariant) {
            if (hinduVariant.useModernAstronomy()) {
                return (int)Math.floor(0.5 + (d2 - -1132959.0) / 365.25636 - ModernHinduCS.hSiderealSolarLongitude(d2) / 360.0);
            }
            return (int)Math.floor(0.5 + (d2 - -1132959.0) / 365.2587564814815 - ModernHinduCS.hSolarLongitude(d2) / 360.0);
        }

        private static HinduCalendar hSolarFromFixed(long l2, HinduVariant hinduVariant) {
            long l3;
            int n2;
            assert (hinduVariant.isSolar());
            LongFunction<Double> longFunction = ModernHinduCS.hCritical(hinduVariant);
            long l4 = EpochDays.RATA_DIE.transform(l2, EpochDays.UTC);
            double d2 = longFunction.apply(l4);
            int n3 = ModernHinduCS.hCalendarYear(d2, hinduVariant);
            if (hinduVariant.useModernAstronomy()) {
                n2 = ModernHinduCS.hSiderealZodiac(d2);
                l3 = l4 - 3L - (long)((int)ModernHinduCS.modulo(Math.floor(ModernHinduCS.hSiderealSolarLongitude(d2)), 30.0));
                while (ModernHinduCS.hSiderealZodiac(longFunction.apply(l3)) != n2) {
                    ++l3;
                }
            } else {
                n2 = ModernHinduCS.hZodiac(d2);
                l3 = l4 - 3L - (long)((int)ModernHinduCS.modulo(Math.floor(ModernHinduCS.hSolarLongitude(d2)), 30.0));
                while (ModernHinduCS.hZodiac(longFunction.apply(l3)) != n2) {
                    ++l3;
                }
            }
            return new HinduCalendar(hinduVariant, n3, HinduMonth.ofSolar(n2), HinduDay.valueOf((int)(l4 - l3 + 1L)), l2);
        }

        private static long hFixedFromSolar(int n2, HinduMonth hinduMonth, HinduDay hinduDay, HinduVariant hinduVariant) {
            assert (hinduVariant.isSolar());
            int n3 = hinduMonth.getRasi();
            LongFunction<Double> longFunction = ModernHinduCS.hCritical(hinduVariant);
            double d2 = hinduVariant.useModernAstronomy() ? 365.25636 : 365.2587564814815;
            long l2 = -1132962L + (long)Math.floor(d2 * ((double)n2 + (double)(n3 - 1) / 12.0));
            if (hinduVariant.useModernAstronomy()) {
                while (ModernHinduCS.hSiderealZodiac(longFunction.apply(l2)) != n3) {
                    ++l2;
                }
            } else {
                while (ModernHinduCS.hZodiac(longFunction.apply(l2)) != n3) {
                    ++l2;
                }
            }
            return EpochDays.UTC.transform((long)(hinduDay.getValue() - 1) + l2, EpochDays.RATA_DIE);
        }

        private static LongFunction<Double> hCritical(HinduVariant hinduVariant) {
            switch (hinduVariant.getRule()) {
                case ORISSA: {
                    return l2 -> ModernHinduCS.hSunrise(l2 + 1L, hinduVariant);
                }
                case TAMIL: {
                    return l2 -> ModernHinduCS.hSunset(l2, hinduVariant);
                }
                case MALAYALI: {
                    return l2 -> ModernHinduCS.hStandardFromSundial((double)l2 + 0.55, hinduVariant);
                }
                case MADRAS: {
                    return l2 -> ModernHinduCS.hStandardFromSundial(l2 + 1L, hinduVariant);
                }
            }
            throw new UnsupportedOperationException("Not yet implemented.");
        }

        private static HinduCalendar hLunarFromFixed(long l2, HinduVariant hinduVariant) {
            int n2;
            int n3;
            assert (hinduVariant.isLunisolar());
            long l3 = EpochDays.RATA_DIE.transform(l2, EpochDays.UTC);
            double d2 = ModernHinduCS.hSunrise(l3, hinduVariant);
            int n4 = ModernHinduCS.hLunarDayFromMoment(d2, hinduVariant);
            HinduDay hinduDay = HinduDay.valueOf(n4);
            if (ModernHinduCS.hLunarDayFromMoment(ModernHinduCS.hSunrise(l3 - 1L, hinduVariant), hinduVariant) == n4) {
                hinduDay = hinduDay.withLeap();
            }
            if (hinduVariant.useModernAstronomy()) {
                Moment moment = ModernHinduCS.toJDE(d2).toMoment();
                double d3 = ModernHinduCS.toRataDie(MoonPhase.NEW_MOON.before(moment));
                double d4 = ModernHinduCS.toRataDie(MoonPhase.NEW_MOON.atOrAfter(moment));
                n3 = ModernHinduCS.hSiderealZodiac(d3);
                n2 = ModernHinduCS.hSiderealZodiac(d4);
            } else {
                double d5 = ModernHinduCS.hNewMoonBefore(d2);
                double d6 = ModernHinduCS.hNewMoonBefore(Math.floor(d5) + 35.0);
                n3 = ModernHinduCS.hZodiac(d5);
                n2 = ModernHinduCS.hZodiac(d6);
            }
            int n5 = n3 == 12 ? 1 : n3 + 1;
            HinduMonth hinduMonth = HinduMonth.ofLunisolar(n5);
            if (n2 == n3) {
                hinduMonth = hinduMonth.withLeap();
            }
            int n6 = ModernHinduCS.hCalendarYear(n5 <= 2 ? (double)l3 + 180.0 : (double)l3, hinduVariant);
            return new HinduCalendar(hinduVariant, n6, hinduMonth, hinduDay, l2);
        }

        private static long hFixedFromLunar(int n2, HinduMonth hinduMonth, HinduDay hinduDay, HinduVariant hinduVariant) {
            HinduCalendar hinduCalendar;
            double d2;
            double d3;
            assert (hinduVariant.isLunisolar());
            int n3 = hinduMonth.getValue().getValue();
            if (hinduVariant.useModernAstronomy()) {
                d3 = -1132959.0 + 365.25636 * ((double)n2 + (double)(n3 - 1) / 12.0);
                d2 = ModernHinduCS.hSiderealSolarLongitude(d3);
            } else {
                d3 = -1132959.0 + 365.2587564814815 * ((double)n2 + (double)(n3 - 1) / 12.0);
                d2 = ModernHinduCS.hSolarLongitude(d3);
            }
            d2 = d2 / 360.0 - (double)(n3 - 1) / 12.0;
            long l2 = (long)Math.floor(d3 - 365.2587564814815 * (-0.5 + ModernHinduCS.modulo(d2 + 0.5, 1.0)));
            int n4 = ModernHinduCS.hLunarDayFromMoment((double)l2 + 0.25, hinduVariant);
            int n5 = hinduDay.getValue();
            int n6 = n4 > 3 && n4 < 27 ? n4 : ((hinduCalendar = ModernHinduCS.hLunarFromFixed(EpochDays.UTC.transform(l2 - 15L, EpochDays.RATA_DIE), hinduVariant)).getMonth().getValue() != hinduMonth.getValue() || hinduCalendar.getMonth().isLeap() && !hinduMonth.isLeap() ? -15 + (int)ModernHinduCS.modulo(n4 + 15, 30.0) : 15 + (int)ModernHinduCS.modulo(n4 - 15, 30.0));
            long l3 = l2 + (long)n5 - (long)n6;
            long l4 = l3 + 14L - (long)((int)ModernHinduCS.modulo(ModernHinduCS.hLunarDayFromMoment((double)l3 + 0.25, hinduVariant) - n5 + 15, 30.0));
            while (true) {
                int n7;
                int n8 = ModernHinduCS.hLunarDayFromMoment(ModernHinduCS.hSunrise(l4, hinduVariant), hinduVariant);
                int n9 = (int)ModernHinduCS.modulo(n5 + 1, 30.0);
                int n10 = n7 = n9 == 0 ? 30 : n9;
                if (n8 == n5 || n8 == n7) break;
                ++l4;
            }
            if (hinduDay.isLeap()) {
                ++l4;
            }
            return EpochDays.UTC.transform(l4, EpochDays.RATA_DIE);
        }

        private static double hAscensionalDifference(double d2, GeoLocation geoLocation) {
            double d3 = 0.4063408958696917 * ModernHinduCS.hSine(ModernHinduCS.hTropicalLongitude(d2));
            double d4 = geoLocation.getLatitude();
            double d5 = ModernHinduCS.hSine(90.0 + ModernHinduCS.hArcSin(d3));
            double d6 = d3 * (ModernHinduCS.hSine(d4) / ModernHinduCS.hSine(90.0 + d4));
            return ModernHinduCS.hArcSin(-1.0 * d6 / d5);
        }

        private static double hSolarSiderealDifference(double d2) {
            return ModernHinduCS.hDailyMotion(d2) * ModernHinduCS.hRisingSign(d2);
        }

        private static double hEquationOfTime(double d2) {
            double d3 = ModernHinduCS.hSine(ModernHinduCS.hMeanPosition(d2, 365.25878920258134));
            double d4 = d3 * 57.3 * (0.03888888888888889 - Math.abs(d3) / 1080.0);
            return ModernHinduCS.hDailyMotion(d2) / 360.0 * (d4 / 360.0) * 365.2587564814815;
        }

        private static double hTropicalLongitude(double d2) {
            double d3 = 3.80247937727211E-7 * (d2 - -1132959.0) - 0.25;
            double d4 = 27.0 - Math.abs(108.0 * (-0.5 + ModernHinduCS.modulo(d3 + 0.5, 1.0)));
            return ModernHinduCS.modulo(ModernHinduCS.hSolarLongitude(d2) - d4, 360.0);
        }

        private static double hDailyMotion(double d2) {
            double d3 = ModernHinduCS.hMeanPosition(d2, 365.25878920258134);
            double d4 = 0.03888888888888889 - 9.25925925925926E-4 * Math.abs(ModernHinduCS.hSine(d3));
            double d5 = Math.floor(d3 / 3.75);
            double d6 = ModernHinduCS.hSineTable(d5 + 1.0) - ModernHinduCS.hSineTable(d5);
            double d7 = 1.0 - 15.28 * d6 * d4;
            return 0.9856026545889308 * d7;
        }

        private static double hRisingSign(double d2) {
            int n2 = (int)Math.floor(ModernHinduCS.hTropicalLongitude(d2) / 30.0);
            return RISING_SIGN_FACTORS[(int)ModernHinduCS.modulo(n2, 6.0)];
        }

        private static double hSunrise(double d2, HinduVariant hinduVariant) {
            if (hinduVariant.useModernAstronomy()) {
                GeoLocation geoLocation = hinduVariant.getLocation();
                PlainDate plainDate = PlainDate.of((long)Math.floor(d2), EpochDays.RATA_DIE);
                Moment moment = StdSolarCalculator.CC.sunrise(plainDate, geoLocation.getLatitude(), geoLocation.getLongitude(), 90.0 + hinduVariant.depressionAngle).get();
                double d3 = ((double)moment.getPosixTime() + 18184.4) / 86400.0;
                long l2 = EpochDays.RATA_DIE.transform((long)Math.floor(d3), EpochDays.UNIX);
                return (double)l2 + d3 - Math.floor(d3);
            }
            double d4 = d2 + 0.25 + (UJJAIN.getLongitude() - hinduVariant.getLocation().getLongitude()) / 360.0;
            double d5 = ModernHinduCS.hAscensionalDifference(d2, hinduVariant.getLocation());
            double d6 = 0.25 * ModernHinduCS.hSolarSiderealDifference(d2) + d5;
            return d4 - ModernHinduCS.hEquationOfTime(d2) + 0.002770193582919304 * d6;
        }

        private static double hSunset(double d2, HinduVariant hinduVariant) {
            if (hinduVariant.useModernAstronomy()) {
                GeoLocation geoLocation = hinduVariant.getLocation();
                PlainDate plainDate = PlainDate.of((long)Math.floor(d2), EpochDays.RATA_DIE);
                Moment moment = StdSolarCalculator.CC.sunset(plainDate, geoLocation.getLatitude(), geoLocation.getLongitude(), 90.0 + hinduVariant.depressionAngle).get();
                double d3 = ((double)moment.getPosixTime() + 18184.4) / 86400.0;
                long l2 = EpochDays.RATA_DIE.transform((long)Math.floor(d3), EpochDays.UNIX);
                return (double)l2 + d3 - Math.floor(d3);
            }
            double d4 = d2 + 0.75 + (UJJAIN.getLongitude() - hinduVariant.getLocation().getLongitude()) / 360.0;
            double d5 = ModernHinduCS.hAscensionalDifference(d2, hinduVariant.getLocation());
            double d6 = 0.75 * ModernHinduCS.hSolarSiderealDifference(d2) - d5;
            return d4 - ModernHinduCS.hEquationOfTime(d2) + 0.002770193582919304 * d6;
        }

        private static double hStandardFromSundial(double d2, HinduVariant hinduVariant) {
            double d3;
            double d4;
            double d5;
            double d6 = Math.floor(d2);
            double d7 = d2 - d6;
            int n2 = (int)Math.floor(4.0 * d7);
            if (n2 == 0) {
                d5 = ModernHinduCS.hSunset(d6 - 1.0, hinduVariant);
                d4 = ModernHinduCS.hSunrise(d6, hinduVariant);
                d3 = -0.25;
            } else if (n2 == 3) {
                d5 = ModernHinduCS.hSunset(d6, hinduVariant);
                d4 = ModernHinduCS.hSunrise(d6 + 1.0, hinduVariant);
                d3 = 0.75;
            } else {
                d5 = ModernHinduCS.hSunrise(d6, hinduVariant);
                d4 = ModernHinduCS.hSunset(d6, hinduVariant);
                d3 = 0.25;
            }
            return d5 + 2.0 * (d4 - d5) * (d7 - d3);
        }

        static {
            double[] dArray = new double[]{0.9277777777777778, 0.9972222222222222, 1.075, 1.075, 0.9972222222222222, 0.9277777777777778};
            RISING_SIGN_FACTORS = dArray;
        }
    }
}

