/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.IndianCalendar;
import net.time4j.calendar.IndianMonth;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.hindu.AdjustableTextElement;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduPrimitive;
import net.time4j.calendar.hindu.HinduRule;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.calendar.hindu.SPX;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.ValidationElement;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayElement;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="hindu")
public final class HinduCalendar
extends CalendarVariant<HinduCalendar>
implements LocalizedPatternSupport {
    private static final int MIN_YEAR = 1200;
    private static final int MAX_YEAR = 5999;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_YEAR_INDEX = 1;
    @FormattableElement(format="G")
    public static final ChronoElement<HinduEra> ERA = new StdEnumDateElement<HinduEra, HinduCalendar>("ERA", HinduCalendar.class, HinduEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, HinduCalendar> YEAR_OF_ERA = new StdIntegerDateElement<HinduCalendar>("YEAR_OF_ERA", HinduCalendar.class, 0, 6000, 'y');
    @FormattableElement(format="M")
    public static final AdjustableTextElement<HinduMonth> MONTH_OF_YEAR = MonthElement.SINGLETON;
    @FormattableElement(format="d")
    public static final AdjustableTextElement<HinduDay> DAY_OF_MONTH = DayOfMonthElement.SINGLETON;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, HinduCalendar> DAY_OF_YEAR = new StdIntegerDateElement<HinduCalendar>("DAY_OF_YEAR", HinduCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, HinduCalendar> DAY_OF_WEEK = new StdWeekdayElement<HinduCalendar>(HinduCalendar.class, IndianCalendar.getDefaultWeekmodel());
    private static final Map<String, HinduCS> CALSYS;
    private static final CalendarFamily<HinduCalendar> ENGINE;
    private static final long serialVersionUID = 4078031838043675524L;
    private final transient HinduVariant variant;
    private final transient int kyYear;
    private final transient HinduMonth month;
    private final transient HinduDay dayOfMonth;
    private final transient long utcDays;

    HinduCalendar(HinduVariant hinduVariant, int n2, HinduMonth hinduMonth, HinduDay hinduDay, long l2) {
        if (hinduVariant == null) {
            throw new NullPointerException("Missing variant.");
        }
        if (hinduMonth == null) {
            throw new NullPointerException("Missing month.");
        }
        if (hinduDay == null) {
            throw new NullPointerException("Missing day of month.");
        }
        this.variant = hinduVariant;
        this.kyYear = n2;
        this.month = hinduMonth;
        this.dayOfMonth = hinduDay;
        this.utcDays = l2;
    }

    public static HinduCalendar nowInSystemTime(HinduVariant hinduVariant) {
        StartOfDay startOfDay = HinduCalendar.family().getDefaultStartOfDay();
        return HinduCalendar.nowInSystemTime(hinduVariant, startOfDay);
    }

    public static HinduCalendar nowInSystemTime(HinduVariant hinduVariant, StartOfDay startOfDay) {
        return SystemClock.inLocalView().now(HinduCalendar.family(), hinduVariant, startOfDay).toDate();
    }

    public static HinduCalendar ofOldSolar(int n2, int n3, int n4) {
        if (n4 > 31) {
            throw new IllegalArgumentException("Day-of-month out of range: " + n4);
        }
        HinduMonth hinduMonth = HinduMonth.ofSolar(n3);
        HinduDay hinduDay = HinduDay.valueOf(n4);
        return HinduCalendar.of(HinduVariant.VAR_OLD_SOLAR, HinduEra.KALI_YUGA, n2, hinduMonth, hinduDay);
    }

    public static HinduCalendar ofOldLunar(int n2, HinduMonth hinduMonth, int n3) {
        if (n3 > 30) {
            throw new IllegalArgumentException("Day-of-month out of range: " + n3);
        }
        HinduDay hinduDay = HinduDay.valueOf(n3);
        return HinduCalendar.of(HinduVariant.VAR_OLD_LUNAR, HinduEra.KALI_YUGA, n2, hinduMonth, hinduDay);
    }

    public static HinduCalendar of(HinduVariant hinduVariant, HinduEra hinduEra, int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
        HinduCS hinduCS = hinduVariant.with(hinduEra).getCalendarSystem();
        int n3 = HinduEra.KALI_YUGA.yearOfEra(hinduEra, n2);
        if (!hinduVariant.isUsingElapsedYears()) {
            --n3;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Kali yuga year must not be smaller than 0: " + n3);
        }
        if (!hinduVariant.isOld() && n3 < 1200) {
            throw new IllegalArgumentException("Year out of range in modern Hindu calendar: " + n3);
        }
        if (hinduCS.isValid(n3, hinduMonth, hinduDay)) {
            return hinduCS.create(n3, hinduMonth, hinduDay);
        }
        throw new IllegalArgumentException("Invalid values: " + hinduVariant + "[" + hinduEra + "/" + n2 + "/" + hinduMonth + "/" + hinduDay + "]");
    }

    public static boolean isValid(HinduVariant hinduVariant, HinduEra hinduEra, int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
        HinduCS hinduCS = hinduVariant.with(hinduEra).getCalendarSystem();
        int n3 = HinduEra.KALI_YUGA.yearOfEra(hinduEra, n2);
        if (!hinduVariant.isUsingElapsedYears()) {
            --n3;
        }
        if (n3 < 0 || !hinduVariant.isOld() && n3 < 1200) {
            return false;
        }
        return hinduCS.isValid(n3, hinduMonth, hinduDay);
    }

    public int lengthOfMonth() {
        HinduCalendar hinduCalendar = this.withFirstDayOfMonth();
        HinduCalendar hinduCalendar2 = this.withMidOfMonth(1).withFirstDayOfMonth();
        return (int)(hinduCalendar2.utcDays - hinduCalendar.utcDays);
    }

    public int lengthOfYear() {
        return (Integer)this.getMaximum(DAY_OF_YEAR);
    }

    @Override
    public String getVariant() {
        return this.variant.getVariant();
    }

    public HinduEra getEra() {
        HinduEra hinduEra = this.variant.getDefaultEra();
        if (hinduEra.yearOfEra(HinduEra.KALI_YUGA, this.kyYear) < 0) {
            hinduEra = HinduEra.KALI_YUGA;
        }
        return hinduEra;
    }

    public int getYear() {
        int n2 = this.getEra().yearOfEra(HinduEra.KALI_YUGA, this.kyYear);
        if (!this.variant.isUsingElapsedYears()) {
            ++n2;
        }
        return n2;
    }

    public HinduMonth getMonth() {
        return this.month;
    }

    public HinduDay getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        return Weekday.valueOf(MathUtils.floorModulo(this.utcDays + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (int)(this.utcDays - this.withNewYear().utcDays + 1L);
    }

    public HinduCalendar previousDay() {
        return this.getCalendarSystem().transform(this.utcDays - 1L);
    }

    public HinduCalendar previousMonth() {
        HinduCalendar hinduCalendar = this.withMidOfMonth(-1).withAdjustedDayInMonth(this.dayOfMonth);
        if (hinduCalendar.utcDays < this.variant.getCalendarSystem().getMinimumSinceUTC()) {
            throw new IllegalArgumentException("Hindu date out of range");
        }
        return hinduCalendar;
    }

    public HinduCalendar previousYear() {
        return this.withYearChangedBy(-1);
    }

    public HinduCalendar nextDay() {
        return this.getCalendarSystem().transform(this.utcDays + 1L);
    }

    public HinduCalendar nextMonth() {
        HinduCalendar hinduCalendar = this.withMidOfMonth(1).withAdjustedDayInMonth(this.dayOfMonth);
        if (hinduCalendar.utcDays > this.variant.getCalendarSystem().getMaximumSinceUTC()) {
            throw new IllegalArgumentException("Hindu date out of range");
        }
        return hinduCalendar;
    }

    public HinduCalendar nextYear() {
        return this.withYearChangedBy(1);
    }

    public GeneralTimestamp<HinduCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<HinduCalendar> atTime(int n2, int n3) {
        return this.at(PlainTime.of(n2, n3));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduCalendar) {
            HinduCalendar hinduCalendar = (HinduCalendar)object;
            return this.variant.equals(hinduCalendar.variant) && this.kyYear == hinduCalendar.kyYear && this.month.equals(hinduCalendar.month) && this.dayOfMonth.equals(hinduCalendar.dayOfMonth) && this.utcDays == hinduCalendar.utcDays;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 7 * this.variant.hashCode() + 17 * this.kyYear + 31 * this.month.hashCode() + 37 * this.dayOfMonth.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.variant);
        stringBuilder.append(",era=");
        stringBuilder.append(this.getEra());
        stringBuilder.append(",year-of-era=");
        stringBuilder.append(this.getYear());
        stringBuilder.append(",month=");
        stringBuilder.append(this.month);
        stringBuilder.append(",day-of-month=");
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public long getDaysSinceEpochUTC() {
        return this.utcDays;
    }

    public static CalendarFamily<HinduCalendar> family() {
        return ENGINE;
    }

    @Override
    protected CalendarFamily<HinduCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected HinduCalendar getContext() {
        return this;
    }

    @Override
    protected CalendarSystem<HinduCalendar> getCalendarSystem() {
        return this.variant.getCalendarSystem();
    }

    int getExpiredYearOfKaliYuga() {
        return this.kyYear;
    }

    HinduCalendar withNewYear() {
        HinduCalendar hinduCalendar;
        if (this.variant.isPurnimanta()) {
            HinduCalendar hinduCalendar2 = this.variant.toAmanta().create(this.kyYear, HinduMonth.ofLunisolar(1), HinduDay.valueOf(15)).withNewYear();
            return this.variant.getCalendarSystem().create(hinduCalendar2.getDaysSinceEpochUTC());
        }
        HinduMonth hinduMonth = this.variant.isSolar() ? HinduMonth.ofSolar(1) : HinduMonth.ofLunisolar(this.variant.getFirstMonthOfYear());
        HinduCS hinduCS = this.variant.getCalendarSystem();
        HinduCalendar hinduCalendar3 = hinduCS.create(this.kyYear, hinduMonth, HinduDay.valueOf(15));
        if (this.variant.isLunisolar() && (hinduCalendar = hinduCS.create(hinduCalendar3.utcDays - 30L)).getMonth().isLeap() && hinduCalendar.kyYear == this.kyYear) {
            hinduCalendar3 = hinduCalendar;
        }
        return hinduCalendar3.withFirstDayOfMonth();
    }

    HinduCalendar withFirstDayOfMonth() {
        HinduDay hinduDay = HinduDay.valueOf(1);
        HinduCS hinduCS = this.variant.getCalendarSystem();
        int n2 = this.kyYear;
        if (this.variant.isLunisolar()) {
            int n3 = 3;
            if (this.variant.isPurnimanta()) {
                hinduDay = HinduDay.valueOf(16);
                if (this.isChaitra() && this.dayOfMonth.getValue() < 16) {
                    HinduCalendar hinduCalendar = this.withNewYear();
                    if (this.month.equals(hinduCalendar.month)) {
                        --n2;
                    }
                }
            }
            while (hinduCS.isExpunged(n2, this.month, hinduDay)) {
                if (n3 == 0) {
                    throw new IllegalArgumentException("Cannot determine first day of month: " + this);
                }
                hinduDay = hinduDay.isLeap() ? HinduDay.valueOf(hinduDay.getValue() + 1) : hinduDay.withLeap();
                --n3;
            }
        }
        return hinduCS.create(n2, this.month, hinduDay);
    }

    private HinduCalendar withMidOfMonth(int n2) {
        int n3 = this.dayOfMonth.getValue();
        if (this.variant.isPurnimanta()) {
            n3 = n3 >= 16 ? (n3 -= 15) : (n3 += 15);
        }
        long l2 = this.utcDays + Math.round((double)n2 * (this.variant.isSolar() ? 30.4 : 29.5)) + 15L - (long)n3;
        return this.variant.getCalendarSystem().create(l2);
    }

    private HinduCalendar withYearChangedBy(int n2) {
        return (HinduCalendar)this.with((ChronoElement<Integer>)YEAR_OF_ERA, this.getYear() + n2);
    }

    private HinduCalendar withAdjustedDayInMonth(HinduDay hinduDay) {
        int n2;
        boolean bl2;
        HinduDay hinduDay2 = hinduDay;
        HinduCS hinduCS = this.variant.getCalendarSystem();
        int n3 = 5;
        boolean bl3 = this.variant.isPurnimanta();
        boolean bl4 = bl2 = bl3 && this.isChaitra() && this.withNewYear().month.equals(this.month);
        while (hinduCS.isExpunged(n2 = this.criticalYear(bl2, hinduDay2), this.month, hinduDay2)) {
            if (hinduDay2.getValue() == (bl3 ? 16 : 1) && !hinduDay2.isLeap()) {
                return this.withFirstDayOfMonth();
            }
            if (n3 == 0) {
                if (hinduCS.isExpunged(n2, this.month)) {
                    throw new IllegalArgumentException("Kshaia (lost) month is never valid: kali-yuga-year=" + n2 + ", month=" + this.month);
                }
                throw new IllegalArgumentException("No valid day found for: " + this + " => (desired day=" + hinduDay + ")");
            }
            if (hinduDay2.isLeap()) {
                hinduDay2 = HinduDay.valueOf(hinduDay2.getValue());
            } else {
                int n4 = hinduDay2.getValue() - 1;
                if (bl3 && n4 == 0) {
                    n4 = 30;
                }
                hinduDay2 = HinduDay.valueOf(n4);
                if (this.variant.isLunisolar()) {
                    hinduDay2 = hinduDay2.withLeap();
                }
            }
            --n3;
        }
        return hinduCS.create(n2, this.month, hinduDay2);
    }

    private int criticalYear(boolean bl2, HinduDay hinduDay) {
        if (bl2) {
            if (this.dayOfMonth.getValue() >= 16 && hinduDay.getValue() < 16) {
                return this.kyYear + 1;
            }
            if (this.dayOfMonth.getValue() < 16 && hinduDay.getValue() >= 16) {
                return this.kyYear - 1;
            }
        }
        return this.kyYear;
    }

    private boolean isChaitra() {
        return this.month.getValue().equals(IndianMonth.CHAITRA);
    }

    private static int parseLeadingLeapInfo(CharSequence charSequence, int n2, int n3, boolean bl2, String string, char c2, Locale locale) {
        boolean bl3 = false;
        int n4 = n2;
        int n5 = n4 + string.length();
        if (n5 < n3) {
            String string2 = string;
            String string3 = charSequence.subSequence(n4, n5).toString();
            if (bl2) {
                string2 = string2.toUpperCase(locale);
                string3 = string3.toUpperCase(locale);
            }
            if (string2.equals(string3)) {
                bl3 = true;
                n4 = n5;
                if (n4 < n3 && charSequence.charAt(n4) == ' ') {
                    ++n4;
                }
            }
        }
        if (!bl3) {
            return HinduCalendar.parseLeapIndicator(charSequence, n2, bl2, c2);
        }
        return n4;
    }

    private static int parseTrailingLeapInfo(CharSequence charSequence, int n2, int n3, boolean bl2, String string, char c2, Locale locale) {
        boolean bl3 = false;
        int n4 = n2;
        int n5 = n4 + string.length();
        if (n5 < n3 && charSequence.charAt(n4) == ' ') {
            ++n4;
            ++n5;
        }
        if (n5 < n3) {
            String string2 = string;
            String string3 = charSequence.subSequence(n4, n5).toString();
            if (bl2) {
                string2 = string2.toUpperCase(locale);
                string3 = string3.toUpperCase(locale);
            }
            if (string2.equals(string3)) {
                bl3 = true;
                n4 = n5;
            }
        }
        if (!bl3) {
            return HinduCalendar.parseLeapIndicator(charSequence, n2, bl2, c2);
        }
        return n4;
    }

    private static int parseLeapIndicator(CharSequence charSequence, int n2, boolean bl2, char c2) {
        char c3 = charSequence.charAt(n2);
        char c4 = c2;
        if (bl2) {
            c3 = Character.toUpperCase(c3);
            c4 = Character.toUpperCase(c4);
        }
        return c3 == c4 ? n2 + 1 : -1;
    }

    private static HinduVariant getVariant(ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        if (chronoDisplay instanceof VariantSource) {
            return HinduVariant.from(((VariantSource)((Object)chronoDisplay)).getVariant());
        }
        if (attributeQuery.contains(Attributes.CALENDAR_VARIANT)) {
            return HinduVariant.from(attributeQuery.get(Attributes.CALENDAR_VARIANT));
        }
        String string = chronoDisplay == null ? "<attributes>" : chronoDisplay.toString();
        throw new IllegalArgumentException("Cannot infer Hindu calendar variant: " + string);
    }

    private Object writeReplace() {
        return new SPX(this, 20);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        VariantMap variantMap = new VariantMap();
        for (HinduRule hinduRule : HinduRule.values()) {
            variantMap.accept(hinduRule.variant());
        }
        variantMap.accept(HinduVariant.VAR_OLD_SOLAR);
        variantMap.accept(HinduVariant.VAR_OLD_LUNAR);
        CALSYS = variantMap;
        Chronology.Builder builder = ((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)CalendarFamily.Builder.setUp(HinduCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, (ElementRule)new RelatedGregorianYearRule(CALSYS, DAY_OF_YEAR))).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement((ChronoElement)YEAR_OF_ERA, (ElementRule)new IntegerRule(0))).appendElement((ChronoElement)MONTH_OF_YEAR, (ElementRule)MonthElement.SINGLETON)).appendElement((ChronoElement)DAY_OF_MONTH, (ElementRule)DayOfMonthElement.SINGLETON)).appendElement((ChronoElement)DAY_OF_YEAR, (ElementRule)new IntegerRule(1))).appendElement((ChronoElement)DAY_OF_WEEK, new WeekdayRule<HinduCalendar>(IndianCalendar.getDefaultWeekmodel(), HinduCalendar::getCalendarSystem));
        ENGINE = ((CalendarFamily.Builder)builder).build();
    }

    private static class MonthElement
    extends DisplayElement<HinduMonth>
    implements AdjustableTextElement<HinduMonth>,
    ElementRule<HinduCalendar, HinduMonth> {
        static final MonthElement SINGLETON = new MonthElement();
        private static final long serialVersionUID = 7462717336727909653L;

        private MonthElement() {
            super("MONTH_OF_YEAR");
        }

        @Override
        public HinduMonth getValue(HinduCalendar hinduCalendar) {
            return hinduCalendar.month;
        }

        @Override
        public HinduMonth getMinimum(HinduCalendar hinduCalendar) {
            return hinduCalendar.withNewYear().month;
        }

        @Override
        public HinduMonth getMaximum(HinduCalendar hinduCalendar) {
            if (hinduCalendar.variant.isSolar()) {
                return HinduMonth.ofSolar(12);
            }
            HinduCalendar hinduCalendar2 = hinduCalendar.variant.getCalendarSystem().create(hinduCalendar.withNewYear().utcDays - 20L);
            return hinduCalendar2.month;
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, HinduMonth hinduMonth) {
            if (hinduMonth == null || hinduMonth.isLeap() && hinduCalendar.variant.isSolar()) {
                return false;
            }
            if (hinduMonth.isLeap()) {
                HinduCalendar hinduCalendar2 = hinduCalendar.withNewYear();
                int n2 = 0;
                while (!hinduCalendar2.month.equals(hinduMonth)) {
                    if (!hinduCalendar2.month.isLeap() && ++n2 >= 12) {
                        return false;
                    }
                    hinduCalendar2 = hinduCalendar2.nextMonth();
                }
            }
            if (hinduCalendar.variant.isLunisolar() && !hinduCalendar.variant.isOld()) {
                return !hinduCalendar.variant.getCalendarSystem().isExpunged(hinduCalendar.kyYear, hinduMonth);
            }
            return true;
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, HinduMonth hinduMonth, boolean bl2) {
            if (hinduMonth == null || hinduMonth.isLeap() && hinduCalendar.variant.isSolar()) {
                throw new IllegalArgumentException("Invalid month: " + hinduMonth);
            }
            HinduCalendar hinduCalendar2 = hinduCalendar.withNewYear();
            int n2 = 0;
            while (!hinduCalendar2.month.equals(hinduMonth)) {
                if (!hinduCalendar2.month.isLeap() && ++n2 >= 12) {
                    throw new IllegalArgumentException("Invalid month: " + hinduMonth);
                }
                hinduCalendar2 = hinduCalendar2.nextMonth();
            }
            return hinduCalendar2.withAdjustedDayInMonth(hinduCalendar.dayOfMonth);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public Class<HinduMonth> getType() {
            return HinduMonth.class;
        }

        @Override
        public char getSymbol() {
            return 'M';
        }

        @Override
        public HinduMonth getDefaultMinimum() {
            return HinduMonth.ofLunisolar(1);
        }

        @Override
        public HinduMonth getDefaultMaximum() {
            return HinduMonth.ofLunisolar(12);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        protected Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Object object;
            HinduVariant hinduVariant = HinduCalendar.getVariant(chronoDisplay, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n2 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            HinduMonth hinduMonth = chronoDisplay.get(MONTH_OF_YEAR);
            boolean bl2 = false;
            char c2 = '*';
            String string = "";
            if (hinduMonth.isLeap()) {
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl2 = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c2 = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(((String)object.get("leap-indicator")).charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
            }
            if (n2 == 0) {
                if (hinduVariant.isSolar() && attributeQuery.get(HinduMonth.RASI_NAMES, hinduVariant.prefersRasiNames()).booleanValue()) {
                    appendable.append(hinduMonth.getRasi(locale));
                } else {
                    object = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                    OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                    if (hinduMonth.isLeap() && !bl2) {
                        if (object == TextWidth.WIDE) {
                            appendable.append(string);
                            appendable.append(' ');
                        } else {
                            appendable.append(c2);
                        }
                        hinduMonth = HinduMonth.of(hinduMonth.getValue());
                    }
                    appendable.append(hinduMonth.getDisplayName(locale, (TextWidth)((Object)object), outputContext));
                    if (bl2) {
                        if (object == TextWidth.WIDE) {
                            appendable.append(' ');
                            appendable.append(string);
                        } else {
                            appendable.append(c2);
                        }
                    }
                }
            } else {
                if (hinduMonth.isLeap() && !bl2) {
                    appendable.append(c2);
                }
                int n3 = hinduVariant.isSolar() ? hinduMonth.getRasi() : hinduMonth.getValue().getValue();
                NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                char c3 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(numberSystem.getDigits().charAt(0))).charValue();
                String string2 = DualFormatElement.toNumeral(numberSystem, c3, n3);
                if (hinduVariant.isSolar() && numberSystem.isDecimal()) {
                    for (int i2 = n2 - string2.length(); i2 > 0; --i2) {
                        appendable.append(c3);
                    }
                }
                appendable.append(string2);
                if (bl2) {
                    appendable.append(c2);
                }
            }
        }

        @Override
        public HinduMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n2;
            Enum enum_;
            Object object;
            int n3;
            int n4 = parsePosition.getIndex();
            int n5 = n4;
            if (n5 >= (n3 = charSequence.length())) {
                parsePosition.setErrorIndex(n4);
                return null;
            }
            HinduVariant hinduVariant = HinduCalendar.getVariant(null, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n6 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl3 = false;
            char c2 = '*';
            String string = "";
            boolean bl4 = false;
            boolean bl5 = hinduVariant.isSolar();
            if (!bl5) {
                int n7;
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl3 = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c2 = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(object.get("leap-indicator").charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
                if (!bl3 && (n7 = HinduCalendar.parseLeadingLeapInfo(charSequence, n5, n3, bl2, string, c2, locale)) != -1) {
                    n5 = n7;
                    bl4 = true;
                }
            }
            if (n5 >= n3) {
                parsePosition.setErrorIndex(n4);
                return null;
            }
            if (n6 == 0) {
                parsePosition.setIndex(n5);
                enum_ = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                CalendarText calendarText = CalendarText.getInstance("indian", locale);
                IndianMonth indianMonth = calendarText.getStdMonths((TextWidth)enum_, outputContext).parse(charSequence, parsePosition, IndianMonth.class, attributeQuery);
                if (indianMonth == null && bl5) {
                    parsePosition.setIndex(n5);
                    parsePosition.setErrorIndex(-1);
                    TextAccessor textAccessor = CalendarText.getInstance("hindu", locale).getTextForms("R", IndianMonth.class, new String[0]);
                    int n8 = textAccessor.parse(charSequence, parsePosition, IndianMonth.class, attributeQuery).getValue();
                    indianMonth = HinduMonth.ofSolar(n8).getValue();
                }
                if (indianMonth == null) {
                    parsePosition.setErrorIndex(n4);
                    return null;
                }
                object = HinduMonth.of(indianMonth);
                n5 = parsePosition.getIndex();
            } else {
                enum_ = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                char c3 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(((NumberSystem)enum_).getDigits().charAt(0))).charValue();
                int n9 = 0;
                if (bl5 && ((NumberSystem)enum_).isDecimal()) {
                    while (n5 < n3 && charSequence.charAt(n5) == c3) {
                        ++n5;
                    }
                }
                block1: for (int i2 = 12; i2 >= 1 && n9 == 0; --i2) {
                    String string2 = DualFormatElement.toNumeral((NumberSystem)enum_, c3, i2);
                    int n10 = string2.length();
                    int n11 = 0;
                    while (n3 <= n5 + n11 || charSequence.charAt(n5 + n11) == string2.charAt(n11)) {
                        if (n11 + 1 == n10) {
                            n9 = i2;
                            n5 += n10;
                            continue block1;
                        }
                        ++n11;
                    }
                }
                if (n9 == 0) {
                    parsePosition.setErrorIndex(n4);
                    return null;
                }
                Object object2 = object = bl5 ? HinduMonth.ofSolar(n9) : HinduMonth.ofLunisolar(n9);
            }
            if (bl3 && (n2 = HinduCalendar.parseTrailingLeapInfo(charSequence, n5, n3, bl2, string, c2, locale)) != -1) {
                n5 = n2;
                bl4 = true;
            }
            if (bl4) {
                object = ((HinduMonth)object).withLeap();
            }
            parsePosition.setIndex(n5);
            return object;
        }
    }

    private static class DayOfMonthElement
    extends DisplayElement<HinduDay>
    implements AdjustableTextElement<HinduDay>,
    ElementRule<HinduCalendar, HinduDay> {
        static final DayOfMonthElement SINGLETON = new DayOfMonthElement();
        private static final long serialVersionUID = 992340906349614332L;

        private DayOfMonthElement() {
            super("DAY_OF_MONTH");
        }

        @Override
        public HinduDay getValue(HinduCalendar hinduCalendar) {
            return hinduCalendar.dayOfMonth;
        }

        @Override
        public HinduDay getMinimum(HinduCalendar hinduCalendar) {
            return hinduCalendar.withFirstDayOfMonth().dayOfMonth;
        }

        @Override
        public HinduDay getMaximum(HinduCalendar hinduCalendar) {
            HinduCalendar hinduCalendar2 = hinduCalendar.withMidOfMonth(1).withFirstDayOfMonth();
            HinduCS hinduCS = hinduCalendar.variant.getCalendarSystem();
            return hinduCS.create(hinduCalendar2.utcDays - 1L).dayOfMonth;
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, HinduDay hinduDay) {
            if (hinduDay == null || hinduDay.isLeap() && hinduCalendar.variant.isSolar()) {
                return false;
            }
            boolean bl2 = hinduCalendar.variant.isPurnimanta() && hinduCalendar.isChaitra() && hinduCalendar.withNewYear().month.equals(hinduCalendar.month);
            int n2 = hinduCalendar.criticalYear(bl2, hinduDay);
            return hinduCalendar.variant.getCalendarSystem().isValid(n2, hinduCalendar.month, hinduDay);
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, HinduDay hinduDay, boolean bl2) {
            if (!(hinduDay == null || hinduDay.isLeap() && hinduCalendar.variant.isSolar())) {
                boolean bl3 = hinduCalendar.variant.isPurnimanta() && hinduCalendar.isChaitra() && hinduCalendar.withNewYear().month.equals(hinduCalendar.month);
                int n2 = hinduCalendar.criticalYear(bl3, hinduDay);
                HinduCS hinduCS = hinduCalendar.variant.getCalendarSystem();
                if (hinduCS.isValid(n2, hinduCalendar.month, hinduDay)) {
                    return hinduCS.create(n2, hinduCalendar.month, hinduDay);
                }
            }
            throw new IllegalArgumentException("Invalid day of month: " + hinduDay);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            return null;
        }

        @Override
        public Class<HinduDay> getType() {
            return HinduDay.class;
        }

        @Override
        public char getSymbol() {
            return 'd';
        }

        @Override
        public HinduDay getDefaultMinimum() {
            return HinduDay.valueOf(1);
        }

        @Override
        public HinduDay getDefaultMaximum() {
            return HinduDay.valueOf(32);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        protected Object readResolve() throws ObjectStreamException {
            return SINGLETON;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Object object;
            HinduVariant hinduVariant = HinduCalendar.getVariant(chronoDisplay, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n2 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            HinduDay hinduDay = chronoDisplay.get(DAY_OF_MONTH);
            boolean bl2 = false;
            char c2 = '*';
            String string = "";
            if (hinduDay.isLeap()) {
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl2 = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c2 = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(((String)object.get("leap-indicator")).charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
            }
            if (hinduDay.isLeap() && !bl2) {
                if (n2 >= 2) {
                    appendable.append(string);
                    appendable.append(' ');
                } else {
                    appendable.append(c2);
                }
            }
            object = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            char c3 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(((NumberSystem)((Object)object)).getDigits().charAt(0))).charValue();
            String string2 = DualFormatElement.toNumeral((NumberSystem)((Object)object), c3, hinduDay.getValue());
            if (hinduVariant.isSolar() && ((NumberSystem)((Object)object)).isDecimal()) {
                for (int i2 = n2 - string2.length(); i2 > 0; --i2) {
                    appendable.append(c3);
                }
            }
            appendable.append(string2);
            if (bl2) {
                if (n2 >= 2) {
                    appendable.append(' ');
                    appendable.append(string);
                } else {
                    appendable.append(c2);
                }
            }
        }

        @Override
        public HinduDay parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n2;
            int n3;
            int n4;
            Object object;
            int n5;
            int n6 = parsePosition.getIndex();
            int n7 = n6;
            if (n7 >= (n5 = charSequence.length())) {
                parsePosition.setErrorIndex(n6);
                return null;
            }
            HinduVariant hinduVariant = HinduCalendar.getVariant(null, attributeQuery);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl3 = false;
            char c2 = '*';
            String string = "";
            boolean bl4 = false;
            boolean bl5 = hinduVariant.isSolar();
            if (!bl5) {
                object = CalendarText.getInstance("generic", locale).getTextForms();
                bl3 = attributeQuery.get(HinduPrimitive.ADHIKA_IS_TRAILING, "R".equals(object.get("leap-alignment")));
                c2 = attributeQuery.get(HinduPrimitive.ADHIKA_INDICATOR, Character.valueOf(((String)object.get("leap-indicator")).charAt(0))).charValue();
                string = CalendarText.getInstance("hindu", locale).getTextForms().get("adhika");
                if (!bl3 && (n4 = HinduCalendar.parseLeadingLeapInfo(charSequence, n7, n5, bl2, string, c2, locale)) != -1) {
                    n7 = n4;
                    bl4 = true;
                }
            }
            if (n7 >= n5) {
                parsePosition.setErrorIndex(n6);
                return null;
            }
            object = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            n4 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(((NumberSystem)((Object)object)).getDigits().charAt(0))).charValue();
            int n8 = 0;
            if (bl5 && ((NumberSystem)((Object)object)).isDecimal()) {
                while (n7 < n5 && charSequence.charAt(n7) == n4) {
                    ++n7;
                }
            }
            int n9 = n3 = bl5 ? 32 : 30;
            while (n3 >= 1 && n8 == 0) {
                String string2 = DualFormatElement.toNumeral((NumberSystem)((Object)object), (char)n4, n3);
                int n10 = string2.length();
                int n11 = 0;
                while (n5 <= n7 + n11 || charSequence.charAt(n7 + n11) == string2.charAt(n11)) {
                    if (n11 + 1 == n10) {
                        n8 = n3;
                        n7 += n10;
                        break;
                    }
                    ++n11;
                }
                --n3;
            }
            if (n8 == 0) {
                parsePosition.setErrorIndex(n6);
                return null;
            }
            HinduDay hinduDay = HinduDay.valueOf(n8);
            if (bl3 && (n2 = HinduCalendar.parseTrailingLeapInfo(charSequence, n7, n5, bl2, string, c2, locale)) != -1) {
                n7 = n2;
                bl4 = true;
            }
            if (bl4) {
                hinduDay = hinduDay.withLeap();
            }
            parsePosition.setIndex(n7);
            return hinduDay;
        }
    }

    private static class VariantMap
    extends ConcurrentHashMap<String, HinduCS> {
        private VariantMap() {
        }

        @Override
        public HinduCS get(Object object) {
            String string;
            HinduCS hinduCS;
            HinduCS hinduCS2 = (HinduCS)super.get(object);
            if (hinduCS2 == null && (hinduCS = this.putIfAbsent(string = object.toString(), hinduCS2 = HinduVariant.from(string).getCalendarSystem())) != null) {
                hinduCS2 = hinduCS;
            }
            return hinduCS2;
        }

        void accept(HinduVariant hinduVariant) {
            this.put(hinduVariant.getVariant(), hinduVariant.getCalendarSystem());
        }
    }

    private static class Merger
    implements ChronoMerger<HinduCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return IndianCalendar.axis().getFormatPattern(formatStyle, locale);
        }

        @Override
        public HinduCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                return null;
            }
            HinduVariant hinduVariant = HinduVariant.from(string);
            GeoLocation geoLocation = hinduVariant.getLocation();
            TZID tZID = attributeQuery.contains(Attributes.TIMEZONE_ID) ? attributeQuery.get(Attributes.TIMEZONE_ID) : ZonalOffset.atLongitude(BigDecimal.valueOf(hinduVariant.getLocation().getLongitude()));
            StartOfDay startOfDay = StartOfDay.definedBy(SolarTime.ofLocation(geoLocation.getLatitude(), geoLocation.getLongitude(), geoLocation.getAltitude(), StdSolarCalculator.CC).sunrise());
            StartOfDay startOfDay2 = attributeQuery.get(Attributes.START_OF_DAY, startOfDay);
            return (HinduCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, string, tZID, startOfDay2).toDate();
        }

        @Override
        public HinduCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            int n2;
            HinduVariant hinduVariant;
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Hindu calendar variant.");
                return null;
            }
            try {
                hinduVariant = HinduVariant.from(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hindu calendar variant.");
                return null;
            }
            HinduCS hinduCS = hinduVariant.getCalendarSystem();
            HinduEra hinduEra = hinduVariant.getDefaultEra();
            if (chronoEntity.contains(ERA)) {
                hinduEra = chronoEntity.get(ERA);
            }
            if ((n2 = chronoEntity.getInt(YEAR_OF_ERA)) == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Hindu year.");
                return null;
            }
            int n3 = HinduEra.KALI_YUGA.yearOfEra(hinduEra, n2);
            if (!hinduVariant.isUsingElapsedYears()) {
                --n3;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR) && chronoEntity.contains(DAY_OF_MONTH)) {
                HinduDay hinduDay;
                HinduMonth hinduMonth = chronoEntity.get(MONTH_OF_YEAR);
                if (hinduCS.isValid(n3, hinduMonth, hinduDay = chronoEntity.get(DAY_OF_MONTH))) {
                    return hinduCS.create(n3, hinduMonth, hinduDay);
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hindu date.");
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 >= 1) {
                        HinduCalendar hinduCalendar = hinduCS.create(n3, HinduMonth.of(IndianMonth.AGRAHAYANA), HinduDay.valueOf(1));
                        long l2 = hinduCS.create(hinduCalendar.utcDays).withNewYear().utcDays + (long)n4 - 1L;
                        HinduCalendar hinduCalendar2 = hinduCS.create(l2);
                        if (hinduCS.getMinimumSinceUTC() <= l2 && hinduCS.getMaximumSinceUTC() >= l2 && (bl2 || hinduCalendar2.kyYear == n3)) {
                            return hinduCalendar2;
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hindu date.");
                }
            }
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.definedBy(SolarTime.ofLocation(HinduVariant.UJJAIN.getLatitude(), HinduVariant.UJJAIN.getLongitude()).sunrise());
        }

        @Override
        public int getDefaultPivotYear() {
            return 100;
        }
    }

    private static class EraRule
    implements ElementRule<HinduCalendar, HinduEra> {
        private EraRule() {
        }

        @Override
        public HinduEra getValue(HinduCalendar hinduCalendar) {
            return hinduCalendar.getEra();
        }

        @Override
        public HinduEra getMinimum(HinduCalendar hinduCalendar) {
            return HinduEra.KALI_YUGA;
        }

        @Override
        public HinduEra getMaximum(HinduCalendar hinduCalendar) {
            if (!hinduCalendar.variant.isOld()) {
                HinduEra[] hinduEraArray = HinduEra.values();
                for (int i2 = hinduEraArray.length - 1; i2 >= 1; --i2) {
                    HinduEra hinduEra = hinduEraArray[i2];
                    if (hinduEra.yearOfEra(HinduEra.KALI_YUGA, hinduCalendar.kyYear) < 0) continue;
                    return hinduEra;
                }
            }
            return HinduEra.KALI_YUGA;
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, HinduEra hinduEra) {
            return hinduCalendar.variant.isOld() ? hinduEra == HinduEra.KALI_YUGA : hinduEra != null;
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, HinduEra hinduEra, boolean bl2) {
            if (this.isValid(hinduCalendar, hinduEra)) {
                HinduVariant hinduVariant = hinduCalendar.variant.with(hinduEra);
                if (hinduVariant == hinduCalendar.variant) {
                    return hinduCalendar;
                }
                return new HinduCalendar(hinduVariant, hinduCalendar.kyYear, hinduCalendar.month, hinduCalendar.dayOfMonth, hinduCalendar.utcDays);
            }
            throw new IllegalArgumentException("Invalid Hindu era: " + hinduEra);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class IntegerRule
    implements IntElementRule<HinduCalendar> {
        private final int index;

        IntegerRule(int n2) {
            this.index = n2;
        }

        @Override
        public int getInt(HinduCalendar hinduCalendar) {
            switch (this.index) {
                case 0: {
                    return hinduCalendar.getYear();
                }
                case 1: {
                    return hinduCalendar.getDayOfYear();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, int n2) {
            int n3 = this.getMin(hinduCalendar);
            int n4 = this.getMax(hinduCalendar);
            return n3 <= n2 && n4 >= n2;
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, int n2, boolean bl2) {
            if (!this.isValid(hinduCalendar, n2)) {
                throw new IllegalArgumentException("Out of range: " + n2);
            }
            switch (this.index) {
                case 0: {
                    HinduMonth hinduMonth;
                    HinduCS hinduCS;
                    boolean bl3;
                    int n3 = HinduEra.KALI_YUGA.yearOfEra(hinduCalendar.getEra(), n2);
                    if (!hinduCalendar.variant.isUsingElapsedYears()) {
                        --n3;
                    }
                    if (n3 == hinduCalendar.kyYear) {
                        return hinduCalendar;
                    }
                    int n4 = 15;
                    if (hinduCalendar.variant.isPurnimanta()) {
                        int n5 = n4 = hinduCalendar.dayOfMonth.getValue() >= 16 ? 29 : 2;
                    }
                    if (bl3 = (hinduCS = hinduCalendar.variant.getCalendarSystem()).isExpunged(n3, hinduMonth = hinduCalendar.month)) {
                        long l2;
                        HinduMonth hinduMonth2;
                        hinduMonth = HinduMonth.of(hinduCalendar.month.getValue().roll(n3 > hinduCalendar.kyYear ? -1 : 1));
                        if (n3 < hinduCalendar.kyYear && (hinduMonth2 = hinduCS.create(l2 = hinduCS.create(n3, hinduMonth, HinduDay.valueOf(n4)).getDaysSinceEpochUTC() - 30L).month).equals(hinduMonth.withLeap())) {
                            hinduMonth = hinduMonth2;
                        }
                    }
                    HinduCalendar hinduCalendar2 = hinduCS.create(n3, hinduMonth, HinduDay.valueOf(n4));
                    if (!bl3 && hinduMonth.isLeap() && (hinduCalendar2 = hinduCS.transform(hinduCalendar2.utcDays)).month.getValue().getValue() > hinduMonth.getValue().getValue()) {
                        hinduCalendar2 = hinduCS.create(hinduCalendar2.utcDays - 30L);
                    }
                    return hinduCalendar2.withAdjustedDayInMonth(hinduCalendar.dayOfMonth);
                }
                case 1: {
                    int n6 = n2 - this.getInt(hinduCalendar);
                    return (HinduCalendar)hinduCalendar.plus(CalendarDays.of(n6));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getValue(HinduCalendar hinduCalendar) {
            return this.getInt(hinduCalendar);
        }

        @Override
        public Integer getMinimum(HinduCalendar hinduCalendar) {
            return this.getMin(hinduCalendar);
        }

        @Override
        public Integer getMaximum(HinduCalendar hinduCalendar) {
            return this.getMax(hinduCalendar);
        }

        @Override
        public boolean isValid(HinduCalendar hinduCalendar, Integer n2) {
            return n2 != null && this.isValid(hinduCalendar, (int)n2);
        }

        @Override
        public HinduCalendar withValue(HinduCalendar hinduCalendar, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(hinduCalendar, (int)n2, bl2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HinduCalendar hinduCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HinduCalendar hinduCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        private int getMin(HinduCalendar hinduCalendar) {
            switch (this.index) {
                case 0: {
                    int n2 = hinduCalendar.variant.isOld() ? 0 : 1200;
                    return hinduCalendar.variant.isUsingElapsedYears() ? n2 : n2 + 1;
                }
                case 1: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        private int getMax(HinduCalendar hinduCalendar) {
            switch (this.index) {
                case 0: {
                    int n2 = hinduCalendar.variant.isUsingElapsedYears() ? 5999 : 6000;
                    return hinduCalendar.getEra().yearOfEra(HinduEra.KALI_YUGA, n2);
                }
                case 1: {
                    HinduCalendar hinduCalendar2 = hinduCalendar.withNewYear();
                    HinduCalendar hinduCalendar3 = hinduCalendar.variant.getCalendarSystem().create(hinduCalendar2.utcDays + 400L).withNewYear();
                    return (int)(hinduCalendar3.utcDays - hinduCalendar2.utcDays);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }
    }
}

