/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.util.Arrays;
import java.util.List;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;

abstract class HinduCS
implements CalendarSystem<HinduCalendar> {
    static final long KALI_YUGA_EPOCH = -1132959L;
    final HinduVariant variant;

    HinduCS(HinduVariant hinduVariant) {
        if (hinduVariant == null) {
            throw new NullPointerException();
        }
        this.variant = hinduVariant;
    }

    @Override
    public final HinduCalendar transform(long l2) {
        long l3 = this.getMinimumSinceUTC();
        long l4 = this.getMaximumSinceUTC();
        if (l2 < l3 || l2 > l4) {
            throw new IllegalArgumentException("Out of range: " + l3 + " <= " + l2 + " <= " + l4);
        }
        return this.create(l2);
    }

    @Override
    public final long transform(HinduCalendar hinduCalendar) {
        return hinduCalendar.getDaysSinceEpochUTC();
    }

    @Override
    public List<CalendarEra> getEras() {
        return Arrays.asList(HinduEra.values());
    }

    abstract HinduCalendar create(long var1);

    abstract HinduCalendar create(int var1, HinduMonth var2, HinduDay var3);

    abstract boolean isValid(int var1, HinduMonth var2, HinduDay var3);

    final boolean isExpunged(int n2, HinduMonth hinduMonth) {
        long l2 = this.create(n2, hinduMonth, HinduDay.valueOf(15)).getDaysSinceEpochUTC();
        HinduCalendar hinduCalendar = this.create(l2);
        return !hinduCalendar.getMonth().getValue().equals(hinduMonth.getValue());
    }

    final boolean isExpunged(int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
        long l2 = this.create(n2, hinduMonth, hinduDay).getDaysSinceEpochUTC();
        HinduCalendar hinduCalendar = this.create(l2);
        return hinduCalendar.getExpiredYearOfKaliYuga() != n2 || !hinduCalendar.getMonth().equals(hinduMonth) || !hinduCalendar.getDayOfMonth().equals(hinduDay);
    }

    static double modulo(double d2, double d3) {
        return d2 - d3 * Math.floor(d2 / d3);
    }
}

