/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.frenchrev;

import java.util.Locale;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum DayOfDecade {
    PRIMIDI,
    DUODI,
    TRIDI,
    QUARTIDI,
    QUINTIDI,
    SEXTIDI,
    SEPTIDI,
    OCTIDI,
    NONIDI,
    DECADI;


    public static DayOfDecade valueOf(int n2) {
        if (n2 < 1 || n2 > 10) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return DayOfDecade.values()[n2 - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("frenchrev", locale);
        String string = textWidth == TextWidth.NARROW ? "N" : (outputContext == OutputContext.FORMAT ? "w" : "W");
        return calendarText.getTextForms().get("D(" + string + ")_" + this.getValue());
    }
}

