/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.EquatorialCoordinates;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.astro.Zodiac;
import net.time4j.tz.ZonalOffset;

public class MoonPosition
implements EquatorialCoordinates,
Serializable {
    private static final int[] A_D = new int[]{0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 0, 1, 0, 2, 0, 0, 4, 0, 4, 2, 2, 1, 1, 2, 2, 4, 2, 0, 2, 2, 1, 2, 0, 0, 2, 2, 2, 4, 0, 3, 2, 4, 0, 2, 2, 2, 4, 0, 4, 1, 2, 0, 1, 3, 4, 2, 0, 1, 2, 2};
    private static final int[] A_M = new int[]{0, 0, 0, 0, 1, 0, 0, -1, 0, -1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, -2, 1, 2, -2, 0, 0, -1, 0, 0, 1, -1, 2, 2, 1, -1, 0, 0, -1, 0, 1, 0, 1, 0, 0, -1, 2, 1, 0, 0};
    private static final int[] A_M2 = new int[]{1, -1, 0, 2, 0, 0, -2, -1, 1, 0, -1, 0, 1, 0, 1, 1, -1, 3, -2, -1, 0, -1, 0, 1, 2, 0, -3, -2, -1, -2, 1, 0, 2, 0, -1, 1, 0, -1, 2, -1, 1, -2, -1, -1, -2, 0, 1, 4, 0, -2, 0, 2, 1, -2, -3, 2, 1, -1, 3, -1};
    private static final int[] A_F = new int[]{0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, -2, 2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, -2, 2, 0, 2, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, -2, -2, 0, 0, 0, 0, 0, 0, 0, -2};
    private static final int[] COEFF_L = new int[]{6288774, 1274027, 658314, 213618, -185116, -114332, 58793, 57066, 53322, 45758, -40923, -34720, -30383, 15327, -12528, 10980, 10675, 10034, 8548, -7888, -6766, -5163, 4987, 4036, 3994, 3861, 3665, -2689, -2602, 2390, -2348, 2236, -2120, -2069, 2048, -1773, -1595, 1215, -1110, -892, -810, 759, -713, -700, 691, 596, 549, 537, 520, -487, -399, -381, 351, -340, 330, 327, -323, 299, 294, 0};
    private static final int[] COEFF_R = new int[]{-20905355, -3699111, -2955968, -569925, 48888, -3149, 246158, -152138, -170733, -204586, -129620, 108743, 104755, 10321, 0, 79661, -34782, -23210, -21636, 24208, 30824, -8379, -16675, -12831, -10445, -11650, 14403, -7003, 0, 10056, 6322, -9884, 5751, 0, -4950, 4130, 0, -3958, 0, 3258, 2616, -1897, -2117, 2354, 0, 0, -1423, -1117, -1571, -1739, 0, -4421, 0, 0, 0, 0, 1165, 0, 0, 8752};
    private static final int[] B_D = new int[]{0, 0, 0, 2, 2, 2, 2, 0, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 1, 0, 4, 4, 0, 4, 2, 2, 2, 2, 0, 2, 2, 2, 2, 4, 2, 2, 0, 2, 1, 1, 0, 2, 1, 2, 0, 4, 4, 1, 4, 1, 4, 2};
    private static final int[] B_M = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, -1, -1, -1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 1, 0, -1, -2, 0, 1, 1, 1, 1, 1, 0, -1, 1, 0, -1, 0, 0, 0, -1, -2};
    private static final int[] B_M2 = new int[]{0, 1, 1, 0, -1, -1, 0, 2, 1, 2, 0, -2, 1, 0, -1, 0, -1, -1, -1, 0, 0, -1, 0, 1, 1, 0, 0, 3, 0, -1, 1, -2, 0, 2, 1, -2, 3, 2, -3, -1, 0, 0, 1, 0, 1, 1, 0, 0, -2, -1, 1, -2, 2, -2, -1, 1, 1, -1, 0, 0};
    private static final int[] B_F = new int[]{1, 1, -1, -1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, 1, 1, -1, -1, -1, 1, 3, 1, 1, 1, -1, -1, -1, 1, -1, 1, -3, 1, -3, -1, -1, 1, -1, 1, -1, 1, 1, 1, 1, -1, 3, -1, -1, 1, -1, -1, 1, -1, 1, -1, -1, -1, -1, -1, -1, 1};
    private static final int[] COEFF_B = new int[]{5128122, 280602, 277693, 173237, 55413, 46271, 32573, 17198, 9266, 8822, 8216, 4324, 4200, -3359, 2463, 2211, 2065, -1870, 1828, -1794, -1749, -1565, -1491, -1475, -1410, -1344, -1335, 1107, 1021, 833, 777, 671, 607, 596, 491, -451, 439, 422, 421, -366, -351, 331, 315, 302, -283, -229, 223, 223, -220, -220, -185, 181, -177, 176, 166, -164, 132, -119, 115, 107};
    private static final int[] PERIGEE_D = new int[]{2, 4, 6, 8, 2, 0, 10, 4, 6, 12, 1, 8, 14, 0, 3, 10, 16, 12, 5, 2, 18, 14, 7, 2, 20, 1, 16, 4, 9, 4, 2, 4, 6, 22, 18, 6, 11, 8, 4, 6, 3, 5, 13, 20, 3, 4, 1, 22, 0, 6, 2, 0, 0, 2, 0, 2, 24, 4, 2, 1};
    private static final int[] PERIGEE_F = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, -2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 4, -2, -2, 0, 2, 4, 2, -2, 0, -4, 0, 0};
    private static final int[] PERIGEE_M = new int[]{0, 0, 0, 0, -1, 1, 0, -1, -1, 0, 0, -1, 0, 0, 0, -1, 0, -1, 0, 0, 0, -1, 0, 1, 0, 1, -1, 1, 0, 0, -2, -2, -2, 0, -1, 1, 0, 1, 0, 0, 1, 1, 0, -1, 2, -2, 2, -1, 0, 0, 1, 2, -1, 0, -2, 2, 0, 0, 2, -1};
    private static final double[] PERIGEE_COEFF = new double[]{-1.6769, 0.4589, -0.1856, 0.0883, -0.0773, 0.0502, -0.046, 0.0422, -0.0256, 0.0253, 0.0237, 0.0162, -0.0145, 0.0129, -0.0112, -0.0104, 0.0086, 0.0069, 0.0066, -0.0053, -0.0052, -0.0046, -0.0041, 0.004, 0.0032, -0.0032, 0.0031, -0.0029, 0.0027, 0.0027, -0.0027, 0.0024, -0.0021, -0.0021, -0.0021, 0.0019, -0.0018, -0.0014, -0.0014, -0.0014, 0.0014, -0.0014, 0.0013, 0.0013, 0.0011, -0.0011, -0.001, -9.0E-4, -8.0E-4, 8.0E-4, 8.0E-4, 7.0E-4, 7.0E-4, 7.0E-4, -6.0E-4, -6.0E-4, 6.0E-4, 5.0E-4, 5.0E-4, -4.0E-4};
    private static final double[] PERIGEE_COEFF_T = new double[]{0.0, 0.0, 0.0, 0.0, 1.9E-4, -1.3E-4, 0.0, -1.1E-4};
    private static final int[] APOGEE_D = new int[]{2, 4, 0, 2, 0, 1, 6, 4, 2, 1, 8, 6, 2, 2, 3, 4, 8, 4, 10, 3, 0, 2, 2, 6, 6, 10, 5, 4, 0, 12, 2, 1};
    private static final int[] APOGEE_F = new int[]{0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, -2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, -2, 2, 0, 2, 0};
    private static final int[] APOGEE_M = new int[]{0, 0, 1, -1, 0, 0, 0, -1, 0, 1, 0, -1, 0, -2, 0, 0, -1, -2, 0, 1, 2, 1, 2, 0, -2, -1, 0, 0, 1, 0, -1, -1};
    private static final double[] APOGEE_COEFF = new double[]{0.4392, 0.0684, 0.0456, 0.0426, 0.0212, -0.0189, 0.0144, 0.0113, 0.0047, 0.0036, 0.0035, 0.0034, -0.0034, 0.0022, -0.0017, 0.0013, 0.0011, 0.001, 9.0E-4, 7.0E-4, 6.0E-4, 5.0E-4, 5.0E-4, 4.0E-4, 4.0E-4, 4.0E-4, -4.0E-4, -4.0E-4, 3.0E-4, 3.0E-4, 3.0E-4, -3.0E-4};
    private static final double[] APOGEE_COEFF_T = new double[]{0.0, 0.0, -1.1E-4, -1.1E-4};
    private static final int MIO = 1000000;
    private static final long serialVersionUID = 5736859564589473324L;
    private final double rightAscension;
    private final double declination;
    private final double azimuth;
    private final double elevation;
    private final double distance;

    private MoonPosition(double d2, double d3, double d4, double d5, double d6) {
        this.rightAscension = d2;
        this.declination = d3;
        this.azimuth = d4;
        this.elevation = d5;
        this.distance = d6;
    }

    public static MoonPosition at(Moment moment, GeoLocation geoLocation) {
        double d2;
        double d3;
        double[] dArray = MoonPosition.calculateMeeus47(JulianDay.ofEphemerisTime(moment).getCenturyJ2000());
        double d4 = Math.toRadians(dArray[2]);
        double d5 = Math.toRadians(dArray[3]);
        double d6 = dArray[4];
        double d7 = Math.toRadians(geoLocation.getLatitude());
        double d8 = Math.toRadians(geoLocation.getLongitude());
        double d9 = Math.cos(d7);
        double d10 = Math.sin(d7);
        int n2 = geoLocation.getAltitude();
        double d11 = JulianDay.ofMeanSolarTime(moment).getMJD();
        double d12 = dArray[0] * Math.cos(Math.toRadians(dArray[1]));
        double d13 = AstroUtils.gmst(d11) + Math.toRadians(d12) + d8 - d4;
        double d14 = d10 * Math.sin(d5) + d9 * Math.cos(d5) * Math.cos(d13);
        double d15 = Math.toDegrees(Math.asin(d14));
        if (d15 >= -0.5 - (d3 = StdSolarCalculator.TIME4J.getGeodeticAngle(geoLocation.getLatitude(), n2))) {
            d2 = Math.toDegrees(Math.asin(6378.14 / d6));
            double d16 = AstroUtils.refractionFactorOfStdAtmosphere(n2);
            double d17 = d16 * AstroUtils.getRefraction(d15) / 60.0;
            d15 = d15 - d2 + d17;
        }
        d2 = Math.toDegrees(Math.atan2(Math.sin(d13), Math.cos(d13) * d10 - Math.tan(d5) * d9)) + 180.0;
        return new MoonPosition(dArray[2], dArray[3], d2, d15, d6);
    }

    public static Zodiac.Event inConstellationOf(Zodiac zodiac) {
        return Zodiac.Event.ofConstellation('L', zodiac);
    }

    public static Zodiac.Event inSignOf(Zodiac zodiac) {
        return Zodiac.Event.ofSign('L', zodiac);
    }

    public static Moment inNextApogeeAfter(Moment moment) {
        return MoonPosition.anomalistic(moment, true);
    }

    public static Moment inNextPerigeeAfter(Moment moment) {
        return MoonPosition.anomalistic(moment, false);
    }

    @Override
    public double getRightAscension() {
        return this.rightAscension;
    }

    @Override
    public double getDeclination() {
        return this.declination;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MoonPosition) {
            MoonPosition moonPosition = (MoonPosition)object;
            return this.rightAscension == moonPosition.rightAscension && this.declination == moonPosition.declination && this.azimuth == moonPosition.azimuth && this.elevation == moonPosition.elevation && this.distance == moonPosition.distance;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.rightAscension) + 31 * Double.hashCode(this.declination) + 37 * Double.hashCode(this.distance);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("moon-position[ra=");
        stringBuilder.append(this.rightAscension);
        stringBuilder.append(",decl=");
        stringBuilder.append(this.declination);
        stringBuilder.append(",azimuth=");
        stringBuilder.append(this.azimuth);
        stringBuilder.append(",elevation=");
        stringBuilder.append(this.elevation);
        stringBuilder.append(",distance=");
        stringBuilder.append(this.distance);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static double[] calculateMeeus47(double d2) {
        double d3;
        double d4 = MoonPosition.getMeanLongitude(d2);
        double d5 = MoonPosition.getMeanElongation(d2);
        double d6 = MoonPosition.getMeanAnomalyOfSun(d2);
        double d7 = MoonPosition.getMeanAnomalyOfMoon(d2);
        double d8 = MoonPosition.getMeanDistanceOfMoon(d2);
        double d9 = 1.0 - (0.002516 + 7.4E-6 * d2) * d2;
        double d10 = d9 * d9;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i2 = A_D.length - 1; i2 >= 0; --i2) {
            double d13;
            switch (A_M[i2]) {
                case -1: 
                case 1: {
                    d13 = d9;
                    break;
                }
                case -2: 
                case 2: {
                    d13 = d10;
                    break;
                }
                default: {
                    d13 = 1.0;
                }
            }
            d3 = Math.toRadians((double)A_D[i2] * d5 + (double)A_M[i2] * d6 + (double)A_M2[i2] * d7 + (double)A_F[i2] * d8);
            d11 += (double)COEFF_L[i2] * d13 * Math.sin(d3);
            d12 += (double)COEFF_R[i2] * d13 * Math.cos(d3);
        }
        double d14 = 0.0;
        for (int i3 = B_D.length - 1; i3 >= 0; --i3) {
            switch (B_M[i3]) {
                case -1: 
                case 1: {
                    d3 = d9;
                    break;
                }
                case -2: 
                case 2: {
                    d3 = d10;
                    break;
                }
                default: {
                    d3 = 1.0;
                }
            }
            double d15 = (double)B_D[i3] * d5 + (double)B_M[i3] * d6 + (double)B_M2[i3] * d7 + (double)B_F[i3] * d8;
            d14 += (double)COEFF_B[i3] * d3 * Math.sin(Math.toRadians(d15));
        }
        double d16 = 119.75 + 131.849 * d2;
        double d17 = 53.09 + 479264.29 * d2;
        double d18 = 313.45 + 481266.484 * d2;
        d11 += 3958.0 * Math.sin(Math.toRadians(d16)) + 1962.0 * Math.sin(Math.toRadians(d4 - d8)) + 318.0 * Math.sin(Math.toRadians(d17));
        d14 += -2235.0 * Math.sin(Math.toRadians(d4)) + 382.0 * Math.sin(Math.toRadians(d18)) + 175.0 * Math.sin(Math.toRadians(d16 - d8)) + 175.0 * Math.sin(Math.toRadians(d16 + d8)) + 127.0 * Math.sin(Math.toRadians(d4 - d7)) - 115.0 * Math.sin(Math.toRadians(d4 + d7));
        double[] dArray = new double[5];
        StdSolarCalculator.nutations(d2, dArray);
        double d19 = StdSolarCalculator.meanObliquity(d2) + dArray[1];
        double d20 = Math.toRadians(d19);
        double d21 = Math.toRadians(d4 + d11 / 1000000.0 + dArray[0]);
        double d22 = Math.toRadians(d14 / 1000000.0);
        double d23 = 385000.56 + d12 / 1000.0;
        double d24 = Math.atan2(Math.sin(d21) * Math.cos(d20) - Math.tan(d22) * Math.sin(d20), Math.cos(d21));
        double d25 = Math.asin(Math.sin(d22) * Math.cos(d20) + Math.cos(d22) * Math.sin(d20) * Math.sin(d21));
        dArray[1] = d19;
        dArray[2] = AstroUtils.toRange_0_360(Math.toDegrees(d24));
        dArray[3] = Math.toDegrees(d25);
        dArray[4] = d23;
        return dArray;
    }

    static double lunarLongitude(double d2, double d3) {
        double d4 = (d2 - 2451545.0) / 36525.0;
        double d5 = MoonPosition.getMeanLongitude(d4);
        double d6 = MoonPosition.getMeanElongation(d4);
        double d7 = MoonPosition.getMeanAnomalyOfSun(d4);
        double d8 = MoonPosition.getMeanAnomalyOfMoon(d4);
        double d9 = MoonPosition.getMeanDistanceOfMoon(d4);
        double d10 = 1.0 - (0.002516 + 7.4E-6 * d4) * d4;
        double d11 = d10 * d10;
        double d12 = 0.0;
        for (int i2 = A_D.length - 1; i2 >= 0; --i2) {
            double d13;
            switch (A_M[i2]) {
                case -1: 
                case 1: {
                    d13 = d10;
                    break;
                }
                case -2: 
                case 2: {
                    d13 = d11;
                    break;
                }
                default: {
                    d13 = 1.0;
                }
            }
            double d14 = Math.toRadians((double)A_D[i2] * d6 + (double)A_M[i2] * d7 + (double)A_M2[i2] * d8 + (double)A_F[i2] * d9);
            d12 += (double)COEFF_L[i2] * d13 * Math.sin(d14);
        }
        double d15 = 119.75 + 131.849 * d4;
        double d16 = 53.09 + 479264.29 * d4;
        return AstroUtils.toRange_0_360(d5 + (d12 += 3958.0 * Math.sin(Math.toRadians(d15)) + 1962.0 * Math.sin(Math.toRadians(d5 - d9)) + 318.0 * Math.sin(Math.toRadians(d16))) / 1000000.0 + d3);
    }

    private static double getMeanLongitude(double d2) {
        return MoonPosition.normalize(218.3164477 + (481267.88123421 + (-0.0015786 + (1.855835023689734E-6 + -1.5338834862103876E-8 * d2) * d2) * d2) * d2);
    }

    static double getMeanElongation(double d2) {
        return MoonPosition.normalize(297.8501921 + (445267.1114034 + (-0.0018819 + (1.8319447192361523E-6 - 8.844469995135542E-9 * d2) * d2) * d2) * d2);
    }

    static double getMeanAnomalyOfSun(double d2) {
        return MoonPosition.normalize(357.5291092 + (35999.0502909 + (-1.536E-4 + 4.083299305839118E-8 * d2) * d2) * d2);
    }

    static double getMeanAnomalyOfMoon(double d2) {
        return MoonPosition.normalize(134.9633964 + (477198.8675055 + (0.0087414 + (1.4347408140719379E-5 - 6.797172376291463E-8 * d2) * d2) * d2) * d2);
    }

    private static double getMeanDistanceOfMoon(double d2) {
        return MoonPosition.normalize(93.272095 + (483202.0175233 + (-0.0036539 + (-2.8360748723766307E-7 + 1.1583324645839848E-9 * d2) * d2) * d2) * d2);
    }

    private static Moment calculateMeeus50(int n2, boolean bl2) {
        double d2 = (double)n2 + (bl2 ? -0.5 : 0.0);
        double d3 = d2 / 1325.55;
        double d4 = d3 * d3;
        double d5 = 2451534.6698 + 27.55454989 * d2 + (-6.691E-4 + (-1.098E-6 + 5.2E-9 * d3) * d3) * d4;
        double d6 = MoonPosition.normalize(171.9179 + 335.9106046 * d2 + (-0.0100383 + (-1.156E-5 + 5.5E-8 * d3) * d3) * d4);
        double d7 = MoonPosition.normalize(347.3477 + 27.1577721 * d2 + (-8.13E-4 - 1.0E-6 * d3) * d4);
        double d8 = MoonPosition.normalize(316.6109 + 364.5287911 * d2 + (-0.0125053 - 1.48E-5 * d3) * d4);
        int[] nArray = bl2 ? APOGEE_D : PERIGEE_D;
        int[] nArray2 = bl2 ? APOGEE_M : PERIGEE_M;
        int[] nArray3 = bl2 ? APOGEE_F : PERIGEE_F;
        double[] dArray = bl2 ? APOGEE_COEFF : PERIGEE_COEFF;
        double[] dArray2 = bl2 ? APOGEE_COEFF_T : PERIGEE_COEFF_T;
        double d9 = 0.0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            double d10 = (double)nArray[i2] * d6 + (double)nArray2[i2] * d7 + (double)nArray3[i2] * d8;
            double d11 = dArray[i2];
            if (i2 < dArray2.length) {
                d11 += dArray2[i2] * d3;
            }
            d9 += d11 * Math.sin(Math.toRadians(d10));
        }
        return (Moment)JulianDay.ofEphemerisTime(d5 + d9).toMoment().with(Moment.PRECISION, TimeUnit.MINUTES);
    }

    private static Moment anomalistic(Moment moment, boolean bl2) {
        Moment moment2 = (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
        PlainDate plainDate = moment2.toZonalTimestamp(ZonalOffset.UTC).toDate();
        double d2 = plainDate.getDayOfYear();
        int n2 = (int)Math.floor(((double)plainDate.getYear() + d2 / (double)plainDate.lengthOfYear() - 1999.97) * 13.2555);
        Moment moment3 = MoonPosition.calculateMeeus50(n2, bl2);
        while (moment3.isBeforeOrEqual(moment2)) {
            moment3 = MoonPosition.calculateMeeus50(++n2, bl2);
        }
        return moment3;
    }

    private static double normalize(double d2) {
        return d2 - 360.0 * Math.floor(d2 / 360.0);
    }
}

