/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;
import net.time4j.format.CalendarText;
import net.time4j.format.TextWidth;

public enum ThaiSolarEra implements CalendarEra
{
    RATTANAKOSIN,
    BUDDHIST;


    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getInstance("buddhist", locale);
        return calendarText.getEras(textWidth).print(this);
    }

    public int getYear(CalendarDate calendarDate) {
        int n2;
        PlainDate plainDate = PlainDate.of(calendarDate.getDaysSinceEpochUTC(), EpochDays.UTC);
        if (this == RATTANAKOSIN) {
            n2 = plainDate.getYear() - 1781;
            if (plainDate.getMonth() < 4) {
                --n2;
            }
        } else {
            n2 = plainDate.getYear() + 543;
            if (n2 < 2484 && plainDate.getMonth() < 4) {
                --n2;
            }
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Out of range: " + calendarDate);
        }
        return n2;
    }

    int toIsoYear(int n2, int n3) {
        int n4;
        if (n2 < 1) {
            throw new IllegalArgumentException("Out of bounds: " + n2);
        }
        if (this == RATTANAKOSIN) {
            n4 = MathUtils.safeAdd(n2, 1781);
            if (n3 < 4) {
                n4 = MathUtils.safeAdd(n4, 1);
            }
        } else {
            n4 = MathUtils.safeSubtract(n2, 543);
            if (n3 < 4) {
                if (n4 == 1940) {
                    throw new IllegalArgumentException("Buddhist year 2483 does not know month: " + n3);
                }
                if (n4 < 1940) {
                    n4 = MathUtils.safeAdd(n4, 1);
                }
            }
        }
        return n4;
    }
}

