/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPX7;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.TextElement;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="julian")
public final class JulianCalendar
extends Calendrical<Unit, JulianCalendar>
implements LocalizedPatternSupport {
    private static final int YMAX = 999999999;
    private static final int OFFSET = 720200;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    public static final ChronoElement<HistoricDate> DATE = ChronoHistory.PROLEPTIC_JULIAN.date();
    @FormattableElement(format="G")
    public static final ChronoElement<HistoricEra> ERA = ChronoHistory.PROLEPTIC_JULIAN.era();
    @FormattableElement(format="y")
    public static final ChronoElement<Integer> YEAR_OF_ERA = ChronoHistory.PROLEPTIC_JULIAN.yearOfEra();
    @FormattableElement(format="M", alt="L")
    public static final TextElement<Integer> MONTH_OF_YEAR = ChronoHistory.PROLEPTIC_JULIAN.month();
    @FormattableElement(format="d")
    public static final ChronoElement<Integer> DAY_OF_MONTH = ChronoHistory.PROLEPTIC_JULIAN.dayOfMonth();
    @FormattableElement(format="D")
    public static final ChronoElement<Integer> DAY_OF_YEAR = new StdIntegerDateElement<JulianCalendar>("DAY_OF_YEAR", JulianCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final ChronoElement<Weekday> DAY_OF_WEEK = new StdWeekdayElement<JulianCalendar>(JulianCalendar.class, JulianCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<JulianCalendar> WIM_ELEMENT = new WeekdayInMonthElement<JulianCalendar>(JulianCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<JulianCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final EraYearMonthDaySystem<JulianCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, JulianCalendar> ENGINE;
    private static final long serialVersionUID = 3038883058279104976L;
    private final transient int prolepticYear;
    private final transient int month;
    private final transient int dom;

    private JulianCalendar(int n2, int n3, int n4) {
        this.prolepticYear = n2;
        this.month = n3;
        this.dom = n4;
    }

    public static JulianCalendar of(HistoricEra historicEra, int n2, int n3, int n4) {
        if (historicEra == null) {
            throw new NullPointerException("Missing Julian era.");
        }
        if (!CALSYS.isValid(historicEra, n2, n3, n4)) {
            throw new IllegalArgumentException("Out of bounds: " + JulianCalendar.toString(historicEra, n2, n3, n4));
        }
        if (historicEra == HistoricEra.AD) {
            return new JulianCalendar(n2, n3, n4);
        }
        return new JulianCalendar(MathUtils.safeSubtract(1, n2), n3, n4);
    }

    public static JulianCalendar of(HistoricEra historicEra, int n2, Month month, int n3) {
        return JulianCalendar.of(historicEra, n2, month.getValue(), n3);
    }

    public static JulianCalendar nowInSystemTime() {
        return (JulianCalendar)SystemClock.inLocalView().now(JulianCalendar.axis());
    }

    public HistoricEra getEra() {
        return this.prolepticYear >= 1 ? HistoricEra.AD : HistoricEra.BC;
    }

    public int getYear() {
        return this.prolepticYear >= 1 ? this.prolepticYear : MathUtils.safeSubtract(1, this.prolepticYear);
    }

    public Month getMonth() {
        return Month.valueOf(this.month);
    }

    public int getDayOfMonth() {
        return this.dom;
    }

    public Weekday getDayOfWeek() {
        long l2 = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l2 + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return JulianCalendar.lengthOfMonth(this.prolepticYear, this.month);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.prolepticYear % 4 == 0;
    }

    public static boolean isValid(HistoricEra historicEra, int n2, int n3, int n4) {
        return CALSYS.isValid(historicEra, n2, n3, n4);
    }

    public GeneralTimestamp<JulianCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<JulianCalendar> atTime(int n2, int n3) {
        return this.at(PlainTime.of(n2, n3));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JulianCalendar) {
            JulianCalendar julianCalendar = (JulianCalendar)object;
            return this.dom == julianCalendar.dom && this.month == julianCalendar.month && this.prolepticYear == julianCalendar.prolepticYear;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.dom + 31 * this.month + 37 * this.prolepticYear;
    }

    @Override
    public String toString() {
        return JulianCalendar.toString(this.getEra(), this.getYear(), this.month, this.dom);
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1);
    }

    public static TimeAxis<Unit, JulianCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, JulianCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected JulianCalendar getContext() {
        return this;
    }

    int getProlepticYear() {
        return this.prolepticYear;
    }

    private static String toString(CalendarEra calendarEra, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("JULIAN-");
        stringBuilder.append(calendarEra.name());
        stringBuilder.append('-');
        String string = String.valueOf(n2);
        for (int i2 = string.length(); i2 < 4; ++i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append('-');
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        return stringBuilder.toString();
    }

    private static int lengthOfMonth(int n2, int n3) {
        switch (n3) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return n2 % 4 == 0 ? 29 : 28;
            }
        }
        return 31;
    }

    private Object writeReplace() {
        return new SPX7(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, JulianCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)DATE, (ElementRule)new DateRule())).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<JulianCalendar>(JulianCalendar.getDefaultWeekmodel(), julianCalendar -> CALSYS), Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<JulianCalendar>(CALSYS, DAY_OF_YEAR))).appendUnit(Unit.YEARS, new JulianUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit(Unit.MONTHS, new JulianUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.WEEKS, new JulianUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new JulianUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension(new CommonElements.Weekengine(JulianCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, JulianCalendar.getDefaultWeekmodel()));
        ENGINE = ((TimeAxis.Builder)builder).build();
    }

    private static class Transformer
    implements EraYearMonthDaySystem<JulianCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n2, int n3, int n4) {
            int n5;
            if (calendarEra == HistoricEra.AD) {
                n5 = n2;
            } else if (calendarEra == HistoricEra.BC) {
                n5 = MathUtils.safeSubtract(1, n2);
            } else {
                return false;
            }
            if (n2 < 1 || n2 > 999999999 || n3 < 1 || n3 > 12 || n4 < 1) {
                return false;
            }
            return n4 <= JulianCalendar.lengthOfMonth(n5, n3);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n2, int n3) {
            int n4;
            if (calendarEra == HistoricEra.AD) {
                n4 = n2;
            } else if (calendarEra == HistoricEra.BC) {
                n4 = MathUtils.safeSubtract(1, n2);
            } else {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n2 >= 1 && n2 <= 999999999 && n3 >= 1 && n3 <= 12) {
                return JulianCalendar.lengthOfMonth(n4, n3);
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n2 + ", month=" + n3);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n2) {
            int n3;
            if (calendarEra == HistoricEra.AD) {
                n3 = n2;
            } else if (calendarEra == HistoricEra.BC) {
                n3 = MathUtils.safeSubtract(1, n2);
            } else {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n2 >= 1 && n2 <= 999999999) {
                return n3 % 4 == 0 ? 366 : 365;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n2);
        }

        @Override
        public JulianCalendar transform(long l2) {
            try {
                int n2;
                int n3;
                int n4;
                long l3;
                long l4 = MathUtils.safeAdd(l2, 720200L);
                long l5 = MathUtils.floorDivide(l4, 1461);
                int n5 = MathUtils.floorModulo(l4, 1461);
                if (n5 == 1460) {
                    l3 = (l5 + 1L) * 4L;
                    n4 = 2;
                    n3 = 29;
                } else {
                    int n6 = n5 / 365;
                    n2 = n5 % 365;
                    l3 = l5 * 4L + (long)n6;
                    n4 = (n2 + 31) * 5 / 153 + 2;
                    n3 = n2 - (n4 + 1) * 153 / 5 + 123;
                    if (n4 > 12) {
                        ++l3;
                        n4 -= 12;
                    }
                }
                HistoricEra historicEra = l3 >= 1L ? HistoricEra.AD : HistoricEra.BC;
                n2 = MathUtils.safeCast(l3 >= 1L ? l3 : MathUtils.safeSubtract(1L, l3));
                return JulianCalendar.of(historicEra, n2, n4, n3);
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException(arithmeticException);
            }
        }

        @Override
        public long transform(JulianCalendar julianCalendar) {
            long l2 = julianCalendar.prolepticYear;
            int n2 = julianCalendar.month;
            if (n2 < 3) {
                --l2;
                n2 += 12;
            }
            long l3 = l2 * 365L + MathUtils.floorDivide(l2, 4) + (long)((n2 + 1) * 153 / 5) - 123L + (long)julianCalendar.dom;
            return l3 - 720200L;
        }

        @Override
        public long getMinimumSinceUTC() {
            JulianCalendar julianCalendar = new JulianCalendar(-999999998, 1, 1);
            return this.transform(julianCalendar);
        }

        @Override
        public long getMaximumSinceUTC() {
            JulianCalendar julianCalendar = new JulianCalendar(999999999, 12, 31);
            return this.transform(julianCalendar);
        }

        @Override
        public List<CalendarEra> getEras() {
            HistoricEra historicEra = HistoricEra.BC;
            HistoricEra historicEra2 = HistoricEra.AD;
            return Collections.unmodifiableList(Arrays.asList(historicEra, historicEra2));
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.15576E7),
        MONTHS(2629800.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d2) {
            this.length = d2;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public int between(JulianCalendar julianCalendar, JulianCalendar julianCalendar2) {
            return MathUtils.safeCast(julianCalendar.until(julianCalendar2, this));
        }
    }

    private static class Merger
    implements ChronoMerger<JulianCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return GenericDatePatterns.get("generic", formatStyle, locale);
        }

        @Override
        public JulianCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (JulianCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        public JulianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            int n2;
            if (!chronoEntity.contains(ERA)) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Julian era.");
                return null;
            }
            HistoricEra historicEra = chronoEntity.get(ERA);
            int n3 = chronoEntity.getInt(YEAR_OF_ERA);
            if (n3 == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Julian year.");
                return null;
            }
            int n4 = chronoEntity.getInt(MONTH_OF_YEAR);
            if (n4 != Integer.MIN_VALUE && (n2 = chronoEntity.getInt(DAY_OF_MONTH)) != Integer.MIN_VALUE) {
                if (CALSYS.isValid(historicEra, n3, n4, n2)) {
                    return JulianCalendar.of(historicEra, n3, n4, n2);
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Julian date.");
            }
            if ((n2 = chronoEntity.getInt(DAY_OF_YEAR)) != Integer.MIN_VALUE) {
                if (n2 > 0) {
                    int n5 = 1;
                    int n6 = historicEra == HistoricEra.AD ? n3 : MathUtils.safeSubtract(1, n3);
                    int n7 = 0;
                    while (n5 <= 12) {
                        int n8 = JulianCalendar.lengthOfMonth(n6, n5);
                        if (n2 > n7 + n8) {
                            ++n5;
                            n7 += n8;
                            continue;
                        }
                        return JulianCalendar.of(historicEra, n3, n5, n2 - n7);
                    }
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Julian date.");
            }
            return null;
        }
    }

    private static class DateRule
    implements ElementRule<JulianCalendar, HistoricDate> {
        private DateRule() {
        }

        @Override
        public HistoricDate getValue(JulianCalendar julianCalendar) {
            return HistoricDate.of(julianCalendar.getEra(), julianCalendar.getYear(), julianCalendar.month, julianCalendar.dom);
        }

        @Override
        public HistoricDate getMinimum(JulianCalendar julianCalendar) {
            return HistoricDate.of(HistoricEra.BC, 999999999, 1, 1);
        }

        @Override
        public HistoricDate getMaximum(JulianCalendar julianCalendar) {
            return HistoricDate.of(HistoricEra.AD, 999999999, 12, 31);
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, HistoricDate historicDate) {
            if (historicDate == null) {
                return false;
            }
            return CALSYS.isValid(historicDate.getEra(), historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, HistoricDate historicDate, boolean bl2) {
            if (historicDate == null) {
                throw new IllegalArgumentException("Missing historic date value.");
            }
            return JulianCalendar.of(historicDate.getEra(), historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return null;
        }
    }

    private static class EraRule
    implements ElementRule<JulianCalendar, HistoricEra> {
        private EraRule() {
        }

        @Override
        public HistoricEra getValue(JulianCalendar julianCalendar) {
            return julianCalendar.getEra();
        }

        @Override
        public HistoricEra getMinimum(JulianCalendar julianCalendar) {
            return HistoricEra.BC;
        }

        @Override
        public HistoricEra getMaximum(JulianCalendar julianCalendar) {
            return HistoricEra.AD;
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, HistoricEra historicEra) {
            return julianCalendar.getEra().equals(historicEra);
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, HistoricEra historicEra, boolean bl2) {
            if (!this.isValid(julianCalendar, historicEra)) {
                throw new IllegalArgumentException("Julian era cannot be changed.");
            }
            return julianCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class IntegerRule
    implements ElementRule<JulianCalendar, Integer> {
        private final int index;

        IntegerRule(int n2) {
            this.index = n2;
        }

        @Override
        public Integer getValue(JulianCalendar julianCalendar) {
            switch (this.index) {
                case 0: {
                    return julianCalendar.getYear();
                }
                case 2: {
                    return julianCalendar.dom;
                }
                case 3: {
                    int n2 = 0;
                    for (int i2 = 1; i2 < julianCalendar.month; ++i2) {
                        n2 += JulianCalendar.lengthOfMonth(julianCalendar.prolepticYear, i2);
                    }
                    return n2 + julianCalendar.dom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMinimum(JulianCalendar julianCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMaximum(JulianCalendar julianCalendar) {
            switch (this.index) {
                case 0: {
                    return 999999999;
                }
                case 2: {
                    return JulianCalendar.lengthOfMonth(julianCalendar.prolepticYear, julianCalendar.month);
                }
                case 3: {
                    return julianCalendar.prolepticYear % 4 == 0 ? 366 : 365;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, Integer n2) {
            if (n2 == null) {
                return false;
            }
            Integer n3 = this.getMinimum(julianCalendar);
            Integer n4 = this.getMaximum(julianCalendar);
            return n3.compareTo(n2) <= 0 && n4.compareTo(n2) >= 0;
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            switch (this.index) {
                case 0: {
                    int n3 = n2;
                    int n4 = julianCalendar.getEra() == HistoricEra.AD ? n3 : MathUtils.safeSubtract(1, n3);
                    int n5 = JulianCalendar.lengthOfMonth(n4, julianCalendar.month);
                    int n6 = Math.min(julianCalendar.dom, n5);
                    return JulianCalendar.of(julianCalendar.getEra(), n3, julianCalendar.month, n6);
                }
                case 2: {
                    return JulianCalendar.of(julianCalendar.getEra(), julianCalendar.getYear(), julianCalendar.month, (int)n2);
                }
                case 3: {
                    int n7 = n2;
                    if (n7 >= 1 && n7 <= julianCalendar.lengthOfYear()) {
                        int n8 = n2 - this.getValue(julianCalendar);
                        return (JulianCalendar)julianCalendar.plus(CalendarDays.of(n8));
                    }
                    throw new IllegalArgumentException("Invalid day of year: " + n2);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class MonthRule
    implements ElementRule<JulianCalendar, Integer> {
        private MonthRule() {
        }

        @Override
        public Integer getValue(JulianCalendar julianCalendar) {
            return julianCalendar.month;
        }

        @Override
        public Integer getMinimum(JulianCalendar julianCalendar) {
            return 1;
        }

        @Override
        public Integer getMaximum(JulianCalendar julianCalendar) {
            return 12;
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, Integer n2) {
            if (n2 == null) {
                return false;
            }
            int n3 = n2;
            return n3 >= 1 && n3 <= 12;
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n3 = n2;
            int n4 = JulianCalendar.lengthOfMonth(julianCalendar.prolepticYear, n3);
            int n5 = Math.min(julianCalendar.dom, n4);
            return new JulianCalendar(julianCalendar.prolepticYear, n3, n5);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class JulianUnitRule
    implements UnitRule<JulianCalendar> {
        private final Unit unit;

        JulianUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public JulianCalendar addTo(JulianCalendar julianCalendar, long l2) {
            switch (this.unit) {
                case YEARS: {
                    l2 = MathUtils.safeMultiply(l2, 12L);
                }
                case MONTHS: {
                    long l3 = MathUtils.safeAdd(JulianUnitRule.ymValue(julianCalendar), l2);
                    int n2 = MathUtils.safeCast(MathUtils.floorDivide(l3, 12));
                    int n3 = MathUtils.floorModulo(l3, 12) + 1;
                    int n4 = Math.min(julianCalendar.dom, JulianCalendar.lengthOfMonth(n2, n3));
                    HistoricEra historicEra = n2 >= 1 ? HistoricEra.AD : HistoricEra.BC;
                    int n5 = n2 >= 1 ? n2 : MathUtils.safeSubtract(1, n2);
                    return JulianCalendar.of(historicEra, n5, n3, n4);
                }
                case WEEKS: {
                    l2 = MathUtils.safeMultiply(l2, 7L);
                }
                case DAYS: {
                    long l4 = MathUtils.safeAdd(CALSYS.transform(julianCalendar), l2);
                    return (JulianCalendar)CALSYS.transform(l4);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(JulianCalendar julianCalendar, JulianCalendar julianCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return julianCalendar.until(julianCalendar2, Unit.MONTHS) / 12L;
                }
                case MONTHS: {
                    long l2 = JulianUnitRule.ymValue(julianCalendar2) - JulianUnitRule.ymValue(julianCalendar);
                    if (l2 > 0L && julianCalendar2.dom < julianCalendar.dom) {
                        --l2;
                    } else if (l2 < 0L && julianCalendar2.dom > julianCalendar.dom) {
                        ++l2;
                    }
                    return l2;
                }
                case WEEKS: {
                    return julianCalendar.until(julianCalendar2, Unit.DAYS) / 7L;
                }
                case DAYS: {
                    return CALSYS.transform(julianCalendar2) - CALSYS.transform(julianCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static long ymValue(JulianCalendar julianCalendar) {
            return (long)julianCalendar.prolepticYear * 12L + (long)julianCalendar.month - 1L;
        }
    }
}

