/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriEra;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum HijriMonth implements ChronoCondition<HijriCalendar>
{
    MUHARRAM,
    SAFAR,
    RABI_I,
    RABI_II,
    JUMADA_I,
    JUMADA_II,
    RAJAB,
    SHABAN,
    RAMADAN,
    SHAWWAL,
    DHU_AL_QIDAH,
    DHU_AL_HIJJAH;

    private static final HijriMonth[] ENUMS;

    public static HijriMonth valueOf(int n2) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return ENUMS[n2 - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("islamic", locale);
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(HijriCalendar hijriCalendar) {
        return hijriCalendar.getMonth() == this;
    }

    static {
        ENUMS = HijriMonth.values();
    }

    static class Operator
    implements ChronoOperator<HijriCalendar> {
        private final int steps;

        Operator(int n2) {
            this.steps = n2;
        }

        @Override
        public HijriCalendar apply(HijriCalendar hijriCalendar) {
            int n2 = hijriCalendar.getYear() * 12 + hijriCalendar.getMonth().getValue() - 1;
            int n3 = (n2 += this.steps) / 12;
            int n4 = n2 % 12 + 1;
            int n5 = hijriCalendar.getCalendarSystem().getLengthOfMonth(HijriEra.ANNO_HEGIRAE, n3, n4);
            int n6 = Math.min(hijriCalendar.getDayOfMonth(), n5);
            return HijriCalendar.of(hijriCalendar.getVariant(), n3, n4, n6);
        }
    }
}

