/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.engine.ChronoException;
import net.time4j.engine.VariantSource;

public final class HijriAdjustment
implements VariantSource {
    private final String baseVariant;
    private final int adjustment;

    private HijriAdjustment(String string, int n2) {
        if (n2 < -3 || n2 > 3) {
            throw new ChronoException("Day adjustment out of range -3 <= x <= 3: " + n2);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty variant.");
        }
        this.adjustment = n2;
        this.baseVariant = string;
    }

    public static HijriAdjustment ofUmalqura(int n2) {
        return new HijriAdjustment("islamic-umalqura", n2);
    }

    public static HijriAdjustment of(String string, int n2) {
        int n3 = string.indexOf(58);
        if (n3 == -1) {
            return new HijriAdjustment(string, n2);
        }
        return new HijriAdjustment(string.substring(0, n3), n2);
    }

    public static HijriAdjustment of(VariantSource variantSource, int n2) {
        return HijriAdjustment.of(variantSource.getVariant(), n2);
    }

    @Override
    public String getVariant() {
        if (this.adjustment == 0) {
            return this.baseVariant;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.baseVariant);
        stringBuilder.append(':');
        if (this.adjustment > 0) {
            stringBuilder.append('+');
        }
        stringBuilder.append(this.adjustment);
        return stringBuilder.toString();
    }

    public int getValue() {
        return this.adjustment;
    }

    String getBaseVariant() {
        return this.baseVariant;
    }

    static HijriAdjustment from(String string) {
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return new HijriAdjustment(string, 0);
        }
        try {
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            return new HijriAdjustment(string.substring(0, n2), n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ChronoException("Invalid day adjustment: " + string);
        }
    }
}

