/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.time4j.PlainDate;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.HijriAdjustment;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriData;
import net.time4j.calendar.HijriEra;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;
import net.time4j.format.expert.Iso8601Format;

final class AstronomicalHijriData
implements EraYearMonthDaySystem<HijriCalendar> {
    static final AstronomicalHijriData UMALQURA;
    private final String variant;
    private final int adjustment;
    private final String version;
    private final int minYear;
    private final int maxYear;
    private final long minUTC;
    private final long maxUTC;
    private final int[] lengthOfMonth;
    private final long[] firstOfMonth;

    AstronomicalHijriData(HijriData hijriData) {
        this.variant = "islamic-" + hijriData.name();
        this.adjustment = 0;
        this.version = hijriData.version();
        this.minYear = hijriData.minimumYear();
        this.maxYear = hijriData.maximumYear();
        if (this.maxYear < this.minYear) {
            throw new IllegalArgumentException("Maximum year before minimum year.");
        }
        if (hijriData.name().startsWith("islamic")) {
            throw new IllegalArgumentException("Name must not start with \"islamic\".");
        }
        this.minUTC = hijriData.firstGregorianDate().getDaysSinceEpochUTC();
        int n2 = (this.maxYear - this.minYear + 1) * 12;
        this.lengthOfMonth = new int[n2];
        this.firstOfMonth = new long[n2];
        long l2 = 0L;
        int n3 = 0;
        for (int i2 = this.minYear; i2 <= this.maxYear; ++i2) {
            for (int i3 = 1; i3 <= 12; ++i3) {
                int n4;
                this.lengthOfMonth[n3] = n4 = hijriData.lengthOfMonth(i2, i3);
                this.firstOfMonth[n3] = this.minUTC + l2;
                l2 += (long)n4;
                ++n3;
            }
        }
        this.maxUTC = this.minUTC + l2 - 1L;
    }

    AstronomicalHijriData(String string) throws IOException {
        HijriAdjustment hijriAdjustment = HijriAdjustment.from(string);
        this.variant = string;
        String string2 = hijriAdjustment.getBaseVariant();
        this.adjustment = hijriAdjustment.getValue();
        String string3 = "data/" + string2.replace('-', '_') + ".data";
        URI uRI = ResourceLoader.getInstance().locate("base", AstronomicalHijriData.class, string3);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            inputStream = ResourceLoader.getInstance().load(AstronomicalHijriData.class, string3, true);
        }
        try {
            int n2;
            int n3;
            Properties properties = new Properties();
            properties.load(inputStream);
            String string4 = properties.getProperty("type");
            if (!string2.equals(string4)) {
                throw new IOException("Wrong hijri variant: expected=" + string2 + ", found=" + string4);
            }
            this.version = properties.getProperty("version", "1.0");
            String string5 = properties.getProperty("iso-start", "");
            PlainDate plainDate = Iso8601Format.EXTENDED_CALENDAR_DATE.parse(string5);
            this.minUTC = plainDate.get(EpochDays.UTC);
            this.minYear = n3 = Integer.parseInt(properties.getProperty("min", "1"));
            this.maxYear = n2 = Integer.parseInt(properties.getProperty("max", "0"));
            int n4 = (n2 - n3 + 1) * 12;
            int[] nArray = new int[n4];
            long[] lArray = new long[n4];
            int n5 = 0;
            long l2 = this.minUTC;
            for (int i2 = n3; i2 <= n2; ++i2) {
                String string6 = properties.getProperty(String.valueOf(i2));
                if (string6 == null) {
                    throw new IOException("Wrong file format: " + string3 + " (missing year=" + i2 + ")");
                }
                String[] stringArray = string6.split(" ");
                for (int i3 = 0; i3 < Math.min(stringArray.length, 12); ++i3) {
                    nArray[n5] = Integer.parseInt(stringArray[i3]);
                    lArray[n5] = l2;
                    l2 += (long)nArray[n5];
                    ++n5;
                }
                if (stringArray.length >= 12) continue;
                int[] nArray2 = new int[n5];
                long[] lArray2 = new long[n5];
                System.arraycopy(nArray, 0, nArray2, 0, n5);
                System.arraycopy(lArray, 0, lArray2, 0, n5);
                nArray = nArray2;
                lArray = lArray2;
                break;
            }
            this.maxUTC = l2 - 1L;
            this.lengthOfMonth = nArray;
            this.firstOfMonth = lArray;
        }
        catch (NumberFormatException | ParseException exception) {
            throw new IOException("Wrong file format: " + string3, exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    @Override
    public HijriCalendar transform(long l2) {
        long l3 = Math.addExact(l2, (long)this.adjustment);
        int n2 = AstronomicalHijriData.search(l3, this.firstOfMonth);
        if (n2 >= 0 && (n2 < this.firstOfMonth.length - 1 || this.firstOfMonth[n2] + (long)this.lengthOfMonth[n2] > l3)) {
            int n3 = n2 / 12 + this.minYear;
            int n4 = n2 % 12 + 1;
            int n5 = (int)(l3 - this.firstOfMonth[n2] + 1L);
            return HijriCalendar.of(this.variant, n3, n4, n5);
        }
        throw new IllegalArgumentException("Out of range: " + l2);
    }

    @Override
    public long transform(HijriCalendar hijriCalendar) {
        if (!hijriCalendar.getVariant().equals(this.variant)) {
            throw new IllegalArgumentException("Given date does not belong to this calendar system: " + hijriCalendar + " (calendar variants are different).");
        }
        int n2 = (hijriCalendar.getYear() - this.minYear) * 12 + hijriCalendar.getMonth().getValue() - 1;
        return Math.subtractExact(this.firstOfMonth[n2] + (long)hijriCalendar.getDayOfMonth() - 1L, (long)this.adjustment);
    }

    @Override
    public long getMinimumSinceUTC() {
        return Math.subtractExact(this.minUTC, (long)this.adjustment);
    }

    @Override
    public long getMaximumSinceUTC() {
        return Math.subtractExact(this.maxUTC, (long)this.adjustment);
    }

    @Override
    public List<CalendarEra> getEras() {
        HijriEra hijriEra = HijriEra.ANNO_HEGIRAE;
        return Collections.singletonList(hijriEra);
    }

    @Override
    public boolean isValid(CalendarEra calendarEra, int n2, int n3, int n4) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE || n2 < this.minYear || n2 > this.maxYear || n3 < 1 || n3 > 12 || n4 < 1) {
            return false;
        }
        if ((n2 - this.minYear) * 12 + n3 - 1 >= this.lengthOfMonth.length) {
            return false;
        }
        return n4 <= this.getLengthOfMonth(calendarEra, n2, n3);
    }

    @Override
    public int getLengthOfMonth(CalendarEra calendarEra, int n2, int n3) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE) {
            throw new IllegalArgumentException("Wrong era: " + calendarEra);
        }
        int n4 = (n2 - this.minYear) * 12 + n3 - 1;
        if (n4 < 0 || n4 >= this.lengthOfMonth.length) {
            throw new IllegalArgumentException("Out of bounds: year=" + n2 + ", month=" + n3);
        }
        return this.lengthOfMonth[n4];
    }

    @Override
    public int getLengthOfYear(CalendarEra calendarEra, int n2) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE) {
            throw new IllegalArgumentException("Wrong era: " + calendarEra);
        }
        if (n2 < this.minYear || n2 > this.maxYear) {
            throw new IllegalArgumentException("Out of bounds: yearOfEra=" + n2);
        }
        int n3 = 0;
        for (int i2 = 1; i2 <= 12; ++i2) {
            int n4 = (n2 - this.minYear) * 12 + i2 - 1;
            if (n4 >= this.lengthOfMonth.length) {
                throw new IllegalArgumentException("Year range is not fully covered by underlying data: " + n2);
            }
            n3 += this.lengthOfMonth[n4];
        }
        return n3;
    }

    String getVersion() {
        return this.version;
    }

    private static int search(long l2, long[] lArray) {
        int n2 = 0;
        int n3 = lArray.length - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            if (lArray[n4] <= l2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2 - 1;
    }

    static {
        try {
            UMALQURA = new AstronomicalHijriData("islamic-umalqura");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

