/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.base;

public final class MathUtils {
    private MathUtils() {
    }

    public static int safeCast(long l2) {
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("Out of range: " + l2);
        }
        return (int)l2;
    }

    public static int safeAdd(int n2, int n3) {
        if (n3 == 0) {
            return n2;
        }
        long l2 = (long)n2 + (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Integer overflow: (");
            stringBuilder.append(n2);
            stringBuilder.append(',');
            stringBuilder.append(n3);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return (int)l2;
    }

    public static long safeAdd(long l2, long l3) {
        if (l3 == 0L) {
            return l2;
        }
        if (l3 > 0L ? l2 > Long.MAX_VALUE - l3 : l2 < Long.MIN_VALUE - l3) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Long overflow: (");
            stringBuilder.append(l2);
            stringBuilder.append(',');
            stringBuilder.append(l3);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return l2 + l3;
    }

    public static int safeSubtract(int n2, int n3) {
        if (n3 == 0) {
            return n2;
        }
        long l2 = (long)n2 - (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Integer overflow: (");
            stringBuilder.append(n2);
            stringBuilder.append(',');
            stringBuilder.append(n3);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return (int)l2;
    }

    public static long safeSubtract(long l2, long l3) {
        if (l3 == 0L) {
            return l2;
        }
        if (l3 > 0L ? l2 < Long.MIN_VALUE + l3 : l2 > Long.MAX_VALUE + l3) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Long overflow: (");
            stringBuilder.append(l2);
            stringBuilder.append(',');
            stringBuilder.append(l3);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return l2 - l3;
    }

    public static int safeMultiply(int n2, int n3) {
        if (n3 == 1) {
            return n2;
        }
        long l2 = (long)n2 * (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Integer overflow: (");
            stringBuilder.append(n2);
            stringBuilder.append(',');
            stringBuilder.append(n3);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return (int)l2;
    }

    public static long safeMultiply(long l2, long l3) {
        if (l3 == 1L) {
            return l2;
        }
        if (l3 > 0L ? l2 > Long.MAX_VALUE / l3 || l2 < Long.MIN_VALUE / l3 : (l3 < -1L ? l2 > Long.MIN_VALUE / l3 || l2 < Long.MAX_VALUE / l3 : l3 == -1L && l2 == Long.MIN_VALUE)) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Long overflow: (");
            stringBuilder.append(l2);
            stringBuilder.append(',');
            stringBuilder.append(l3);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return l2 * l3;
    }

    public static int safeNegate(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            throw new ArithmeticException("Not negatable: " + n2);
        }
        return -n2;
    }

    public static long safeNegate(long l2) {
        if (l2 == Long.MIN_VALUE) {
            throw new ArithmeticException("Not negatable: " + l2);
        }
        return -l2;
    }

    public static int floorDivide(int n2, int n3) {
        if (n2 >= 0) {
            return n2 / n3;
        }
        return (n2 + 1) / n3 - 1;
    }

    public static long floorDivide(long l2, int n2) {
        if (l2 >= 0L) {
            return l2 / (long)n2;
        }
        return (l2 + 1L) / (long)n2 - 1L;
    }

    public static int floorModulo(int n2, int n3) {
        return n2 - n3 * MathUtils.floorDivide(n2, n3);
    }

    public static int floorModulo(long l2, int n2) {
        long l3 = l2 - (long)n2 * MathUtils.floorDivide(l2, n2);
        return (int)l3;
    }
}

