/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DayOfWeek;
import java.util.Locale;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum Weekday implements ChronoCondition<GregorianDate>,
ChronoOperator<PlainDate>,
ThreetenAdapter
{
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;

    private static final Weekday[] ENUMS;

    public int getValue() {
        return this.ordinal() + 1;
    }

    public int getValue(Weekmodel weekmodel) {
        int n2 = weekmodel.getFirstDayOfWeek().ordinal();
        return (7 + this.ordinal() - n2) % 7 + 1;
    }

    public static Weekday[] values(Weekmodel weekmodel) {
        Weekday[] weekdayArray = new Weekday[7];
        Weekday weekday = weekmodel.getFirstDayOfWeek();
        for (int i2 = 0; i2 < 7; ++i2) {
            weekdayArray[i2] = weekday;
            weekday = weekday.next();
        }
        return weekdayArray;
    }

    public static Weekday valueOf(int n2) {
        if (n2 < 1 || n2 > 7) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return ENUMS[n2 - 1];
    }

    public static Weekday valueOf(int n2, Weekmodel weekmodel) {
        if (n2 < 1 || n2 > 7) {
            throw new IllegalArgumentException("Weekday out of range: " + n2);
        }
        int n3 = weekmodel.getFirstDayOfWeek().ordinal();
        return ENUMS[(n2 - 1 + n3) % 7];
    }

    public static Weekday valueOf(int n2, Month month, int n3) {
        return Weekday.valueOf(GregorianMath.getDayOfWeek(n2, month.getValue(), n3));
    }

    public Weekday next() {
        int n2 = this.ordinal() + 1;
        if (n2 == 7) {
            n2 = 0;
        }
        return ENUMS[n2];
    }

    public Weekday previous() {
        return this.roll(-1);
    }

    public Weekday roll(int n2) {
        return Weekday.valueOf((this.ordinal() + (n2 % 7 + 7)) % 7 + 1);
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return CalendarText.getIsoInstance(locale).getWeekdays(textWidth, outputContext).print(this);
    }

    public static Weekday parse(CharSequence charSequence, Locale locale, TextWidth textWidth, OutputContext outputContext) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Weekday weekday = CalendarText.getIsoInstance(locale).getWeekdays(textWidth, outputContext).parse(charSequence, parsePosition, Weekday.class);
        if (weekday == null) {
            throw new ParseException("Cannot parse: " + charSequence, parsePosition.getErrorIndex());
        }
        return weekday;
    }

    @Override
    public boolean test(GregorianDate gregorianDate) {
        int n2;
        int n3;
        int n4 = gregorianDate.getYear();
        return GregorianMath.getDayOfWeek(n4, n3 = gregorianDate.getMonth(), n2 = gregorianDate.getDayOfMonth()) == this.getValue();
    }

    @Override
    public DayOfWeek toTemporalAccessor() {
        return DayOfWeek.of(this.getValue());
    }

    public static Weekday from(DayOfWeek dayOfWeek) {
        return Weekday.valueOf(dayOfWeek.getValue());
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return (PlainDate)plainDate.with(PlainDate.DAY_OF_WEEK, this);
    }

    static {
        ENUMS = Weekday.values();
    }
}

