/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.DefaultUnitPatternProviderSPI;
import net.time4j.IsoUnit;
import net.time4j.Weekday;
import net.time4j.base.ResourceLoader;
import net.time4j.format.PluralCategory;
import net.time4j.format.RelativeTimeProvider;
import net.time4j.format.TextWidth;
import net.time4j.format.UnitPatternProvider;

final class UnitPatterns {
    private static final int MIN_LIST_INDEX = 2;
    private static final int MAX_LIST_INDEX = 7;
    private static final ConcurrentMap<Locale, UnitPatterns> CACHE = new ConcurrentHashMap<Locale, UnitPatterns>();
    private static final IsoUnit[] UNIT_IDS = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.WEEKS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.MILLIS, ClockUnit.MICROS, ClockUnit.NANOS};
    private static final UnitPatternProvider PROVIDER;
    private static final UnitPatternProvider FALLBACK;
    private final Locale locale;
    private final Map<IsoUnit, Map<TextWidth, Map<PluralCategory, String>>> patterns;
    private final Map<IsoUnit, Map<PluralCategory, String>> past;
    private final Map<IsoUnit, Map<PluralCategory, String>> future;
    private final Map<IsoUnit, Map<PluralCategory, String>> shortPast;
    private final Map<IsoUnit, Map<PluralCategory, String>> shortFuture;
    private final Map<Integer, Map<TextWidth, String>> list;
    private final String now;
    private final String yesterday;
    private final String today;
    private final String tomorrow;
    private final Map<Weekday, String> lastWeekdays;
    private final Map<Weekday, String> nextWeekdays;

    /*
     * Could not resolve type clashes
     */
    private UnitPatterns(Locale locale) {
        String string;
        Object object2;
        this.locale = locale;
        HashMap hashMap = new HashMap(10);
        HashMap hashMap2 = new HashMap(10);
        HashMap hashMap3 = new HashMap(10);
        HashMap hashMap4 = new HashMap(10);
        HashMap hashMap5 = new HashMap(10);
        HashMap hashMap6 = new HashMap(10);
        for (Object object2 : UNIT_IDS) {
            int n2;
            PluralCategory[] pluralCategoryArray2;
            Object object32;
            EnumMap enumMap = new EnumMap(TextWidth.class);
            for (Object object32 : TextWidth.values()) {
                pluralCategoryArray2 = new EnumMap<PluralCategory, String>(PluralCategory.class);
                Object object4 = PluralCategory.values();
                n2 = ((PluralCategory[])object4).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    PluralCategory pluralCategory = object4[i2];
                    pluralCategoryArray2.put((PluralCategory)pluralCategory, UnitPatterns.lookup(locale, (IsoUnit)object2, (TextWidth)((Object)object32), pluralCategory));
                }
                enumMap.put((TextWidth)((Object)object32), Collections.unmodifiableMap(pluralCategoryArray2));
            }
            hashMap.put((TextWidth[])object2, Collections.unmodifiableMap(enumMap));
            if (Character.isDigit(object2.getSymbol())) continue;
            EnumMap enumMap2 = new EnumMap(PluralCategory.class);
            for (PluralCategory[] pluralCategoryArray2 : PluralCategory.values()) {
                enumMap2.put((PluralCategory)pluralCategoryArray2, UnitPatterns.lookup(locale, (IsoUnit)object2, false, false, pluralCategoryArray2));
            }
            hashMap2.put((TextWidth[])object2, Collections.unmodifiableMap(enumMap2));
            EnumMap enumMap3 = new EnumMap(PluralCategory.class);
            for (Object object4 : PluralCategory.values()) {
                enumMap3.put((PluralCategory)((Object)object4), UnitPatterns.lookup(locale, (IsoUnit)object2, false, true, (PluralCategory)((Object)object4)));
            }
            hashMap5.put((TextWidth[])object2, Collections.unmodifiableMap(enumMap3));
            EnumMap enumMap4 = new EnumMap(PluralCategory.class);
            for (PluralCategory pluralCategory : PluralCategory.values()) {
                enumMap4.put(pluralCategory, UnitPatterns.lookup(locale, (IsoUnit)object2, true, false, pluralCategory));
            }
            hashMap3.put((TextWidth[])object2, Collections.unmodifiableMap(enumMap4));
            object32 = new EnumMap(PluralCategory.class);
            pluralCategoryArray2 = PluralCategory.values();
            int n3 = pluralCategoryArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                PluralCategory pluralCategory = pluralCategoryArray2[n2];
                object32.put(pluralCategory, UnitPatterns.lookup(locale, (IsoUnit)object2, true, true, pluralCategory));
            }
            hashMap6.put((TextWidth[])object2, Collections.unmodifiableMap(object32));
        }
        for (int i3 = 2; i3 <= 7; ++i3) {
            Integer n4 = i3;
            EnumMap<TextWidth, String> enumMap = new EnumMap<TextWidth, String>(TextWidth.class);
            for (TextWidth textWidth : TextWidth.values()) {
                enumMap.put(textWidth, UnitPatterns.lookup(locale, textWidth, n4));
            }
            hashMap4.put(n4, Collections.unmodifiableMap(enumMap));
        }
        this.patterns = Collections.unmodifiableMap(hashMap);
        this.past = Collections.unmodifiableMap(hashMap2);
        this.future = Collections.unmodifiableMap(hashMap3);
        this.shortPast = Collections.unmodifiableMap(hashMap5);
        this.shortFuture = Collections.unmodifiableMap(hashMap6);
        this.list = Collections.unmodifiableMap(hashMap4);
        String string2 = "";
        String string3 = "";
        object2 = "";
        EnumMap<Weekday, String> enumMap = new EnumMap<Weekday, String>(Weekday.class);
        EnumMap<Weekday, String> enumMap5 = new EnumMap<Weekday, String>(Weekday.class);
        for (PluralCategory[] pluralCategoryArray2 : Weekday.values()) {
            enumMap.put((Weekday)pluralCategoryArray2, "");
            enumMap5.put((Weekday)pluralCategoryArray2, "");
        }
        try {
            string = PROVIDER.getNowWord(locale);
            if (PROVIDER instanceof RelativeTimeProvider) {
                RelativeTimeProvider relativeTimeProvider = (RelativeTimeProvider)RelativeTimeProvider.class.cast(PROVIDER);
                string2 = relativeTimeProvider.getYesterdayWord(locale);
                string3 = relativeTimeProvider.getTodayWord(locale);
                object2 = relativeTimeProvider.getTomorrowWord(locale);
                for (Weekday weekday : Weekday.values()) {
                    enumMap.put(weekday, relativeTimeProvider.labelForLast(weekday, locale));
                    enumMap5.put(weekday, relativeTimeProvider.labelForNext(weekday, locale));
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            string = FALLBACK.getNowWord(locale);
        }
        this.now = string;
        this.yesterday = string2;
        this.today = string3;
        this.tomorrow = object2;
        this.lastWeekdays = Collections.unmodifiableMap(enumMap);
        this.nextWeekdays = Collections.unmodifiableMap(enumMap5);
    }

    static UnitPatterns of(Locale locale) {
        UnitPatterns unitPatterns;
        if (locale == null) {
            throw new NullPointerException("Missing language.");
        }
        UnitPatterns unitPatterns2 = (UnitPatterns)CACHE.get(locale);
        if (unitPatterns2 == null && (unitPatterns = CACHE.putIfAbsent(locale, unitPatterns2 = new UnitPatterns(locale))) != null) {
            unitPatterns2 = unitPatterns;
        }
        return unitPatterns2;
    }

    String getPattern(TextWidth textWidth, PluralCategory pluralCategory, IsoUnit isoUnit) {
        UnitPatterns.checkNull(textWidth, pluralCategory);
        return this.patterns.get(isoUnit).get((Object)textWidth).get((Object)pluralCategory);
    }

    String getPatternInPast(PluralCategory pluralCategory, boolean bl2, IsoUnit isoUnit) {
        UnitPatterns.checkNull(pluralCategory);
        if (bl2) {
            return this.shortPast.get(isoUnit).get((Object)pluralCategory);
        }
        return this.past.get(isoUnit).get((Object)pluralCategory);
    }

    String getPatternInFuture(PluralCategory pluralCategory, boolean bl2, IsoUnit isoUnit) {
        UnitPatterns.checkNull(pluralCategory);
        if (bl2) {
            return this.shortFuture.get(isoUnit).get((Object)pluralCategory);
        }
        return this.future.get(isoUnit).get((Object)pluralCategory);
    }

    String getNowWord() {
        return this.now;
    }

    String getYesterdayWord() {
        return this.yesterday;
    }

    String getTodayWord() {
        return this.today;
    }

    String getTomorrowWord() {
        return this.tomorrow;
    }

    String labelForLast(Weekday weekday) {
        return this.lastWeekdays.get(weekday);
    }

    String labelForNext(Weekday weekday) {
        return this.nextWeekdays.get(weekday);
    }

    String getListPattern(TextWidth textWidth, int n2) {
        if (textWidth == null) {
            throw new NullPointerException("Missing width.");
        }
        if (n2 >= 2 && n2 <= 7) {
            return this.list.get(n2).get((Object)textWidth);
        }
        return UnitPatterns.lookup(this.locale, textWidth, n2);
    }

    private static void checkNull(PluralCategory pluralCategory) {
        if (pluralCategory == null) {
            throw new NullPointerException("Missing plural category.");
        }
    }

    private static void checkNull(TextWidth textWidth, PluralCategory pluralCategory) {
        if (textWidth == null) {
            throw new NullPointerException("Missing text width.");
        }
        UnitPatterns.checkNull(pluralCategory);
    }

    private static char getID(IsoUnit isoUnit) {
        char c2 = isoUnit.getSymbol();
        if (isoUnit == ClockUnit.MINUTES) {
            return 'N';
        }
        return c2;
    }

    private static String lookup(Locale locale, IsoUnit isoUnit, TextWidth textWidth, PluralCategory pluralCategory) {
        try {
            return UnitPatterns.lookup(PROVIDER, locale, UnitPatterns.getID(isoUnit), textWidth, pluralCategory);
        }
        catch (MissingResourceException missingResourceException) {
            return UnitPatterns.lookup(FALLBACK, locale, UnitPatterns.getID(isoUnit), textWidth, pluralCategory);
        }
    }

    private static String lookup(UnitPatternProvider unitPatternProvider, Locale locale, char c2, TextWidth textWidth, PluralCategory pluralCategory) {
        switch (c2) {
            case 'Y': {
                return unitPatternProvider.getYearPattern(locale, textWidth, pluralCategory);
            }
            case 'M': {
                return unitPatternProvider.getMonthPattern(locale, textWidth, pluralCategory);
            }
            case 'W': {
                return unitPatternProvider.getWeekPattern(locale, textWidth, pluralCategory);
            }
            case 'D': {
                return unitPatternProvider.getDayPattern(locale, textWidth, pluralCategory);
            }
            case 'H': {
                return unitPatternProvider.getHourPattern(locale, textWidth, pluralCategory);
            }
            case 'N': {
                return unitPatternProvider.getMinutePattern(locale, textWidth, pluralCategory);
            }
            case 'S': {
                return unitPatternProvider.getSecondPattern(locale, textWidth, pluralCategory);
            }
            case '3': {
                return unitPatternProvider.getMilliPattern(locale, textWidth, pluralCategory);
            }
            case '6': {
                return unitPatternProvider.getMicroPattern(locale, textWidth, pluralCategory);
            }
            case '9': {
                return unitPatternProvider.getNanoPattern(locale, textWidth, pluralCategory);
            }
        }
        throw new UnsupportedOperationException("Unit-ID: " + c2);
    }

    private static String lookup(Locale locale, IsoUnit isoUnit, boolean bl2, boolean bl3, PluralCategory pluralCategory) {
        try {
            return UnitPatterns.lookup(PROVIDER, locale, UnitPatterns.getID(isoUnit), bl2, bl3, pluralCategory);
        }
        catch (MissingResourceException missingResourceException) {
            return UnitPatterns.lookup(FALLBACK, locale, UnitPatterns.getID(isoUnit), bl2, bl3, pluralCategory);
        }
    }

    private static String lookup(UnitPatternProvider unitPatternProvider, Locale locale, char c2, boolean bl2, boolean bl3, PluralCategory pluralCategory) {
        if (bl3 && unitPatternProvider instanceof RelativeTimeProvider) {
            RelativeTimeProvider relativeTimeProvider = (RelativeTimeProvider)RelativeTimeProvider.class.cast(unitPatternProvider);
            switch (c2) {
                case 'Y': {
                    return relativeTimeProvider.getShortYearPattern(locale, bl2, pluralCategory);
                }
                case 'M': {
                    return relativeTimeProvider.getShortMonthPattern(locale, bl2, pluralCategory);
                }
                case 'W': {
                    return relativeTimeProvider.getShortWeekPattern(locale, bl2, pluralCategory);
                }
                case 'D': {
                    return relativeTimeProvider.getShortDayPattern(locale, bl2, pluralCategory);
                }
                case 'H': {
                    return relativeTimeProvider.getShortHourPattern(locale, bl2, pluralCategory);
                }
                case 'N': {
                    return relativeTimeProvider.getShortMinutePattern(locale, bl2, pluralCategory);
                }
                case 'S': {
                    return relativeTimeProvider.getShortSecondPattern(locale, bl2, pluralCategory);
                }
            }
            throw new UnsupportedOperationException("Unit-ID: " + c2);
        }
        switch (c2) {
            case 'Y': {
                return unitPatternProvider.getYearPattern(locale, bl2, pluralCategory);
            }
            case 'M': {
                return unitPatternProvider.getMonthPattern(locale, bl2, pluralCategory);
            }
            case 'W': {
                return unitPatternProvider.getWeekPattern(locale, bl2, pluralCategory);
            }
            case 'D': {
                return unitPatternProvider.getDayPattern(locale, bl2, pluralCategory);
            }
            case 'H': {
                return unitPatternProvider.getHourPattern(locale, bl2, pluralCategory);
            }
            case 'N': {
                return unitPatternProvider.getMinutePattern(locale, bl2, pluralCategory);
            }
            case 'S': {
                return unitPatternProvider.getSecondPattern(locale, bl2, pluralCategory);
            }
        }
        throw new UnsupportedOperationException("Unit-ID: " + c2);
    }

    private static String lookup(Locale locale, TextWidth textWidth, int n2) {
        try {
            return PROVIDER.getListPattern(locale, textWidth, n2);
        }
        catch (MissingResourceException missingResourceException) {
            return FALLBACK.getListPattern(locale, textWidth, n2);
        }
    }

    static {
        FALLBACK = new FallbackProvider();
        UnitPatternProvider unitPatternProvider = null;
        Iterator<UnitPatternProvider> iterator = ResourceLoader.getInstance().services(UnitPatternProvider.class).iterator();
        if (iterator.hasNext()) {
            UnitPatternProvider unitPatternProvider2;
            unitPatternProvider = unitPatternProvider2 = iterator.next();
        }
        if (unitPatternProvider == null) {
            unitPatternProvider = new DefaultUnitPatternProviderSPI();
        }
        PROVIDER = unitPatternProvider;
    }

    private static class FallbackProvider
    implements UnitPatternProvider {
        private FallbackProvider() {
        }

        @Override
        public String getYearPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("year", "yr", "y", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("y");
        }

        @Override
        public String getMonthPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("month", "mth", "m", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("m");
        }

        @Override
        public String getWeekPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("week", "wk", "w", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("w");
        }

        @Override
        public String getDayPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("day", "day", "d", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("d");
        }

        @Override
        public String getHourPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("hour", "hr", "h", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("h");
        }

        @Override
        public String getMinutePattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("minute", "min", "m", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("min");
        }

        @Override
        public String getSecondPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("second", "sec", "s", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("s");
        }

        @Override
        public String getYearPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("year", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("y", bl2);
        }

        @Override
        public String getMonthPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("month", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("m", bl2);
        }

        @Override
        public String getWeekPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("week", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("w", bl2);
        }

        @Override
        public String getDayPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("day", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("d", bl2);
        }

        @Override
        public String getHourPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("hour", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("h", bl2);
        }

        @Override
        public String getMinutePattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("minute", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("min", bl2);
        }

        @Override
        public String getSecondPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getRelativeEnglishPattern("second", bl2, pluralCategory);
            }
            return FallbackProvider.getRelativePattern("s", bl2);
        }

        @Override
        public String getNowWord(Locale locale) {
            return "now";
        }

        private static String getEnglishPattern(String string, String string2, String string3, TextWidth textWidth, PluralCategory pluralCategory) {
            switch (textWidth) {
                case WIDE: {
                    return FallbackProvider.getPluralPattern(string, pluralCategory);
                }
                case ABBREVIATED: 
                case SHORT: {
                    return FallbackProvider.getPluralPattern(string2, pluralCategory);
                }
                case NARROW: {
                    return "{0}" + string3;
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }

        private static String getPluralPattern(String string, PluralCategory pluralCategory) {
            String string2 = pluralCategory == PluralCategory.ONE ? "" : "s";
            return "{0} " + string + string2;
        }

        private static String getUnitPattern(String string) {
            return "{0} " + string;
        }

        private static String getRelativeEnglishPattern(String string, boolean bl2, PluralCategory pluralCategory) {
            String string2;
            String string3 = string2 = pluralCategory == PluralCategory.ONE ? "" : "s";
            if (bl2) {
                return "in {0} " + string + string2;
            }
            return "{0} " + string + string2 + " ago";
        }

        private static String getRelativePattern(String string, boolean bl2) {
            return (bl2 ? "+" : "-") + "{0} " + string;
        }

        @Override
        public String getListPattern(Locale locale, TextWidth textWidth, int n2) {
            if (n2 < 2) {
                throw new IllegalArgumentException("Size must be greater than 1.");
            }
            StringBuilder stringBuilder = new StringBuilder(n2 * 5);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append('{');
                stringBuilder.append(i2);
                stringBuilder.append('}');
                if (i2 >= n2 - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getMilliPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("millisecond", "msec", "ms", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("ms");
        }

        @Override
        public String getMicroPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("microsecond", "\u00b5sec", "\u00b5s", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("\u00b5s");
        }

        @Override
        public String getNanoPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
            if (locale.getLanguage().equals("en")) {
                return FallbackProvider.getEnglishPattern("nanosecond", "nsec", "ns", textWidth, pluralCategory);
            }
            return FallbackProvider.getUnitPattern("ns");
        }
    }
}

