/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.Moment;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoUnit;
import net.time4j.scale.TimeScale;

public enum SI implements ChronoUnit
{
    SECONDS(1.0),
    NANOSECONDS(1.0E-9);

    private final double length;

    private SI(double d2) {
        this.length = d2;
    }

    public long between(Moment moment, Moment moment2) {
        Moment.check1972(moment);
        Moment.check1972(moment2);
        switch (this) {
            case SECONDS: {
                long l2 = moment2.getElapsedTime(TimeScale.UTC) - moment.getElapsedTime(TimeScale.UTC);
                if (l2 < 0L) {
                    if (moment2.getNanosecond() > moment.getNanosecond()) {
                        ++l2;
                    }
                } else if (l2 > 0L && moment2.getNanosecond() < moment.getNanosecond()) {
                    --l2;
                }
                return l2;
            }
            case NANOSECONDS: {
                return MathUtils.safeAdd(MathUtils.safeMultiply(MathUtils.safeSubtract(moment2.getElapsedTime(TimeScale.UTC), moment.getElapsedTime(TimeScale.UTC)), 1000000000L), (long)(moment2.getNanosecond() - moment.getNanosecond()));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public boolean isCalendrical() {
        return false;
    }
}

