/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.OverflowUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.SystemClock;
import net.time4j.UnitPatterns;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.TimeSpan;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.NumberSystem;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;
import net.time4j.format.TemporalFormatter;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.SymbolProviderSPI;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class PrettyTime {
    private static final NumberSymbolProvider NUMBER_SYMBOLS;
    private static final int MIO = 1000000;
    private static final ConcurrentMap<Locale, PrettyTime> LANGUAGE_MAP;
    private static final IsoUnit[] STD_UNITS;
    private static final IsoUnit[] TSP_UNITS;
    private static final Set<IsoUnit> SUPPORTED_UNITS;
    private static final long START_1972;
    private final PluralRules rules;
    private final Locale locale;
    private final TimeSource<?> refClock;
    private final NumberSystem numsys;
    private final char zeroDigit;
    private final String minusSign;
    private final IsoUnit emptyUnit;
    private final boolean weekToDays;
    private final boolean shortStyle;
    private final String stdListSeparator;
    private final String endListSeparator;

    private PrettyTime(Locale locale, TimeSource<?> timeSource, NumberSystem numberSystem, char c2, String string, IsoUnit isoUnit, boolean bl2, boolean bl3, String string2, String string3) {
        if (isoUnit == null) {
            throw new NullPointerException("Missing zero time unit.");
        }
        if (timeSource == null) {
            throw new NullPointerException("Missing reference clock.");
        }
        this.rules = PluralRules.of(locale, NumberType.CARDINALS);
        this.locale = locale;
        this.refClock = timeSource;
        this.numsys = numberSystem;
        this.zeroDigit = c2;
        this.emptyUnit = isoUnit;
        this.minusSign = string;
        this.weekToDays = bl2;
        this.shortStyle = bl3;
        this.stdListSeparator = string2;
        this.endListSeparator = string3;
    }

    public static PrettyTime of(Locale locale) {
        PrettyTime prettyTime;
        PrettyTime prettyTime2 = (PrettyTime)LANGUAGE_MAP.get(locale);
        if (prettyTime2 == null && (prettyTime = LANGUAGE_MAP.putIfAbsent(locale, prettyTime2 = new PrettyTime(locale, SystemClock.INSTANCE, NUMBER_SYMBOLS.getDefaultNumberSystem(locale), NUMBER_SYMBOLS.getZeroDigit(locale), NUMBER_SYMBOLS.getMinusSign(locale), ClockUnit.SECONDS, false, false, null, null))) != null) {
            prettyTime2 = prettyTime;
        }
        return prettyTime2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeSource<?> getReferenceClock() {
        return this.refClock;
    }

    public PrettyTime withReferenceClock(TimeSource<?> timeSource) {
        return new PrettyTime(this.locale, timeSource, this.numsys, this.zeroDigit, this.minusSign, this.emptyUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withNumerals(NumberSystem numberSystem) {
        return new PrettyTime(this.locale, this.refClock, numberSystem, numberSystem.isDecimal() ? numberSystem.getDigits().charAt(0) : this.zeroDigit, this.minusSign, this.emptyUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    @Deprecated
    public PrettyTime withZeroDigit(NumberSystem numberSystem) {
        if (numberSystem.isDecimal()) {
            return this.withZeroDigit(numberSystem.getDigits().charAt(0));
        }
        throw new IllegalArgumentException("Number system is not decimal: " + (Object)((Object)numberSystem));
    }

    public PrettyTime withZeroDigit(char c2) {
        if (this.zeroDigit == c2) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, null, c2, this.minusSign, this.emptyUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withMinusSign(String string) {
        if (string.equals(this.minusSign)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, string, this.emptyUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withEmptyUnit(CalendarUnit calendarUnit) {
        if (this.emptyUnit.equals(calendarUnit)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, this.minusSign, calendarUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withEmptyUnit(ClockUnit clockUnit) {
        if (this.emptyUnit.equals(clockUnit)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, this.minusSign, clockUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withWeeksToDays() {
        if (this.weekToDays) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, this.minusSign, this.emptyUnit, true, this.shortStyle, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withShortStyle() {
        if (this.shortStyle) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, this.minusSign, this.emptyUnit, this.weekToDays, true, this.stdListSeparator, this.endListSeparator);
    }

    public PrettyTime withDefaultListSeparator(String string) {
        if (string.equals(this.stdListSeparator)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, this.minusSign, this.emptyUnit, this.weekToDays, this.shortStyle, string, this.endListSeparator);
    }

    public PrettyTime withLastListSeparator(String string) {
        if (string.equals(this.endListSeparator)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.numsys, this.zeroDigit, this.minusSign, this.emptyUnit, this.weekToDays, this.shortStyle, this.stdListSeparator, string);
    }

    public String printYesterday() {
        return UnitPatterns.of(this.getLocale()).getYesterdayWord();
    }

    public String printToday() {
        return UnitPatterns.of(this.getLocale()).getTodayWord();
    }

    public String printTomorrow() {
        return UnitPatterns.of(this.getLocale()).getTomorrowWord();
    }

    public String printLast(Weekday weekday) {
        return UnitPatterns.of(this.getLocale()).labelForLast(weekday);
    }

    public String printNext(Weekday weekday) {
        return UnitPatterns.of(this.getLocale()).labelForNext(weekday);
    }

    public String print(long l2, CalendarUnit calendarUnit, TextWidth textWidth) {
        CalendarUnit calendarUnit2;
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        switch (calendarUnit) {
            case MILLENNIA: {
                l2 = MathUtils.safeMultiply(l2, 1000L);
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case CENTURIES: {
                l2 = MathUtils.safeMultiply(l2, 100L);
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case DECADES: {
                l2 = MathUtils.safeMultiply(l2, 10L);
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case YEARS: {
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case QUARTERS: {
                l2 = MathUtils.safeMultiply(l2, 3L);
                calendarUnit2 = CalendarUnit.MONTHS;
                break;
            }
            case MONTHS: {
                calendarUnit2 = CalendarUnit.MONTHS;
                break;
            }
            case WEEKS: {
                if (this.weekToDays) {
                    l2 = MathUtils.safeMultiply(l2, 7L);
                    calendarUnit2 = CalendarUnit.DAYS;
                    break;
                }
                calendarUnit2 = CalendarUnit.WEEKS;
                break;
            }
            case DAYS: {
                calendarUnit2 = CalendarUnit.DAYS;
                break;
            }
            default: {
                throw new UnsupportedOperationException(calendarUnit.name());
            }
        }
        String string = unitPatterns.getPattern(textWidth, this.getCategory(l2), calendarUnit2);
        return this.format(string, l2);
    }

    public String print(long l2, ClockUnit clockUnit, TextWidth textWidth) {
        String string = UnitPatterns.of(this.locale).getPattern(textWidth, this.getCategory(l2), clockUnit);
        return this.format(string, l2);
    }

    public String print(Duration<?> duration) {
        TextWidth textWidth = this.shortStyle ? TextWidth.ABBREVIATED : TextWidth.WIDE;
        return this.print(duration, textWidth, false, Integer.MAX_VALUE);
    }

    public String print(TemporalAmount temporalAmount) {
        return this.print(Duration.from(temporalAmount));
    }

    public String print(Duration<?> duration, TextWidth textWidth) {
        return this.print(duration, textWidth, false, Integer.MAX_VALUE);
    }

    public String print(TemporalAmount temporalAmount, TextWidth textWidth) {
        return this.print(Duration.from(temporalAmount), textWidth);
    }

    public String print(Duration<?> duration, TextWidth textWidth, boolean bl2, int n2) {
        String string;
        Object object;
        if (n2 < 1) {
            throw new IllegalArgumentException("Max length is invalid: " + n2);
        }
        if (duration.isEmpty()) {
            if (this.emptyUnit.isCalendrical()) {
                CalendarUnit calendarUnit = (CalendarUnit)CalendarUnit.class.cast(this.emptyUnit);
                return this.print(0L, calendarUnit, textWidth);
            }
            ClockUnit clockUnit = (ClockUnit)ClockUnit.class.cast(this.emptyUnit);
            return this.print(0L, clockUnit, textWidth);
        }
        boolean bl3 = duration.isNegative();
        long[] lArray = new long[8];
        PrettyTime.pushDuration(lArray, duration, this.refClock, this.weekToDays);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (n3 >= n2 || this.weekToDays && i2 == 2 || (!bl2 || n3 <= 0) && lArray[i2] <= 0L) continue;
            object = i2 == 7 ? ClockUnit.NANOS : STD_UNITS[i2];
            arrayList.add(this.format(lArray[i2], (IsoUnit)object, bl3, textWidth));
            ++n3;
        }
        assert (n3 > 0);
        if (n3 == 1) {
            return arrayList.get(0).toString();
        }
        if (this.stdListSeparator != null) {
            object = this.endListSeparator;
            if (object == null) {
                object = this.stdListSeparator;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{0}");
            int n4 = n3 - 1;
            for (int i3 = 1; i3 < n4; ++i3) {
                stringBuilder.append(this.stdListSeparator);
                stringBuilder.append('{');
                stringBuilder.append(i3);
                stringBuilder.append('}');
            }
            stringBuilder.append((String)object);
            stringBuilder.append('{');
            stringBuilder.append(n4);
            stringBuilder.append('}');
            string = stringBuilder.toString();
        } else {
            string = UnitPatterns.of(this.locale).getListPattern(textWidth, n3);
        }
        return MessageFormat.format(string, arrayList.toArray(new Object[n3]));
    }

    public String print(TemporalAmount temporalAmount, TextWidth textWidth, boolean bl2, int n2) {
        return this.print(Duration.from(temporalAmount), textWidth, bl2, n2);
    }

    public String printRelativeInStdTimezone(UnixTime unixTime) {
        return this.printRelative(unixTime, Timezone.ofSystem(), TimeUnit.SECONDS);
    }

    public String printRelative(UnixTime unixTime, TZID tZID) {
        return this.printRelative(unixTime, Timezone.of(tZID), TimeUnit.SECONDS);
    }

    public String printRelative(UnixTime unixTime, String string) {
        return this.printRelative(unixTime, Timezone.of(string), TimeUnit.SECONDS);
    }

    public String printRelative(ZonedDateTime zonedDateTime) {
        return this.printRelative(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public String printRelative(Instant instant, ZoneId zoneId) {
        return this.printRelative(Moment.from(instant), Timezone.of(zoneId.getId()), TimeUnit.SECONDS);
    }

    public String printRelative(UnixTime unixTime, Timezone timezone, TimeUnit timeUnit) {
        long l2;
        Object obj = this.getReferenceClock().currentTime();
        Moment moment = Moment.from(obj);
        Moment moment2 = Moment.from(unixTime);
        if (timeUnit.compareTo(TimeUnit.SECONDS) <= 0 && Math.abs(l2 = moment.until(moment2, TimeUnit.SECONDS)) < 60L) {
            return this.printRelativeSeconds(moment, moment2, l2);
        }
        return this.printRelativeTime(moment, moment2, timezone, timeUnit, null, null);
    }

    public String printRelativeOrDateTime(UnixTime unixTime, Timezone timezone, TimeUnit timeUnit, long l2, TemporalFormatter<Moment> temporalFormatter) {
        Moment moment;
        Object obj = this.getReferenceClock().currentTime();
        Moment moment2 = Moment.from(obj);
        long l3 = moment2.until(moment = Moment.from(unixTime), TimeUnit.SECONDS);
        if (Math.abs(l3) > l2) {
            return temporalFormatter.format(moment);
        }
        if (timeUnit.compareTo(TimeUnit.SECONDS) <= 0 && Math.abs(l3) < 60L) {
            return this.printRelativeSeconds(moment2, moment, l3);
        }
        return this.printRelativeTime(moment2, moment, timezone, timeUnit, null, null);
    }

    public String printRelativeOrDateTime(UnixTime unixTime, Timezone timezone, TimeUnit timeUnit, CalendarUnit calendarUnit, TemporalFormatter<Moment> temporalFormatter) {
        if (calendarUnit == null) {
            throw new NullPointerException("Missing max relative unit.");
        }
        Object obj = this.getReferenceClock().currentTime();
        Moment moment = Moment.from(obj);
        Moment moment2 = Moment.from(unixTime);
        long l2 = moment.until(moment2, TimeUnit.SECONDS);
        if (timeUnit.compareTo(TimeUnit.SECONDS) <= 0 && Math.abs(l2) < 60L) {
            return this.printRelativeSeconds(moment, moment2, l2);
        }
        return this.printRelativeTime(moment, moment2, timezone, timeUnit, calendarUnit, temporalFormatter);
    }

    public String printRelativeOrDate(PlainDate plainDate, TZID tZID, CalendarUnit calendarUnit, TemporalFormatter<PlainDate> temporalFormatter) {
        String string;
        IsoUnit[] isoUnitArray;
        Duration duration;
        if (calendarUnit == null) {
            throw new NullPointerException("Missing max relative unit.");
        }
        Moment moment = Moment.from(this.getReferenceClock().currentTime());
        PlainDate plainDate2 = moment.toZonalTimestamp(tZID).toDate();
        if (this.weekToDays) {
            duration = Duration.inYearsMonthsDays().between(plainDate2, plainDate);
        } else {
            isoUnitArray = new CalendarUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.WEEKS, CalendarUnit.DAYS};
            duration = (Duration)Duration.in((IsoUnit[])isoUnitArray).between(plainDate2, plainDate);
        }
        if (duration.isEmpty()) {
            return this.getEmptyRelativeString(TimeUnit.DAYS);
        }
        isoUnitArray = duration.getTotalLength().get(0);
        long l2 = isoUnitArray.getAmount();
        CalendarUnit calendarUnit2 = (CalendarUnit)isoUnitArray.getUnit();
        if (Double.compare(calendarUnit2.getLength(), calendarUnit.getLength()) > 0) {
            return temporalFormatter.format(plainDate);
        }
        if (calendarUnit2.equals(CalendarUnit.DAYS) && !(string = this.getRelativeReplacement(plainDate, duration.isNegative(), l2)).isEmpty()) {
            return string;
        }
        string = duration.isNegative() ? this.getPastPattern(l2, calendarUnit2) : this.getFuturePattern(l2, calendarUnit2);
        return this.format(string, l2);
    }

    private String printRelativeSeconds(Moment moment, Moment moment2, long l2) {
        if (moment.getPosixTime() >= START_1972 && moment2.getPosixTime() >= START_1972) {
            l2 = SI.SECONDS.between(moment, moment2);
        }
        if (l2 == 0L) {
            return UnitPatterns.of(this.locale).getNowWord();
        }
        long l3 = Math.abs(l2);
        String string = l2 < 0L ? this.getPastPattern(l3, ClockUnit.SECONDS) : this.getFuturePattern(l3, ClockUnit.SECONDS);
        return this.format(string, l3);
    }

    private String printRelativeTime(Moment moment, Moment moment2, Timezone timezone, TimeUnit timeUnit, CalendarUnit calendarUnit, TemporalFormatter<Moment> temporalFormatter) {
        String string;
        PlainTimestamp plainTimestamp = PlainTimestamp.from(moment, timezone.getOffset(moment));
        PlainTimestamp plainTimestamp2 = PlainTimestamp.from(moment2, timezone.getOffset(moment2));
        IsoUnit[] isoUnitArray = this.weekToDays ? TSP_UNITS : STD_UNITS;
        Duration<IsoUnit> duration = Duration.in(timezone, isoUnitArray).between(plainTimestamp, plainTimestamp2);
        if (duration.isEmpty()) {
            return this.getEmptyRelativeString(timeUnit);
        }
        TimeSpan.Item<IsoUnit> item = duration.getTotalLength().get(0);
        long l2 = item.getAmount();
        IsoUnit isoUnit = item.getUnit();
        if (isoUnit instanceof ClockUnit) {
            if (5 - ((ClockUnit)isoUnit).ordinal() < timeUnit.ordinal()) {
                return this.getEmptyRelativeString(timeUnit);
            }
        } else {
            if (calendarUnit != null && Double.compare(isoUnit.getLength(), calendarUnit.getLength()) > 0) {
                return temporalFormatter.format(moment2);
            }
            if (isoUnit.equals(CalendarUnit.DAYS) && !(string = this.getRelativeReplacement(plainTimestamp2.toDate(), duration.isNegative(), l2)).isEmpty()) {
                return string;
            }
        }
        if (duration.isNegative()) {
            if (isoUnit.isCalendrical()) {
                assert (isoUnit instanceof CalendarUnit);
                string = this.getPastPattern(l2, (CalendarUnit)isoUnit);
            } else {
                assert (isoUnit instanceof ClockUnit);
                string = this.getPastPattern(l2, (ClockUnit)isoUnit);
            }
        } else if (isoUnit.isCalendrical()) {
            assert (isoUnit instanceof CalendarUnit);
            string = this.getFuturePattern(l2, (CalendarUnit)isoUnit);
        } else {
            assert (isoUnit instanceof ClockUnit);
            string = this.getFuturePattern(l2, (ClockUnit)isoUnit);
        }
        return this.format(string, l2);
    }

    private String getRelativeReplacement(PlainDate plainDate, boolean bl2, long l2) {
        if (l2 >= 1L && l2 <= 7L) {
            UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
            if (l2 == 1L) {
                return bl2 ? unitPatterns.getYesterdayWord() : unitPatterns.getTomorrowWord();
            }
            Weekday weekday = plainDate.getDayOfWeek();
            return bl2 ? unitPatterns.labelForLast(weekday) : unitPatterns.labelForNext(weekday);
        }
        return "";
    }

    private String getEmptyRelativeString(TimeUnit timeUnit) {
        String string;
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        if (timeUnit.equals((Object)TimeUnit.DAYS) && !(string = unitPatterns.getTodayWord()).isEmpty()) {
            return string;
        }
        return unitPatterns.getNowWord();
    }

    private String getPastPattern(long l2, CalendarUnit calendarUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l2);
        return unitPatterns.getPatternInPast(pluralCategory, this.shortStyle, calendarUnit);
    }

    private String getFuturePattern(long l2, CalendarUnit calendarUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l2);
        return unitPatterns.getPatternInFuture(pluralCategory, this.shortStyle, calendarUnit);
    }

    private String getPastPattern(long l2, ClockUnit clockUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l2);
        return unitPatterns.getPatternInPast(pluralCategory, this.shortStyle, clockUnit);
    }

    private String getFuturePattern(long l2, ClockUnit clockUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l2);
        return unitPatterns.getPatternInFuture(pluralCategory, this.shortStyle, clockUnit);
    }

    private PluralCategory getCategory(long l2) {
        return this.rules.getCategory(Math.abs(l2));
    }

    private static void pushDuration(long[] lArray, Duration<?> duration, TimeSource<?> timeSource, boolean bl2) {
        int n2 = duration.getTotalLength().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeSpan.Item<?> item = duration.getTotalLength().get(i2);
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            long l2 = item.getAmount();
            if (isoUnit instanceof CalendarUnit) {
                PrettyTime.push(lArray, (CalendarUnit)CalendarUnit.class.cast(isoUnit), l2, bl2);
                continue;
            }
            if (isoUnit instanceof ClockUnit) {
                PrettyTime.push(lArray, (ClockUnit)ClockUnit.class.cast(isoUnit), l2);
                continue;
            }
            if (isoUnit instanceof OverflowUnit) {
                PrettyTime.push(lArray, ((OverflowUnit)OverflowUnit.class.cast(isoUnit)).getCalendarUnit(), l2, bl2);
                continue;
            }
            if (isoUnit.equals(CalendarUnit.weekBasedYears())) {
                lArray[0] = MathUtils.safeAdd(l2, lArray[0]);
                continue;
            }
            Moment moment = Moment.from(timeSource.currentTime());
            PlainTimestamp plainTimestamp = moment.toZonalTimestamp(ZonalOffset.UTC);
            PlainTimestamp plainTimestamp2 = (PlainTimestamp)plainTimestamp.plus(l2, isoUnit);
            IsoUnit[] isoUnitArray = bl2 ? TSP_UNITS : STD_UNITS;
            Duration duration2 = (Duration)Duration.in((IsoUnit[])isoUnitArray).between(plainTimestamp, plainTimestamp2);
            PrettyTime.pushDuration(lArray, duration2, timeSource, bl2);
        }
    }

    private static void push(long[] lArray, CalendarUnit calendarUnit, long l2, boolean bl2) {
        int n2;
        switch (calendarUnit) {
            case MILLENNIA: {
                l2 = MathUtils.safeMultiply(l2, 1000L);
                n2 = 0;
                break;
            }
            case CENTURIES: {
                l2 = MathUtils.safeMultiply(l2, 100L);
                n2 = 0;
                break;
            }
            case DECADES: {
                l2 = MathUtils.safeMultiply(l2, 10L);
                n2 = 0;
                break;
            }
            case YEARS: {
                n2 = 0;
                break;
            }
            case QUARTERS: {
                l2 = MathUtils.safeMultiply(l2, 3L);
                n2 = 1;
                break;
            }
            case MONTHS: {
                n2 = 1;
                break;
            }
            case WEEKS: {
                if (bl2) {
                    l2 = MathUtils.safeMultiply(l2, 7L);
                    n2 = 3;
                    break;
                }
                n2 = 2;
                break;
            }
            case DAYS: {
                n2 = 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException(calendarUnit.name());
            }
        }
        lArray[n2] = MathUtils.safeAdd(l2, lArray[n2]);
    }

    private static void push(long[] lArray, ClockUnit clockUnit, long l2) {
        int n2;
        switch (clockUnit) {
            case HOURS: {
                n2 = 4;
                break;
            }
            case MINUTES: {
                n2 = 5;
                break;
            }
            case SECONDS: {
                n2 = 6;
                break;
            }
            case MILLIS: {
                l2 = MathUtils.safeMultiply(l2, 1000000L);
                n2 = 7;
                break;
            }
            case MICROS: {
                l2 = MathUtils.safeMultiply(l2, 1000L);
                n2 = 7;
                break;
            }
            case NANOS: {
                n2 = 7;
                break;
            }
            default: {
                throw new UnsupportedOperationException(clockUnit.name());
            }
        }
        lArray[n2] = MathUtils.safeAdd(l2, lArray[n2]);
    }

    private String format(long l2, IsoUnit isoUnit, boolean bl2, TextWidth textWidth) {
        long l3 = l2;
        if (bl2) {
            l3 = MathUtils.safeNegate(l2);
        }
        if (SUPPORTED_UNITS.contains(isoUnit)) {
            if (isoUnit.isCalendrical()) {
                CalendarUnit calendarUnit = (CalendarUnit)CalendarUnit.class.cast(isoUnit);
                return this.print(l3, calendarUnit, textWidth);
            }
            ClockUnit clockUnit = (ClockUnit)ClockUnit.class.cast(isoUnit);
            if (clockUnit == ClockUnit.NANOS) {
                if (l2 % 1000000L == 0L) {
                    clockUnit = ClockUnit.MILLIS;
                    l3 /= 1000000L;
                } else if (l2 % 1000L == 0L) {
                    clockUnit = ClockUnit.MICROS;
                    l3 /= 1000L;
                }
            }
            return this.print(l3, clockUnit, textWidth);
        }
        throw new UnsupportedOperationException("Unknown unit: " + isoUnit);
    }

    private String format(String string, long l2) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 >= n2 - 2 || string.charAt(i2) != '{' || string.charAt(i2 + 1) != '0' || string.charAt(i2 + 2) != '}') continue;
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.replace(i2, i2 + 3, this.format(l2));
            return stringBuilder.toString();
        }
        if (l2 < 0L) {
            return this.minusSign + string;
        }
        return string;
    }

    private String format(long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 < 0L) {
            stringBuilder.append(this.minusSign);
        }
        if (this.numsys == null || this.numsys.hasDecimalCodepoints()) {
            String string = String.valueOf(Math.abs(l2));
            char c2 = this.zeroDigit;
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                if (c2 != '0') {
                    c3 = (char)(c3 + c2 - 48);
                }
                stringBuilder.append(c3);
            }
        } else {
            stringBuilder.append(this.numsys.toNumeral(Math.toIntExact(Math.abs(l2))));
        }
        return stringBuilder.toString();
    }

    static {
        IsoUnit[] isoUnitArray = null;
        int n2 = 0;
        for (NumberSymbolProvider numberSymbolProvider : ResourceLoader.getInstance().services(NumberSymbolProvider.class)) {
            int n3 = numberSymbolProvider.getAvailableLocales().length;
            if (n3 < n2) continue;
            isoUnitArray = numberSymbolProvider;
            n2 = n3;
        }
        if (isoUnitArray == null) {
            isoUnitArray = SymbolProviderSPI.INSTANCE;
        }
        NUMBER_SYMBOLS = isoUnitArray;
        LANGUAGE_MAP = new ConcurrentHashMap<Locale, PrettyTime>();
        isoUnitArray = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.WEEKS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS};
        STD_UNITS = isoUnitArray;
        TSP_UNITS = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS};
        HashSet<ClockUnit> hashSet = new HashSet<ClockUnit>();
        Collections.addAll(hashSet, isoUnitArray);
        hashSet.add(ClockUnit.NANOS);
        SUPPORTED_UNITS = Collections.unmodifiableSet(hashSet);
        START_1972 = 63072000L;
    }
}

