/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.time4j.ClockUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.TemporalType;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalTransition;

final class OldApiTimezone
extends TimeZone {
    private static final long serialVersionUID = -6919910650419401271L;
    private final Timezone tz;

    OldApiTimezone(Timezone timezone) {
        this.tz = timezone;
        this.setID(timezone.getID().canonical());
        assert (timezone.getHistory() != null);
    }

    @Override
    public int getOffset(long l2) {
        return this.tz.getOffset(TemporalType.MILLIS_SINCE_UNIX.translate(l2)).getIntegralAmount() * 1000;
    }

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 < 0 || n7 >= 86400000) {
            throw new IllegalArgumentException("Milliseconds out of range: " + n7);
        }
        if (n2 == 0) {
            n3 = 1 - n3;
        } else {
            if (n2 != 1) {
                throw new IllegalArgumentException("Unknown era: " + n2);
            }
            if (n6 < 1 || n6 > 7) {
                throw new IllegalArgumentException("Day-of-week out of range: " + n6);
            }
        }
        return this.tz.getOffset(PlainDate.of(n3, n4 + 1, n5), PlainTime.midnightAtStartOfDay().plus((long)n7, ClockUnit.MILLIS)).getIntegralAmount() * 1000;
    }

    @Override
    public void setRawOffset(int n2) {
    }

    @Override
    public int getRawOffset() {
        return this.tz.getRawOffset(SystemClock.currentMoment()).getIntegralAmount() * 1000;
    }

    @Override
    public int getDSTSavings() {
        TransitionHistory transitionHistory = this.tz.getHistory();
        int n2 = Integer.MIN_VALUE;
        if (transitionHistory != null) {
            List<ZonalTransition> list = transitionHistory.getStdTransitions();
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                int n3 = list.get(i2).getExtraOffset();
                if (n2 == Integer.MIN_VALUE) {
                    n2 = n3;
                    continue;
                }
                if (n2 == n3) continue;
                return Math.max(n2, n3) * 1000;
            }
        }
        return n2 == Integer.MIN_VALUE ? 0 : n2 * 1000;
    }

    @Override
    public boolean useDaylightTime() {
        TransitionHistory transitionHistory;
        if (!this.tz.isFixed() && (transitionHistory = this.tz.getHistory()) != null) {
            List<ZonalTransition> list = transitionHistory.getStdTransitions();
            int n2 = Integer.MIN_VALUE;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                int n3 = list.get(i2).getExtraOffset();
                if (n2 == Integer.MIN_VALUE) {
                    n2 = n3;
                    continue;
                }
                if (n2 == n3) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return this.tz.isDaylightSaving(TemporalType.JAVA_UTIL_DATE.translate(date));
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone instanceof OldApiTimezone) {
            OldApiTimezone oldApiTimezone = (OldApiTimezone)timeZone;
            return this.tz.getHistory().equals(oldApiTimezone.tz.getHistory());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof OldApiTimezone) {
            OldApiTimezone oldApiTimezone = (OldApiTimezone)object;
            return this.tz.equals(oldApiTimezone.tz);
        }
        return false;
    }

    public int hashCode() {
        return this.tz.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.tz.toString();
    }

    Timezone getDelegate() {
        return this.tz;
    }
}

