/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.AdjustableElement;
import net.time4j.DateOperator;
import net.time4j.ElementOperator;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.ZonalQuery;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.DisplayElement;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

abstract class AbstractDateElement<V extends Comparable<V>>
extends DisplayElement<V>
implements AdjustableElement<V, PlainDate> {
    private final transient ElementOperator<PlainDate> minimizer = new DateOperator(this, 0);
    private final transient ElementOperator<PlainDate> maximizer = new DateOperator(this, 1);

    AbstractDateElement(String string) {
        super(string);
    }

    @Override
    public ElementOperator<PlainDate> newValue(V v2) {
        return new DateOperator(this, -1, v2);
    }

    @Override
    public ElementOperator<PlainDate> minimized() {
        return this.minimizer;
    }

    @Override
    public ElementOperator<PlainDate> maximized() {
        return this.maximizer;
    }

    @Override
    public ElementOperator<PlainDate> decremented() {
        return new DateOperator(this, 2);
    }

    @Override
    public ElementOperator<PlainDate> incremented() {
        return new DateOperator(this, 3);
    }

    @Override
    public ElementOperator<PlainDate> atFloor() {
        return new DateOperator(this, 4);
    }

    @Override
    public ElementOperator<PlainDate> atCeiling() {
        return new DateOperator(this, 5);
    }

    public ElementOperator<PlainDate> setLenient(V v2) {
        return new DateOperator(this, 6, v2);
    }

    @Override
    public ChronoFunction<Moment, V> inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    @Override
    public ChronoFunction<Moment, V> inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    @Override
    public ChronoFunction<Moment, V> in(Timezone timezone) {
        return new ZonalQuery(this, timezone);
    }

    @Override
    public ChronoFunction<Moment, V> atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    @Override
    public ChronoFunction<Moment, V> at(ZonalOffset zonalOffset) {
        return new ZonalQuery(this, zonalOffset);
    }
}

