/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.ExtensibleObject;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class StringUtil {
    private static final Pattern upperCasePattern = Pattern.compile(".*[A-Z].*");
    private static final Pattern lowerCasePattern = Pattern.compile(".*[a-z].*");
    private static final Pattern spacePattern = Pattern.compile(" ");
    private static final SecureRandom rnd = new SecureRandom();

    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.isEmpty()) {
            return null;
        }
        return returnString;
    }

    public static String[] processMultiLineSQL(String multiLineSQL, boolean stripComments, boolean splitStatements, String endDelimiter) {
        StringClauses parsed = SqlParser.parse(multiLineSQL, true, !stripComments);
        ArrayList<String> returnArray = new ArrayList<String>();
        StringBuilder currentString = new StringBuilder();
        String previousPiece = null;
        boolean previousDelimiter = false;
        List<Object> parsedArray = Arrays.asList(parsed.toArray(true));
        for (Object piece : StringUtil.mergeTokens(parsedArray, endDelimiter)) {
            if (splitStatements && piece instanceof String && StringUtil.isDelimiter((String)piece, previousPiece, endDelimiter)) {
                String trimmedString = StringUtil.trimToNull(currentString.toString());
                if (trimmedString != null) {
                    returnArray.add(trimmedString);
                }
                currentString = new StringBuilder();
                previousDelimiter = true;
            } else {
                if (!(previousDelimiter && StringUtil.trimToNull((String)piece) == null || currentString.length() <= 0 && StringUtil.trimToNull((String)piece) == null)) {
                    currentString.append(piece);
                }
                previousDelimiter = false;
            }
            previousPiece = (String)piece;
        }
        String trimmedString = StringUtil.trimToNull(currentString.toString());
        if (trimmedString != null) {
            returnArray.add(trimmedString);
        }
        return returnArray.toArray(new String[returnArray.size()]);
    }

    public static String[] processMutliLineSQL(String multiLineSQL, boolean stripComments, boolean splitStatements, String endDelimiter) {
        return StringUtil.processMultiLineSQL(multiLineSQL, stripComments, splitStatements, endDelimiter);
    }

    private static List<Object> mergeTokens(List<Object> parsedArray, String endDelimiter) {
        if (endDelimiter == null) {
            return parsedArray;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        ArrayList<String> possibleMerge = new ArrayList<String>();
        for (Object obj : parsedArray) {
            if (possibleMerge.size() == 0) {
                if (obj instanceof String && endDelimiter.startsWith((String)obj)) {
                    possibleMerge.add((String)obj);
                    continue;
                }
                returnList.add(obj);
                continue;
            }
            String possibleMergeString = StringUtil.join(possibleMerge, "") + obj.toString();
            if (endDelimiter.equals(possibleMergeString)) {
                returnList.add(possibleMergeString);
                possibleMerge.clear();
                continue;
            }
            if (endDelimiter.startsWith(possibleMergeString)) {
                possibleMerge.add(obj.toString());
                continue;
            }
            returnList.addAll(possibleMerge);
            returnList.add(obj);
            possibleMerge.clear();
        }
        return returnList;
    }

    protected static boolean isDelimiter(String piece, String previousPiece, String endDelimiter) {
        if (endDelimiter == null) {
            return ";".equals(piece) || ("go".equalsIgnoreCase(piece) || "/".equals(piece)) && (previousPiece == null || previousPiece.endsWith("\n"));
        }
        if (endDelimiter.length() == 1) {
            if ("/".equals(endDelimiter) && previousPiece != null && previousPiece.endsWith("*")) {
                return false;
            }
            return piece.toLowerCase().equalsIgnoreCase(endDelimiter.toLowerCase());
        }
        return piece.toLowerCase().matches(endDelimiter.toLowerCase()) || (previousPiece + piece).toLowerCase().matches("[\\s\n\r]*" + endDelimiter.toLowerCase());
    }

    public static String wrap(String inputStr, int wrapPoint, int extraLinePadding) {
        if (inputStr == null) {
            return null;
        }
        int inputLineLength = inputStr.length();
        int ptr = 0;
        int sizeOfMatch = -1;
        StringBuilder resultLine = new StringBuilder();
        while (ptr < inputLineLength) {
            int i2;
            int matcherStart;
            Integer spaceToWrapAt = null;
            int min2 = ptr + wrapPoint + 1;
            Matcher matcher = spacePattern.matcher(inputStr.substring(ptr, Math.min(min2, inputLineLength)));
            if (matcher.find()) {
                matcherStart = matcher.start();
                if (matcherStart == 0) {
                    sizeOfMatch = matcher.end();
                    if (sizeOfMatch != 0) {
                        ptr += sizeOfMatch;
                        continue;
                    }
                    ++ptr;
                }
                spaceToWrapAt = matcherStart + ptr;
            }
            if (inputLineLength - ptr <= wrapPoint) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + ptr;
            }
            if (spaceToWrapAt != null && spaceToWrapAt >= ptr) {
                resultLine.append(inputStr, ptr, (int)spaceToWrapAt);
                resultLine.append(System.lineSeparator());
                for (i2 = 0; i2 < extraLinePadding; ++i2) {
                    resultLine.append(" ");
                }
                ptr = spaceToWrapAt + 1;
                continue;
            }
            matcher = spacePattern.matcher(inputStr.substring(ptr + wrapPoint));
            if (matcher.find()) {
                matcherStart = matcher.start();
                sizeOfMatch = matcher.end() - matcherStart;
                spaceToWrapAt = matcherStart + ptr + wrapPoint;
            }
            if (sizeOfMatch == 0 && ptr != 0) {
                --ptr;
            }
            if (spaceToWrapAt != null && spaceToWrapAt >= 0) {
                resultLine.append(inputStr, ptr, (int)spaceToWrapAt);
                resultLine.append(System.lineSeparator());
                for (i2 = 0; i2 < extraLinePadding; ++i2) {
                    resultLine.append(" ");
                }
                ptr = spaceToWrapAt + 1;
                continue;
            }
            resultLine.append(inputStr, ptr, inputStr.length());
            ptr = inputLineLength;
            sizeOfMatch = -1;
        }
        if (sizeOfMatch == 0 && ptr < inputLineLength) {
            --ptr;
        }
        resultLine.append(inputStr, ptr, inputLineLength);
        return resultLine.toString();
    }

    public static String[] splitSQL(String multiLineSQL, String endDelimiter) {
        return StringUtil.processMultiLineSQL(multiLineSQL, false, true, endDelimiter);
    }

    public static String stripComments(String multiLineSQL) {
        return SqlParser.parse(multiLineSQL, true, false).toString().trim();
    }

    public static String join(Object[] array, String delimiter, StringUtilFormatter formatter) {
        if (array == null) {
            return null;
        }
        return StringUtil.join(Arrays.asList(array), delimiter, formatter);
    }

    public static String join(String[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        return StringUtil.join(Arrays.asList(array), delimiter);
    }

    public static String join(Collection<String> collection, String delimiter) {
        return StringUtil.join(collection, delimiter, (StringUtilFormatter)new ToStringFormatter());
    }

    public static String join(Collection collection, String delimiter, StringUtilFormatter formatter) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Object val : collection) {
            buffer.append(formatter.toString(val)).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static String join(Collection collection, String delimiter, StringUtilFormatter formatter, boolean sorted) {
        if (sorted) {
            TreeSet<String> sortedSet = new TreeSet<String>();
            for (Object obj : collection) {
                sortedSet.add(formatter.toString(obj));
            }
            return StringUtil.join(sortedSet, delimiter);
        }
        return StringUtil.join(collection, delimiter, formatter);
    }

    public static String join(Collection<String> collection, String delimiter, boolean sorted) {
        if (sorted) {
            return StringUtil.join(new TreeSet<String>(collection), delimiter);
        }
        return StringUtil.join(collection, delimiter);
    }

    public static String join(Map map, String delimiter) {
        return StringUtil.join(map, delimiter, (StringUtilFormatter)new ToStringFormatter());
    }

    public static String join(Map map, String delimiter, StringUtilFormatter formatter) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(entry.getKey().toString() + "=" + formatter.toString(entry.getValue()));
        }
        return StringUtil.join(list, delimiter);
    }

    public static String join(ExtensibleObject extensibleObject, String delimiter) {
        return StringUtil.join(extensibleObject, delimiter, (StringUtilFormatter)new ToStringFormatter());
    }

    public static String join(ExtensibleObject extensibleObject, String delimiter, StringUtilFormatter formatter) {
        ArrayList<String> list = new ArrayList<String>();
        for (String attribute : new TreeSet<String>(extensibleObject.getAttributes())) {
            String formattedValue = formatter.toString(extensibleObject.get(attribute, Object.class));
            if (formattedValue == null) continue;
            list.add(attribute + "=" + formattedValue);
        }
        return StringUtil.join(list, delimiter);
    }

    public static List<String> splitAndTrim(String s2, String regex) {
        if (s2 == null) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String string : s2.split(regex)) {
            returnList.add(string.trim());
        }
        return returnList;
    }

    public static String repeat(String string, int times) {
        StringBuilder result = new StringBuilder(string.length() * times);
        for (int i2 = 0; i2 < times; ++i2) {
            result.append(string);
        }
        return result.toString();
    }

    public static String join(Integer[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        int[] ints = new int[array.length];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            ints[i2] = array[i2];
        }
        return StringUtil.join(ints, delimiter);
    }

    public static String join(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int val : array) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static String indent(String string) {
        return StringUtil.indent(string, 4);
    }

    public static String indent(String string, int padding) {
        if (string == null) {
            return null;
        }
        String pad = StringUtil.repeat(" ", padding);
        return pad + string.replaceAll("\n", "\n" + pad);
    }

    public static String lowerCaseFirst(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string.toLowerCase();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String upperCaseFirst(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static boolean hasUpperCase(String string) {
        if (string == null) {
            return false;
        }
        return upperCasePattern.matcher(string).matches();
    }

    public static boolean hasLowerCase(String string) {
        if (string == null) {
            return false;
        }
        return lowerCasePattern.matcher(string).matches();
    }

    public static String standardizeLineEndings(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\r\n", "\n").replace("\r", "\n");
    }

    public static boolean isAscii(String string) {
        if (string == null) {
            return true;
        }
        for (char c2 : string.toCharArray()) {
            if (StringUtil.isAscii(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char ch2) {
        return ch2 < '\u0080';
    }

    public static String escapeHtml(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 > '\u007f') {
                out.append("&#");
                out.append(Integer.toString(c2, 10));
                out.append(';');
                continue;
            }
            out.append(c2);
        }
        return out.toString();
    }

    public static String pad(String value, int length) {
        if ((value = StringUtil.trimToEmpty(value)).length() >= length) {
            return value;
        }
        return value + StringUtil.repeat(" ", length - value.length());
    }

    public static String leftPad(String value, int length) {
        if ((value = StringUtil.trimToEmpty(value)).length() >= length) {
            return value;
        }
        return StringUtil.repeat(" ", length - value.length()) + value;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtil.isEmpty(value);
    }

    public static boolean startsWith(String value, String startsWith) {
        if (value == null || startsWith == null) {
            return false;
        }
        return value.startsWith(startsWith);
    }

    public static boolean isWhitespace(CharSequence string) {
        if (string == null) {
            return true;
        }
        return StringUtil.trimToNull(string.toString()) == null;
    }

    public static boolean isMinimumVersion(String minimumVersion, int candidateMajor, int candidateMinor, int candidatePatch) {
        int minPatch;
        if (minimumVersion == null) {
            return true;
        }
        String[] parts = minimumVersion.split("\\.", 3);
        int minMajor = Integer.parseInt(parts[0]);
        int minMinor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        int n2 = minPatch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        if (minMajor > candidateMajor) {
            return false;
        }
        if (minMajor == candidateMajor && minMinor > candidateMinor) {
            return false;
        }
        return minMajor != candidateMajor || minMinor != candidateMinor || minPatch <= candidatePatch;
    }

    public static String limitSize(String string, int maxLength) {
        if (string == null) {
            return null;
        }
        if (string.length() > maxLength) {
            return string.substring(0, maxLength - 3) + "...";
        }
        return string;
    }

    public static String randomIdentifer(int len) {
        String AB = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder sb = new StringBuilder(len);
        for (int i2 = 0; i2 < len; ++i2) {
            sb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rnd.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZ".length())));
        }
        return sb.toString();
    }

    public static String toKabobCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 1) {
            return string;
        }
        StringBuilder outString = new StringBuilder();
        char[] charString = string.toCharArray();
        for (int i2 = 0; i2 < charString.length; ++i2) {
            char letter = charString[i2];
            if (i2 == 0) {
                outString.append(Character.toLowerCase(letter));
                continue;
            }
            if (Character.isUpperCase(letter)) {
                outString.append('-').append(Character.toLowerCase(letter));
                continue;
            }
            outString.append(letter);
        }
        return outString.toString();
    }

    public static String toCamelCase(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder outString = new StringBuilder();
        char[] charString = string.toCharArray();
        boolean uppercaseNext = false;
        for (char letter : charString) {
            if (letter == '-' || letter == '_') {
                uppercaseNext = true;
                continue;
            }
            if (uppercaseNext) {
                outString.append(Character.toUpperCase(letter));
                uppercaseNext = false;
                continue;
            }
            outString.append(letter);
        }
        return outString.toString();
    }

    public static boolean equalsIgnoreCaseAndEmpty(String s1, String s2) {
        String clean1 = StringUtil.trimToNull(s1);
        String clean2 = StringUtil.trimToNull(s2);
        if (clean1 == null && clean2 == null) {
            return true;
        }
        if (clean1 == null || clean2 == null) {
            return false;
        }
        return clean1.equalsIgnoreCase(clean2);
    }

    public static String trimRight(String string) {
        int i2;
        if (string == null) {
            return null;
        }
        for (i2 = string.length() - 1; i2 >= 0 && Character.isWhitespace(string.charAt(i2)); --i2) {
        }
        return string.substring(0, i2 + 1);
    }

    public static String getLastBlockComment(String sqlString) {
        if (StringUtil.isEmpty(sqlString) || sqlString.length() < 4) {
            return null;
        }
        StringBuilder reversedSqlStringBuilder = new StringBuilder(sqlString).reverse();
        String reversedString = reversedSqlStringBuilder.toString();
        int idxClosingLastChar = -1;
        int idxOpeningFirstChar = -1;
        for (int i2 = 0; i2 < reversedString.length(); ++i2) {
            char s2;
            char c2;
            if (idxClosingLastChar < 0) {
                c2 = reversedString.charAt(i2);
                if (c2 == '/') {
                    s2 = reversedString.charAt(i2 + 1);
                    if (s2 != '*') continue;
                    idxClosingLastChar = i2;
                    continue;
                }
                if (Character.isWhitespace(c2)) continue;
                return null;
            }
            c2 = reversedString.charAt(i2);
            if (c2 != '/') continue;
            s2 = reversedString.charAt(i2 - 1);
            char e2 = reversedString.charAt(i2 + 1);
            if (s2 != '*' || e2 == '\\') continue;
            idxOpeningFirstChar = i2;
            break;
        }
        int idxOfLastBlockComment = sqlString.length() - (idxOpeningFirstChar + 1);
        return sqlString.substring(idxOfLastBlockComment);
    }

    public static String getLastLineComment(String sqlString) {
        if (StringUtil.isEmpty(sqlString) || sqlString.length() < 2) {
            return null;
        }
        boolean startOfNewLine = false;
        int idxOfDoubleDash = -1;
        for (int i2 = 0; i2 < sqlString.length(); ++i2) {
            char c2 = sqlString.charAt(i2);
            if (c2 == '-') {
                char s2 = sqlString.charAt(i2 + 1);
                if (s2 != '-') continue;
                if (idxOfDoubleDash < 0) {
                    idxOfDoubleDash = i2;
                }
                startOfNewLine = false;
                continue;
            }
            if (!Character.isWhitespace(c2)) {
                if (!startOfNewLine) continue;
                idxOfDoubleDash = -1;
                continue;
            }
            if (c2 != '\r' && c2 != '\n') continue;
            startOfNewLine = true;
        }
        if (idxOfDoubleDash < 0) {
            return null;
        }
        return sqlString.substring(idxOfDoubleDash);
    }

    public static String stripSqlCommentsAndWhitespacesFromTheEnd(String sqlString) {
        if (StringUtil.isEmpty(sqlString)) {
            return sqlString;
        }
        StringBuilder str = new StringBuilder(sqlString);
        boolean strModified = true;
        while (strModified) {
            String lastLineComment;
            strModified = false;
            String lastBlockComment = StringUtil.getLastBlockComment(str.toString());
            if (lastBlockComment != null && !lastBlockComment.isEmpty()) {
                str.setLength(str.length() - lastBlockComment.length());
                strModified = true;
            }
            if ((lastLineComment = StringUtil.getLastLineComment(str.toString())) == null || lastLineComment.isEmpty()) continue;
            str.setLength(str.length() - lastLineComment.length());
            strModified = true;
        }
        return StringUtil.trimRight(str.toString());
    }

    public static String concatConsistentCase(String baseString, String addition) {
        boolean hasLowerCase = StringUtil.hasLowerCase(baseString);
        boolean hasUpperCase = StringUtil.hasUpperCase(baseString);
        if (hasLowerCase && hasUpperCase || !hasLowerCase && !hasUpperCase) {
            return baseString + addition;
        }
        if (hasLowerCase) {
            return baseString + addition.toLowerCase();
        }
        return baseString + addition.toUpperCase();
    }

    public static String stripEnclosingQuotes(String string) {
        if (string.length() > 1 && (string.charAt(0) == '\"' || string.charAt(0) == '\'') && string.charAt(0) == string.charAt(string.length() - 1)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean equalsWordNull(String value) {
        return "NULL".equalsIgnoreCase(value);
    }

    public static String[] splitCamelCase(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new String[0];
        }
        char[] c2 = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c2[tokenStart]);
        for (int pos = tokenStart + 1; pos < c2.length; ++pos) {
            int type = Character.getType(c2[pos]);
            if (type == currentType) continue;
            if (type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c2, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c2, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c2, tokenStart, c2.length - tokenStart));
        return list.toArray(new String[0]);
    }

    public static byte[] getBytesWithEncoding(String string) {
        if (string == null) {
            return null;
        }
        String encoding = null;
        try {
            encoding = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentConfiguredValue().getValue();
            if (encoding != null) {
                return string.getBytes(encoding);
            }
        }
        catch (UnsupportedEncodingException uoe) {
            Scope.getCurrentScope().getLog(StringUtil.class).warning("Error using encoding " + encoding);
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean isNumeric(CharSequence cs2) {
        if (StringUtil.isEmpty(cs2)) {
            return false;
        }
        int sz = cs2.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isDigit(cs2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs2) {
        return cs2 == null || cs2.length() == 0;
    }

    public static class DefaultFormatter
    implements StringUtilFormatter {
        public String toString(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Class) {
                return ((Class)obj).getName();
            }
            if (obj instanceof Object[]) {
                if (((Object[])obj).length == 0) {
                    return null;
                }
                return "[" + StringUtil.join((Object[])obj, ", ", (StringUtilFormatter)this) + "]";
            }
            if (obj instanceof Collection) {
                if (((Collection)obj).size() == 0) {
                    return null;
                }
                return "[" + StringUtil.join((Collection)obj, ", ", (StringUtilFormatter)this) + "]";
            }
            return obj.toString();
        }
    }

    public static class ToStringFormatter
    implements StringUtilFormatter {
        public String toString(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }

    public static interface StringUtilFormatter<Type> {
        public String toString(Type var1);
    }
}

