/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.UnexpectedValidationException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.AbstractDatabaseMetaDataCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.DatabaseException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.Named;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;

public class JdbcDatabaseMetaDataCapability
extends AbstractDatabaseMetaDataCapability {
    private static final String VIEW = "VIEW";
    private static final String TABLE = "TABLE";
    private static final String COLUMN = "COLUMN";
    private static final Logger LOG = Logger.getLogger(JdbcDatabaseMetaDataCapability.class.getName());

    public JdbcDatabaseMetaDataCapability(Connection connection, UnaryOperator<String> unaryOperator) {
        super(connection, unaryOperator);
    }

    public JdbcDatabaseMetaDataCapability(Connection connection, UnaryOperator<String> unaryOperator, boolean bl2) {
        super(connection, unaryOperator, bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean columnExists(Map<Named, Boolean> map, Named named2) {
        String[] stringArray = this.splitAndValidateMinMax(COLUMN, named2.getFqnLookup(), 1, 4);
        String string = stringArray[stringArray.length - 1];
        Object object = named2.getParents().isEmpty() ? Arrays.asList(NamedObject.table) : named2.getParents();
        int n2 = named2.getFqnLookup().lastIndexOf(".");
        String string2 = n2 != -1 ? named2.getFqnLookup().substring(0, n2) : null;
        object = string2 != null ? named -> object.contains((Object)named.getNamedObject()) && (string2.equals(named.getAliasLookup()) || string2.equals(named.getFqnLookup())) : named -> object.contains((Object)named.getNamedObject());
        object = map.keySet().stream().filter(object).map(Named::getFqnLookup).collect(Collectors.toList());
        if (object.isEmpty()) {
            object = Collections.singletonList(string2);
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            Throwable throwable;
            Object object3;
            block19: {
                string2 = (String)object.next();
                if (this.existsFromItem(map, string2)) {
                    object3 = String.format("SELECT * FROM %s", string2);
                    try {
                        object3 = this.connection.prepareStatement((String)object3);
                        throwable = null;
                        try {
                            object2 = object3.getMetaData();
                            break block19;
                        }
                        catch (Throwable throwable2) {
                            try {
                                object2 = throwable2;
                                throwable = throwable2;
                                throw object2;
                            }
                            catch (Throwable throwable3) {
                                if (object3 == null) throw throwable3;
                                if (throwable == null) {
                                    object3.close();
                                    throw throwable3;
                                }
                                try {
                                    object3.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        throw this.createDatabaseException(string2, COLUMN, sQLException);
                    }
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine(String.format("%s does not exists, cannot evaluate COLUMN from %s", string2, named2.getFqn()));
                continue;
            }
            for (int i2 = 1; i2 <= object2.getColumnCount(); ++i2) {
                if (!string.equalsIgnoreCase(object2.getColumnLabel(i2))) continue;
                if (object3 == null) return true;
                if (throwable != null) {
                    try {
                        object3.close();
                        return true;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        return true;
                    }
                }
                object3.close();
                return true;
            }
            if (object3 == null) continue;
            if (throwable != null) {
                try {
                    object3.close();
                }
                catch (Throwable throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                continue;
            }
            object3.close();
        }
        return false;
    }

    private boolean existsFromItem(Map<Named, Boolean> map, String object) {
        return this.viewExists(map, (Named)(object = new Named(NamedObject.table, (String)object).setFqnLookup((String)object))) || this.tableExists(map, (Named)object);
    }

    @Override
    protected boolean viewExists(Map<Named, Boolean> map, Named named) {
        return this.jdbcMetadataTables(named, VIEW);
    }

    @Override
    protected boolean tableExists(Map<Named, Boolean> map, Named named) {
        return this.jdbcMetadataTables(named, TABLE);
    }

    protected boolean jdbcMetadataTables(Named named, String string) {
        Object object;
        String[] stringArray = this.splitAndValidateMinMax(string, named.getFqnLookup(), 1, 3);
        Object object2 = null;
        Object object3 = null;
        if (stringArray.length > 2) {
            object2 = stringArray[0];
            object3 = stringArray[1];
            object = stringArray[2];
        } else if (stringArray.length > 1) {
            object3 = stringArray[0];
            object = stringArray[1];
        } else {
            object = stringArray[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object2 = this.connection.getMetaData().getTables((String)object2, (String)object3, (String)object, new String[]{string});
            object3 = null;
            try {
                while (object2.next()) {
                    object = object2.getString("TABLE_CAT");
                    String string2 = object2.getString("TABLE_SCHEM");
                    String string3 = object2.getString("TABLE_NAME");
                    if (!string3.equalsIgnoreCase(stringArray[stringArray.length - 1])) continue;
                    if (stringArray.length > 1) {
                        if (!string2.equalsIgnoreCase(stringArray[stringArray.length - 2])) continue;
                        if (stringArray.length > 2) {
                            if (!((String)object).equalsIgnoreCase(stringArray[stringArray.length - 3])) continue;
                            arrayList.add(String.join((CharSequence)".", new CharSequence[]{object, string2, string3}));
                            continue;
                        }
                        arrayList.add(String.join((CharSequence)".", string2, string3));
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                object3 = throwable;
                throw object;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.createDatabaseException(named.getFqn(), string, sQLException);
        }
        return !arrayList.isEmpty();
    }

    private String[] splitAndValidateMinMax(String string, String string2, int n2, int n3) {
        String[] stringArray = string2.split("\\.");
        if (stringArray.length < n2 || stringArray.length > n3) {
            throw new UnexpectedValidationException(String.format("%s path-elements count needs to be between %s and %s for %s", string2, n2, n3, string));
        }
        return stringArray;
    }

    private DatabaseException createDatabaseException(String string, String string2, SQLException sQLException) {
        return new DatabaseException(String.format("cannot evaluate existence of %s by name '%s'", string2, string), sQLException);
    }
}

