/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;

class TreeUtil {
    TreeUtil() {
    }

    static <T> int getExpandedDescendantCount(TreeItem<T> treeItem, boolean bl2) {
        if (treeItem == null) {
            return 0;
        }
        if (treeItem.isLeaf()) {
            return 1;
        }
        return treeItem.getExpandedDescendentCount(bl2);
    }

    static int updateExpandedItemCount(TreeItem treeItem, boolean bl2, boolean bl3) {
        if (treeItem == null) {
            return 0;
        }
        if (!treeItem.isExpanded()) {
            return 1;
        }
        int n2 = TreeUtil.getExpandedDescendantCount(treeItem, bl2);
        if (!bl3) {
            --n2;
        }
        return n2;
    }

    static <T> TreeItem<T> getItem(TreeItem<T> treeItem, int n2, boolean bl2) {
        if (treeItem == null) {
            return null;
        }
        if (n2 == 0) {
            return treeItem;
        }
        if (n2 >= TreeUtil.getExpandedDescendantCount(treeItem, bl2)) {
            return null;
        }
        ObservableList<TreeItem<T>> observableList = treeItem.getChildren();
        if (observableList == null) {
            return null;
        }
        int n3 = n2 - 1;
        int n4 = observableList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            TreeItem treeItem2 = (TreeItem)observableList.get(i2);
            if (n3 == 0) {
                return treeItem2;
            }
            if (treeItem2.isLeaf() || !treeItem2.isExpanded()) {
                --n3;
                continue;
            }
            int n5 = TreeUtil.getExpandedDescendantCount(treeItem2, bl2);
            if (n3 >= n5) {
                n3 -= n5;
                continue;
            }
            TreeItem<T> treeItem3 = TreeUtil.getItem(treeItem2, n3, bl2);
            if (treeItem3 != null) {
                return treeItem3;
            }
            --n3;
        }
        return null;
    }

    static <T> int getRow(TreeItem<T> treeItem, TreeItem<T> treeItem2, boolean bl2, boolean bl3) {
        if (treeItem == null) {
            return -1;
        }
        if (bl3 && treeItem.equals(treeItem2)) {
            return 0;
        }
        int n2 = 0;
        TreeItem<T> treeItem3 = treeItem;
        TreeItem<T> treeItem4 = treeItem.getParent();
        boolean bl4 = false;
        while (!treeItem3.equals(treeItem2) && treeItem4 != null) {
            if (!treeItem4.isExpanded()) {
                bl4 = true;
                break;
            }
            ObservableList observableList = treeItem4.children;
            int n3 = observableList.indexOf(treeItem3);
            for (int i2 = n3 - 1; i2 > -1; --i2) {
                TreeItem treeItem5 = (TreeItem)observableList.get(i2);
                if (treeItem5 == null) continue;
                n2 += TreeUtil.getExpandedDescendantCount(treeItem5, bl2);
                if (!treeItem5.equals(treeItem2)) continue;
                if (!bl3) {
                    return -1;
                }
                return n2;
            }
            treeItem3 = treeItem4;
            if ((treeItem4 = treeItem4.getParent()) == null && !treeItem3.equals(treeItem2)) {
                return -1;
            }
            ++n2;
        }
        return treeItem4 == null && n2 == 0 || bl4 ? -1 : (bl3 ? n2 : n2 - 1);
    }
}

