/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.activation.UnsupportedDataTypeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

class ObjectDataContentHandler
implements DataContentHandler {
    private ActivationDataFlavor[] transferFlavors = null;
    private Object obj;
    private String mimeType;
    private DataContentHandler dch = null;

    public ObjectDataContentHandler(DataContentHandler dch, Object obj, String mimeType) {
        this.obj = obj;
        this.mimeType = mimeType;
        this.dch = dch;
    }

    public DataContentHandler getDCH() {
        return this.dch;
    }

    @Override
    public synchronized ActivationDataFlavor[] getTransferDataFlavors() {
        if (this.transferFlavors == null) {
            if (this.dch != null) {
                this.transferFlavors = this.dch.getTransferDataFlavors();
            } else {
                this.transferFlavors = new ActivationDataFlavor[1];
                this.transferFlavors[0] = new ActivationDataFlavor(this.obj.getClass(), this.mimeType, this.mimeType);
            }
        }
        return this.transferFlavors;
    }

    @Override
    public Object getTransferData(ActivationDataFlavor df2, DataSource ds2) throws IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(df2, ds2);
        }
        if (df2.equals(this.getTransferDataFlavors()[0])) {
            return this.obj;
        }
        throw new IOException("Unsupported DataFlavor: " + df2);
    }

    @Override
    public Object getContent(DataSource ds2) {
        return this.obj;
    }

    @Override
    public void writeTo(Object obj, String mimeType, OutputStream os2) throws IOException {
        if (this.dch != null) {
            this.dch.writeTo(obj, mimeType, os2);
        } else if (obj instanceof byte[]) {
            os2.write((byte[])obj);
        } else if (obj instanceof String) {
            OutputStreamWriter osw = new OutputStreamWriter(os2);
            osw.write((String)obj);
            osw.flush();
        } else {
            throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.mimeType);
        }
    }
}

