/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandInfo;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.activation.MailcapCommandMap;
import jakarta.activation.SecuritySupport;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class CommandMap {
    private static CommandMap defaultCommandMap = null;
    private static Map<ClassLoader, CommandMap> map = new WeakHashMap<ClassLoader, CommandMap>();

    public static synchronized CommandMap getDefaultCommandMap() {
        if (defaultCommandMap != null) {
            return defaultCommandMap;
        }
        ClassLoader tccl = SecuritySupport.getContextClassLoader();
        CommandMap def = map.get(tccl);
        if (def == null) {
            def = new MailcapCommandMap();
            map.put(tccl, def);
        }
        return def;
    }

    public static synchronized void setDefaultCommandMap(CommandMap commandMap) {
        block3: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                try {
                    security.checkSetFactory();
                }
                catch (SecurityException ex2) {
                    ClassLoader cl2 = CommandMap.class.getClassLoader();
                    if (cl2 != null && cl2.getParent() != null && cl2 == commandMap.getClass().getClassLoader()) break block3;
                    throw ex2;
                }
            }
        }
        map.remove(SecuritySupport.getContextClassLoader());
        defaultCommandMap = commandMap;
    }

    public abstract CommandInfo[] getPreferredCommands(String var1);

    public CommandInfo[] getPreferredCommands(String mimeType, DataSource ds2) {
        return this.getPreferredCommands(mimeType);
    }

    public abstract CommandInfo[] getAllCommands(String var1);

    public CommandInfo[] getAllCommands(String mimeType, DataSource ds2) {
        return this.getAllCommands(mimeType);
    }

    public abstract CommandInfo getCommand(String var1, String var2);

    public CommandInfo getCommand(String mimeType, String cmdName, DataSource ds2) {
        return this.getCommand(mimeType, cmdName);
    }

    public abstract DataContentHandler createDataContentHandler(String var1);

    public DataContentHandler createDataContentHandler(String mimeType, DataSource ds2) {
        return this.createDataContentHandler(mimeType);
    }

    public String[] getMimeTypes() {
        return null;
    }
}

