/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.simple.range;

import de.fraunhofer.iosb.ilt.swe.common.constraint.AllowedValues;
import de.fraunhofer.iosb.ilt.swe.common.simple.AbstractSimpleComponent;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityRange
extends AbstractSimpleComponent<List<BigDecimal>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantityRange.class);
    private String uom;
    private List<BigDecimal> value;
    private AllowedValues constraint;

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.uom);
        hash = 67 * hash + Objects.hashCode(this.value);
        hash = 67 * hash + Objects.hashCode(this.constraint);
        hash = 67 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuantityRange other = (QuantityRange)obj;
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    public String getUom() {
        return this.uom;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    @Override
    public List<BigDecimal> getValue() {
        return this.value;
    }

    @Override
    public void setValue(List<BigDecimal> value) {
        this.value = value;
    }

    public AllowedValues getConstraint() {
        return this.constraint;
    }

    public void setConstraint(AllowedValues constraint) {
        this.constraint = constraint;
    }

    @Override
    public boolean valueIsValid() {
        if (this.getValue() == null) {
            return false;
        }
        if (this.getConstraint() == null) {
            return true;
        }
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            BigDecimal item = (BigDecimal)iterator.next();
            if (this.constraint.isValid(item)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }
}

