/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.simple.range;

import de.fraunhofer.iosb.ilt.swe.common.constraint.AllowedTokens;
import de.fraunhofer.iosb.ilt.swe.common.simple.AbstractSimpleComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryRange
extends AbstractSimpleComponent<List<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryRange.class);
    private List<String> value = new ArrayList<String>();
    private AllowedTokens constraint;
    private Map<String, String> codeSpace;

    public AllowedTokens getConstraint() {
        return this.constraint;
    }

    public void setConstraint(AllowedTokens constraint) {
        this.constraint = constraint;
    }

    @Override
    public List<String> getValue() {
        return this.value;
    }

    @Override
    public void setValue(List<String> value) {
        this.value = value;
    }

    @Override
    public boolean valueIsValid() {
        if (this.value == null) {
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        for (String item : this.value) {
            if (this.constraint.isValid(item)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.value);
        hash = 59 * hash + Objects.hashCode(this.constraint);
        hash = 59 * hash + Objects.hashCode(this.codeSpace);
        hash = 59 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryRange other = (CategoryRange)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        if (!Objects.equals(this.codeSpace, other.codeSpace)) {
            return false;
        }
        return super.equals(obj);
    }
}

