/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.complex;

import de.fraunhofer.iosb.ilt.swe.common.AbstractDataComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataRecord
extends AbstractDataComponent<Map<String, Object>> {
    private List<AbstractDataComponent> field;

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.field);
        hash = 29 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataRecord other = (DataRecord)obj;
        if (!Objects.equals(this.field, other.field)) {
            return false;
        }
        return super.equals(obj);
    }

    @Deprecated
    public List<AbstractDataComponent> getFields() {
        return this.getField();
    }

    public List<AbstractDataComponent> getField() {
        if (this.field == null) {
            this.field = new ArrayList<AbstractDataComponent>();
        }
        return this.field;
    }

    public void setField(List<AbstractDataComponent> field) {
        this.field = field;
    }

    public Optional<AbstractDataComponent> getFieldByName(String name) {
        return this.getField().stream().filter(f2 -> f2.getName().equals(name)).findFirst();
    }

    public void addDataComponent(AbstractDataComponent field) {
        String name = field.getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Field must have a non-empty name");
        }
        if (this.getFieldByName(name).isPresent()) {
            throw new IllegalArgumentException("Field with name " + name + " is already present");
        }
        this.getField().add(field);
    }

    @Override
    public Map<String, Object> getValue() {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        for (AbstractDataComponent f2 : this.field) {
            value.put(f2.getName(), f2.getValue());
        }
        return value;
    }

    @Override
    public void setValue(Map<String, Object> value) {
        if (this.field == null) {
            return;
        }
        for (AbstractDataComponent f2 : this.field) {
            Object fieldValue = value.get(f2.getName());
            if (fieldValue == null) continue;
            f2.setValue(fieldValue);
        }
    }

    @Override
    public boolean valueIsValid() {
        if (this.field == null) {
            return true;
        }
        for (AbstractDataComponent f2 : this.field) {
            if (f2.valueIsValid()) continue;
            return false;
        }
        return true;
    }
}

