/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common;

import de.fraunhofer.iosb.ilt.swe.common.AbstractSWEIdentifiable;
import java.util.Objects;

public abstract class AbstractDataComponent<V>
extends AbstractSWEIdentifiable {
    private String name;
    private String definition;
    private boolean optional;
    private boolean updatable;

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.definition);
        hash = 29 * hash + (this.optional ? 1 : 0);
        hash = 29 * hash + (this.updatable ? 1 : 0);
        hash = 29 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDataComponent other = (AbstractDataComponent)obj;
        if (this.optional != other.optional) {
            return false;
        }
        if (this.updatable != other.updatable) {
            return false;
        }
        if (!Objects.equals(this.definition, other.definition)) {
            return false;
        }
        return super.equals(obj);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isOptional() {
        return this.optional;
    }

    public Boolean isUpdatable() {
        return this.updatable;
    }

    public abstract boolean valueIsValid();

    public abstract V getValue();

    public abstract void setValue(V var1);

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }
}

