/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.service.TokenManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.Calendar;
import org.apache.http.Consts;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManagerJWT
implements TokenManager<TokenManagerJWT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenManagerJWT.class);
    private static final String AUTH_BODY_TEMPLATE = "{\"id\":\"%1$s\",\"key\":\"%2$s\"}";
    private String tokenServerUrl;
    private String jwtId;
    private String jwtKey;
    private CloseableHttpClient client;
    private String accessToken = "";
    private Calendar expireTime = Calendar.getInstance();
    private int expireDuration = 300;

    @Override
    public void addAuthHeader(HttpRequest request) {
        request.addHeader("Authorization", "Bearer " + this.getToken());
    }

    public boolean isExpired() {
        return this.expireTime.before(Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchToken() {
        String json = null;
        Closeable response = null;
        try {
            HttpPost tokenRequest = new HttpPost(this.tokenServerUrl);
            tokenRequest.setHeader("Content-Type", "application/json");
            String body = String.format(AUTH_BODY_TEMPLATE, this.jwtId, this.jwtKey);
            tokenRequest.setEntity(new StringEntity(body));
            response = this.client.execute(tokenRequest);
            json = EntityUtils.toString(response.getEntity(), Consts.UTF_8);
        }
        catch (IOException ex2) {
            LOGGER.error("Failed to fetch Token.", ex2);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex2) {
                    LOGGER.error("Exception closing response after exception!", ex2);
                }
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        String currentToken = this.accessToken;
        if (!currentToken.isEmpty() && !this.isExpired()) {
            return currentToken;
        }
        TokenManagerJWT tokenManagerJWT = this;
        synchronized (tokenManagerJWT) {
            this.accessToken = "";
            String json = this.fetchToken();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode tree = objectMapper.readTree(json);
                if (tree.isObject()) {
                    JsonNode node = tree.get("token");
                    if (node == null) {
                        throw new IllegalStateException("Did not receive an access_token. Received: " + json);
                    }
                    this.accessToken = node.textValue();
                    this.validateToken(this.accessToken);
                    this.expireTime = Calendar.getInstance();
                    this.expireTime.add(13, Math.max(this.expireDuration - 10, 10));
                }
                LOGGER.debug("Token: {}", (Object)this.accessToken);
                return this.accessToken;
            }
            catch (IOException ex2) {
                LOGGER.error("Failed to parse response.", ex2);
                return null;
            }
        }
    }

    public boolean validateToken(String token) {
        return true;
    }

    @Override
    public TokenManagerJWT setHttpClient(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    @Override
    public CloseableHttpClient getHttpClient() {
        return this.client;
    }

    public TokenManagerJWT setTokenServerUrl(String tokenServerUrl) {
        this.tokenServerUrl = tokenServerUrl;
        return this;
    }

    public TokenManagerJWT setJwtId(String jwtId) {
        this.jwtId = jwtId;
        return this;
    }

    public TokenManagerJWT setJwtKey(String jwtKey) {
        this.jwtKey = jwtKey;
        return this;
    }
}

