/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(value={"dataArray@iot.count"})
public class DataArrayValue {
    @JsonProperty(value="Datastream")
    private Datastream datastream;
    @JsonProperty(value="MultiDatastream")
    private MultiDatastream multiDatastream;
    @JsonIgnore
    private VisibleProperties visibleProperties;
    @JsonProperty(value="components")
    private List<String> components;
    @JsonProperty(value="dataArray")
    private List<List<Object>> dataArray = new ArrayList<List<Object>>();
    @JsonIgnore
    private List<Observation> observations = new ArrayList<Observation>();

    public DataArrayValue() {
        this.visibleProperties = new VisibleProperties(true);
        this.components = this.visibleProperties.getComponents();
    }

    public DataArrayValue(Datastream datastream, Set<Property> properties) {
        this.datastream = datastream.withOnlyId();
        this.visibleProperties = new VisibleProperties(properties);
        this.components = this.visibleProperties.getComponents();
    }

    public DataArrayValue(MultiDatastream multiDatastream, Set<Property> properties) {
        this.multiDatastream = multiDatastream.withOnlyId();
        this.visibleProperties = new VisibleProperties(properties);
        this.components = this.visibleProperties.getComponents();
    }

    public Datastream getDatastream() {
        return this.datastream;
    }

    public void setDatastream(Datastream datastream) {
        if (this.multiDatastream != null) {
            throw new IllegalArgumentException("Can not have both a Datastream and a MultiDatastream.");
        }
        this.datastream = datastream.withOnlyId();
    }

    public MultiDatastream getMultiDatastream() {
        return this.multiDatastream;
    }

    public void setMultiDatastream(MultiDatastream multiDatastream) {
        if (this.datastream != null) {
            throw new IllegalArgumentException("Can not have both a Datastream and a MultiDatastream.");
        }
        this.multiDatastream = multiDatastream.withOnlyId();
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(Set<Property> properties) {
        if (!this.dataArray.isEmpty()) {
            throw new IllegalStateException("Can not change components after adding Observations.");
        }
        this.visibleProperties = new VisibleProperties(properties);
        this.components = this.visibleProperties.getComponents();
    }

    public void addObservation(Observation o2) {
        this.dataArray.add(this.visibleProperties.fromObservation(o2));
        this.observations.add(o2);
    }

    public List<Observation> getObservations() {
        return this.observations;
    }

    public List<List<Object>> getDataArray() {
        return this.dataArray;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.datastream);
        hash = 29 * hash + Objects.hashCode(this.multiDatastream);
        hash = 29 * hash + Objects.hashCode(this.components);
        hash = 29 * hash + Objects.hashCode(this.dataArray);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataArrayValue other = (DataArrayValue)obj;
        if (!Objects.equals(this.datastream, other.datastream)) {
            return false;
        }
        if (!Objects.equals(this.multiDatastream, other.multiDatastream)) {
            return false;
        }
        if (!Objects.equals(this.components, other.components)) {
            return false;
        }
        return Objects.equals(this.dataArray, other.dataArray);
    }

    public static String dataArrayKeyFor(Observation observation) {
        Datastream ds2 = null;
        try {
            ds2 = observation.getDatastream();
        }
        catch (ServiceFailureException serviceFailureException) {
            // empty catch block
        }
        if (ds2 == null) {
            MultiDatastream mds = null;
            try {
                mds = observation.getMultiDatastream();
            }
            catch (ServiceFailureException serviceFailureException) {
                // empty catch block
            }
            if (mds == null) {
                throw new IllegalArgumentException("Observation must have a Datastream or MultiDatastream.");
            }
            return "mds-" + mds.getId().toString();
        }
        return "ds-" + ds2.getId().toString();
    }

    public static class VisibleProperties {
        public final boolean id;
        public final boolean phenomenonTime;
        public final boolean result;
        public final boolean resultTime;
        public final boolean resultQuality;
        public final boolean validTime;
        public final boolean parameters;
        public final boolean featureOfInterest;

        public VisibleProperties() {
            this(false);
        }

        public VisibleProperties(boolean allValue) {
            this.id = allValue;
            this.phenomenonTime = allValue;
            this.result = allValue;
            this.resultTime = allValue;
            this.resultQuality = allValue;
            this.validTime = allValue;
            this.parameters = allValue;
            this.featureOfInterest = allValue;
        }

        public VisibleProperties(Set<Property> select) {
            this.id = select.contains((Object)Property.Id);
            this.phenomenonTime = select.contains((Object)Property.PhenomenonTime);
            this.result = select.contains((Object)Property.Result);
            this.resultTime = select.contains((Object)Property.ResultTime);
            this.resultQuality = select.contains((Object)Property.ResultQuality);
            this.validTime = select.contains((Object)Property.ValidTime);
            this.parameters = select.contains((Object)Property.Parameters);
            this.featureOfInterest = select.contains((Object)Property.FeatureOfInterest);
        }

        public List<String> getComponents() {
            ArrayList<String> components = new ArrayList<String>();
            if (this.id) {
                components.add(Property.Id.name);
            }
            if (this.phenomenonTime) {
                components.add(Property.PhenomenonTime.name);
            }
            if (this.result) {
                components.add(Property.Result.name);
            }
            if (this.resultTime) {
                components.add(Property.ResultTime.name);
            }
            if (this.resultQuality) {
                components.add(Property.ResultQuality.name);
            }
            if (this.validTime) {
                components.add(Property.ValidTime.name);
            }
            if (this.parameters) {
                components.add(Property.Parameters.name);
            }
            if (this.featureOfInterest) {
                components.add(Property.FeatureOfInterest.name);
            }
            return components;
        }

        public List<Object> fromObservation(Observation o2) {
            ArrayList<Object> value = new ArrayList<Object>();
            if (this.id) {
                value.add(o2.getId());
            }
            if (this.phenomenonTime) {
                value.add(o2.getPhenomenonTime());
            }
            if (this.result) {
                value.add(o2.getResult());
            }
            if (this.resultTime) {
                value.add(o2.getResultTime());
            }
            if (this.resultQuality) {
                value.add(o2.getResultQuality());
            }
            if (this.validTime) {
                value.add(o2.getValidTime());
            }
            if (this.parameters) {
                value.add(o2.getParameters());
            }
            if (this.featureOfInterest) {
                try {
                    value.add(o2.getFeatureOfInterest().getId());
                }
                catch (ServiceFailureException ex2) {
                    value.add(null);
                }
            }
            return value;
        }
    }

    public static enum Property {
        Id("id"),
        PhenomenonTime("phenomenonTime"),
        Result("result"),
        ResultTime("resultTime"),
        ResultQuality("resultQuality"),
        ValidTime("validTime"),
        Parameters("parameters"),
        FeatureOfInterest("FeatureOfInterest/id");

        public final String name;

        private Property(String name) {
            this.name = name;
        }
    }
}

