/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.threeten.extra.Interval;

public class TimeObject {
    private Interval valueInterval;
    private ZonedDateTime valueDateTime;
    private final boolean interval;

    public TimeObject(Interval value) {
        this.valueInterval = value;
        this.interval = true;
    }

    public TimeObject(ZonedDateTime value) {
        this.valueDateTime = value;
        this.interval = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeObject other = (TimeObject)obj;
        if (this.interval != other.interval) {
            return false;
        }
        if (!Objects.equals(this.valueInterval, other.valueInterval)) {
            return false;
        }
        return Objects.equals(this.valueDateTime, other.valueDateTime);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.valueInterval);
        hash = 29 * hash + Objects.hashCode(this.valueDateTime);
        hash = 29 * hash + (this.interval ? 1 : 0);
        return hash;
    }

    public boolean isInterval() {
        return this.interval;
    }

    public Interval getAsInterval() {
        if (this.interval) {
            return this.valueInterval;
        }
        return null;
    }

    public ZonedDateTime getAsDateTime() {
        if (this.interval) {
            return null;
        }
        return this.valueDateTime;
    }

    public String toString() {
        if (this.interval) {
            return this.valueInterval.toString();
        }
        return this.valueDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static TimeObject parse(String value) {
        try {
            ZonedDateTime dt2 = ZonedDateTime.parse(value);
            return new TimeObject(dt2);
        }
        catch (DateTimeParseException dt2) {
            Interval i2 = Interval.parse(value);
            return new TimeObject(i2);
        }
    }
}

